/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.wizard;

import com.ericsson.ere.gui.wizard.AbstractWizardModel;
import com.ericsson.ere.gui.wizard.panels.WizardStateView;

public abstract class AbstractWizardState {
    protected AbstractWizardState myPreviousState;
    protected AbstractWizardState myNextState;
    protected AbstractWizardModel myModel;

    protected AbstractWizardState(AbstractWizardModel model) {
        this.myModel = model;
    }

    public void selectPreviousState() {
        if (this.myPreviousState != null) {
            this.myModel.setCurrentState(this.myPreviousState);
        }
    }

    public void selectNextState() {
        if (this.myNextState != null) {
            this.myModel.setCurrentState(this.myNextState);
        }
    }

    public abstract void activate();

    public abstract WizardStateView getPanel();

    public void setAdjacentStates(AbstractWizardState previousState, AbstractWizardState nextState) {
        this.myPreviousState = previousState;
        this.myNextState = nextState;
    }

    public void cancelStateActions() {
    }

    public void setBackEnabled(boolean setEnabled) {
        if (!setEnabled || setEnabled && this.myPreviousState != null) {
            this.myModel.setBackEnabled(setEnabled);
        }
    }

    public void setNextEnabled(boolean setEnabled) {
        if (!setEnabled || setEnabled && this.myNextState != null) {
            this.myModel.setNextEnabled(setEnabled);
        }
    }

    public void setBackAndNextEnabled(boolean setBackEnabled, boolean setNextEnabled) {
        boolean backIsOK = setBackEnabled && this.myPreviousState != null;
        boolean nextIsOK = setNextEnabled && this.myNextState != null;
        this.myModel.setBackAndNextEnabled(backIsOK, nextIsOK);
    }
}

