/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import com.ericsson.ere.gui.util.CalendarModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TimeFieldDocument
extends PlainDocument {
    private CalendarModel myCalendarModel;
    private int myEditField;
    private int myMin;
    private int myMax;

    public TimeFieldDocument(CalendarModel calModel, int editField) {
        this.myCalendarModel = calModel;
        this.myEditField = editField;
        this.setMaxAndMin();
    }

    private void setMaxAndMin() {
        switch (this.myEditField) {
            case 10: 
            case 11: {
                this.myMin = this.myCalendarModel.getCalendar().getActualMinimum(11);
                this.myMax = this.myCalendarModel.getCalendar().getActualMaximum(11);
                break;
            }
            case 12: {
                this.myMin = this.myCalendarModel.getCalendar().getActualMinimum(12);
                this.myMax = this.myCalendarModel.getCalendar().getActualMaximum(12);
                break;
            }
            case 13: {
                this.myMin = this.myCalendarModel.getCalendar().getActualMinimum(13);
                this.myMax = this.myCalendarModel.getCalendar().getActualMaximum(13);
            }
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String numbersOnlyString = "";
        int start = 0;
        this.setMaxAndMin();
        char[] chars = str.toCharArray();
        for (int i = start; i < chars.length; ++i) {
            if (!Character.isDigit(chars[i])) continue;
            numbersOnlyString = numbersOnlyString + chars[i];
        }
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + numbersOnlyString + afterOffset;
        if (proposedResult.length() == 0) {
            return;
        }
        try {
            long longProposedResult = Long.parseLong(proposedResult);
            if (longProposedResult <= (long)this.myMax && longProposedResult >= (long)this.myMin) {
                super.insertString(offs, numbersOnlyString, a);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

