/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.datatype.MultiplierNumber;
import com.ericsson.ere.expression.Add;
import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.FieldValueOperand;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.expression.Operators;
import com.ericsson.ere.expression.Subtract;
import com.ericsson.ere.expression.Unit;
import com.ericsson.ere.expression.UnitOperand;
import com.ericsson.ere.expression.ValueOperand;
import com.ericsson.ere.expression.parser.AbstractExpressionParserHandler;
import com.ericsson.ere.expression.parser.DefaultExpressionParserOptions;
import com.ericsson.ere.expression.parser.ExpressionParser;
import com.ericsson.ere.expression.parser.ParseException;
import com.ericsson.ere.expression.parser.ParseableExpressionFormatter;
import com.ericsson.ere.selectiontree.modifiers.DefaultDataSetValueReader;
import com.ericsson.ere.selectiontree.modifiers.mfo.ValueFieldCompositeOperand;
import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.VariableFactory;
import ericsson.vareditor.VarTable2;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.components.SelectableMultipler;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.MultiplierSelectEditorVariable;
import ericsson.vareditor.variable.MultiplierSelectEditorVariable2;
import ericsson.vareditor.variable.PanelVariableEditor;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.ValueFieldPanel;
import ericsson.vareditor.variable.ValueFieldVariable;
import ericsson.vareditor.variable.Variable;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.w3c.dom.Element;

public abstract class RelativeDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -8821957154102224377L;
    private SelectableMultipler[] myUnitOptions;
    private VarTable2 myTable;
    protected ValueFieldCompositeObject myFirstField;
    protected String myOperation;
    protected int mySecondValue;
    private JButton myOkButton;
    private JButton myCancelButton;
    private String myValue;
    protected Unit myUnit;
    private ValueFieldVariable myValueFieldVariable;
    private Variable myIndexVariable;
    private TypedDropDownVariable<String> myDropDownVariable;
    private MultiplierSelectEditorVariable2 myUnitVariable;
    private boolean myChangeOkBool;
    private VarTableModel myModel;
    private final ClassRepository myRep;
    private String myOldField;
    private boolean myOldFieldMode;
    private DataType myType;
    protected Unit[] myUnits;
    protected FieldDefinition myField;

    public RelativeDialog(Window parent, DataType aType, String aValue, String[] possibleFields, Unit[] possibleUnits, ClassRepository aRep, FieldDefinition field) {
        super(parent, "Relative " + aType.getTypeName() + " Chooser", Dialog.ModalityType.APPLICATION_MODAL);
        this.myType = aType;
        this.myUnits = possibleUnits;
        this.myField = field;
        this.setLocationRelativeTo(parent);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 12);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.myModel = new VarTableModel();
        this.myValue = aValue;
        this.myRep = aRep;
        this.myUnitOptions = this.createUnitOptions();
        this.extractTokensFromExpression(aValue);
        this.myValueFieldVariable = new RelativeValueFieldVariable(this.myType.getTypeName(), this.myFirstField, possibleFields, this.myType);
        this.myOldField = this.myValueFieldVariable.getValueString();
        this.myOldFieldMode = this.myValueFieldVariable.inFieldMode();
        this.myModel.addRow(this.myValueFieldVariable);
        this.myDropDownVariable = new TypedDropDownVariable<String>("Operation", new String[]{"NONE", "ADD", "SUBTRACT"}, this.myOperation){

            @Override
            public void actionPerformed(ActionEvent anEvent) {
                super.actionPerformed(anEvent);
                RelativeDialog.this.checkOperation();
            }
        };
        MultiplierSelectEditorVariable inner = new MultiplierSelectEditorVariable("Offset", "" + this.mySecondValue, this.myUnit.toString(), this.myUnitOptions, 5);
        this.myUnitVariable = MultiplierSelectEditorVariable2.wrap(inner);
        this.myTable = new VarTable2(this.myModel);
        this.myTable.setName("Relative" + this.myType.getTypeName() + "Dialog.VarTable2.VarTable");
        this.setSize(300, 220);
        this.fillModel();
        this.add((Component)this.myTable, gridBagConstraints);
        this.myOkButton = new JButton("OK");
        this.myOkButton.setPreferredSize(new Dimension(90, 25));
        this.myOkButton.setMinimumSize(new Dimension(90, 25));
        this.myOkButton.setName("Relative" + this.myType.getTypeName() + "Dialog.JButton.OkButton");
        this.myOkButton.addActionListener(this);
        this.myCancelButton = new JButton("Cancel");
        this.myCancelButton.setPreferredSize(new Dimension(90, 25));
        this.myCancelButton.setMinimumSize(new Dimension(90, 25));
        this.myCancelButton.setName("Relative" + this.myType.getTypeName() + "Dialog.JButton.CancelButton");
        this.myCancelButton.addActionListener(this);
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = 0;
        con.anchor = 17;
        con.insets = new Insets(0, 0, 10, 6);
        JPanel theButtonPanel = new JPanel(new GridBagLayout());
        theButtonPanel.add((Component)this.myOkButton, con);
        con.gridx = 1;
        con.gridy = 0;
        con.anchor = 13;
        con.insets = new Insets(0, 0, 10, 0);
        theButtonPanel.add((Component)this.myCancelButton, con);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        this.add((Component)theButtonPanel, gridBagConstraints);
        this.checkOperation();
    }

    protected abstract SelectableMultipler[] createUnitOptions();

    private void checkOperation() {
        this.myOperation = this.myDropDownVariable.getSelectedItem();
        this.fillModel();
    }

    private void fillModel() {
        while (this.myModel.getRowCount() > 0) {
            this.myModel.removeRow(0);
        }
        this.myModel.addRow(this.myValueFieldVariable);
        String value = this.myValueFieldVariable.getValueString();
        if (!"BOT".equals(value) && !"EOT".equals(value)) {
            if (this.myValueFieldVariable.inFieldMode() && this.myIndexVariable != null) {
                this.myModel.addRow(this.myIndexVariable);
            }
            this.myModel.addRow(this.myDropDownVariable);
            if (!this.myOperation.equals("NONE")) {
                this.myModel.addRow(this.myUnitVariable);
            }
        }
    }

    private void extractFirstOperandToken(ExpressionToken theFirstToken) {
        assert (theFirstToken instanceof ValueFieldCompositeOperand);
        ValueFieldCompositeOperand operand = (ValueFieldCompositeOperand)theFirstToken;
        this.myFirstField = operand.getValue();
        if (this.myFirstField.getMode() == ValueFieldCompositeObject.Mode.Field) {
            this.createIndexVariableIfNecessary(operand);
        }
    }

    private void createIndexVariableIfNecessary(ValueFieldCompositeOperand aFirstOperand) {
        String fieldName = this.myFirstField.getFieldOrValueAsString();
        FieldDefinition theDef = this.myRep.getFieldDefinitionByName(fieldName);
        ValueFieldCompositeObject indexObject = aFirstOperand.getIndex();
        this.myIndexVariable = (theDef.isArray() || theDef.isMap()) && indexObject != null ? FieldOrientedPluginProfileUtil.createIndexVariable("Index", null, theDef, this.myRep, indexObject, false) : null;
    }

    private void extractOperationToken(ExpressionToken aToken) {
        if (!this.operatorIsAllowed(aToken)) {
            throw new IllegalArgumentException("The only operators allowed in the expression are ADD and SUBTRACT, and the expression contained " + aToken == null ? null : aToken.toString());
        }
        this.myOperation = aToken.toString().equals("+") ? "ADD" : "SUBTRACT";
    }

    private boolean operatorIsAllowed(ExpressionToken token) {
        Class<?> clazz = token.getClass();
        return clazz == Add.class || clazz == Subtract.class;
    }

    private void extractSecondOperandToken(ExpressionToken aToken) {
        Operand valueOperand;
        UnitOperand theUnitOperand;
        if (aToken instanceof UnitOperand) {
            theUnitOperand = (UnitOperand)aToken;
            valueOperand = theUnitOperand.getOperand();
            assert (valueOperand instanceof ValueFieldCompositeOperand);
        } else {
            throw new IllegalArgumentException("Second operand token in expression must be a unit, not " + (aToken == null ? null : aToken.toString()));
        }
        ValueFieldCompositeOperand vop = (ValueFieldCompositeOperand)valueOperand;
        ValueFieldCompositeObject vfco = vop.getValue();
        this.mySecondValue = ((Number)vfco.getValueAsObject()).intValue();
        this.myUnit = theUnitOperand.getUnit();
    }

    protected abstract void setDefault();

    private void extractTokensFromExpression(String aValue) {
        if (aValue == null || aValue.length() == 0) {
            this.setDefault();
            return;
        }
        ExpressionParser theParser = new ExpressionParser(new DefaultExpressionParserOptions(), new MyExpressionParserHandler());
        Expression expression = null;
        try {
            expression = theParser.parse(aValue);
        }
        catch (Exception e) {
            this.setDefault();
            return;
        }
        List<ExpressionToken> theTokens = expression.getExpressionTokens();
        if (theTokens != null && theTokens.size() > 0) {
            this.extractFirstOperandToken(theTokens.get(0));
            if (theTokens.size() == 1) {
                this.myOperation = "NONE";
                this.mySecondValue = 0;
                this.myUnit = this.myUnits[0];
            } else if (theTokens.size() == 3) {
                this.extractOperationToken(theTokens.get(1));
                this.extractSecondOperandToken(theTokens.get(2));
            } else {
                throw new IllegalArgumentException("The expression seems to have an invalid amount (" + theTokens.size() + ") of tokens; valid is one or three.");
            }
        }
    }

    private String createExpressionString() {
        String theOperator;
        boolean isBotOrEot;
        ValueFieldCompositeObject theValue = (ValueFieldCompositeObject)this.myValueFieldVariable.getValueObject();
        ValueOperand<Object> operand1 = theValue.getMode() == ValueFieldCompositeObject.Mode.Field ? this.createFieldValueOperand(theValue) : ValueOperand.createFor(theValue.getValueAsObject());
        ArrayList<ExpressionToken> tokens = new ArrayList<ExpressionToken>();
        tokens.add(operand1);
        boolean bl = isBotOrEot = theValue.getMode() == ValueFieldCompositeObject.Mode.Value && ("BOT".equals(theValue.getFieldOrValueAsString()) || "EOT".equals(theValue.getFieldOrValueAsString()));
        if (!isBotOrEot && !"NONE".equals(theOperator = this.myDropDownVariable.getSelectedItem())) {
            Operator operator = "ADD".equals(theOperator) ? Operators.ADD : Operators.SUBTRACT;
            MultiplierNumber theNumber = (MultiplierNumber)this.myUnitVariable.getValueObject();
            Operand operand2 = ValueOperand.createFor(theNumber.getValue().intValue());
            int unitIdx = (int)theNumber.getMultiplier();
            operand2 = UnitOperand.create(operand2, this.myUnits[unitIdx]);
            tokens.add(operator);
            tokens.add(operand2);
        }
        Expression e = new Expression(tokens, Expression.ExpressionNotation.INFIX);
        return new ParseableExpressionFormatter(this.myRep).format(e);
    }

    private Operand createFieldValueOperand(ValueFieldCompositeObject theValue) {
        FieldDefinition fd = this.myRep.getFieldDefinitionByName(theValue.getFieldOrValueAsString());
        FieldIndexKeyContainer key = null;
        if (this.myIndexVariable != null) {
            ValueFieldCompositeObject theIndex = (ValueFieldCompositeObject)this.myIndexVariable.getValueObject();
            FieldIndexKeyContainer.KeyType keyType = fd.isArray() ? FieldIndexKeyContainer.KeyType.VALUE_LIST : FieldIndexKeyContainer.KeyType.VALUE_MAP;
            List<FieldDefinition> keyFieldList = FieldOrientedPluginUtil.extractKeyFields(fd, this.myRep);
            FieldDefinition[] keyFields = keyFieldList.isEmpty() ? null : keyFieldList.toArray(new FieldDefinition[keyFieldList.size()]);
            key = new FieldIndexKeyContainer(theIndex, keyType, this.myRep, keyFields);
        }
        return new FieldValueOperand(new DataSetField(fd), key, DefaultDataSetValueReader.INSTANCE);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myOkButton) {
            if (!this.myUnitVariable.isValueValid() || !this.myValueFieldVariable.isValueValid()) {
                return;
            }
            this.myValue = this.createExpressionString();
            this.myChangeOkBool = true;
        }
        this.setVisible(false);
        this.dispose();
    }

    public String getExpression() {
        return this.myValue;
    }

    public boolean isChanged() {
        return this.myChangeOkBool;
    }

    private class RelativeValueFieldVariable
    extends ValueFieldVariable {
        public RelativeValueFieldVariable(String name, ValueFieldCompositeObject field, String[] possibleFields, DataType type) {
            super(name, field, possibleFields, type);
            this.mySelectedType = this.myValueTypes[0];
        }

        @Override
        protected PanelVariableEditor createPanelVariableEditor() {
            if (this.myPanelVariableEditor == null) {
                this.myPanelVariableEditor = this.myBuilder != null ? new RelativeValueFieldPanel((ValueFieldCompositeObject)this.myValue, this.myValueTypes, this.mySelectedType, this.myBuilder) : (this.myFieldMap != null ? new RelativeValueFieldPanel((ValueFieldCompositeObject)this.myValue, this.myValueTypes, this.mySelectedType, this.myFieldMap) : new RelativeValueFieldPanel((ValueFieldCompositeObject)this.myValue, this.myValueTypes, this.mySelectedType, this.myAvailableFields));
                this.myPanelVariableEditor.setEditorListener(this);
            }
            return this.myPanelVariableEditor;
        }

        @Override
        public void dataChanged() {
            super.dataChanged();
            String newValue = this.getValueString();
            if (this.inFieldMode()) {
                if (!RelativeDialog.this.myOldField.equals(newValue)) {
                    FieldDefinition theDef = RelativeDialog.this.myRep.getFieldDefinitionByName(newValue);
                    RelativeDialog.this.myIndexVariable = FieldOrientedPluginProfileUtil.createIndexVariable("Index", null, theDef, RelativeDialog.this.myRep, (Element)null, false);
                    RelativeDialog.this.fillModel();
                }
            } else if (RelativeDialog.this.myOldFieldMode || this.swappingEotAndBot(RelativeDialog.this.myOldField, newValue)) {
                RelativeDialog.this.fillModel();
            }
            RelativeDialog.this.myOldField = newValue;
            RelativeDialog.this.myOldFieldMode = this.inFieldMode();
        }

        private boolean swappingEotAndBot(String old, String newer) {
            boolean wasBotOrEot = "BOT".equals(old) || "EOT".equals(old);
            boolean newBotOrEot = "BOT".equals(newer) || "EOT".equals(newer);
            return wasBotOrEot ^ newBotOrEot;
        }
    }

    private class RelativeValueFieldPanel
    extends ValueFieldPanel {
        public RelativeValueFieldPanel(ValueFieldCompositeObject value, ValueFieldVariable.ValueType[] valueTypes, ValueFieldVariable.ValueType selectedType, AvailableFieldListBuilder builder) {
            super(value, valueTypes, selectedType, builder);
        }

        public RelativeValueFieldPanel(ValueFieldCompositeObject value, ValueFieldVariable.ValueType[] valueTypes, ValueFieldVariable.ValueType selectedType, Map<String, FieldDefinition> fieldMap) {
            super(value, valueTypes, selectedType, fieldMap);
        }

        public RelativeValueFieldPanel(ValueFieldCompositeObject value, ValueFieldVariable.ValueType[] valueTypes, ValueFieldVariable.ValueType selectedType, String[] availableFields) {
            super(value, valueTypes, selectedType, availableFields);
        }

        @Override
        protected ValueFieldPanel.ValueFieldEditor createEditorForValueType(ValueFieldVariable.ValueType valueType, String value) {
            DateAndTimeVariable var = valueType.getDataType() == DataType.DATE ? VariableFactory.createDateVariable("", "", RelativeDialog.this.myField) : VariableFactory.createDateTimeVariable("", "", RelativeDialog.this.myField);
            if (value != null) {
                ((Variable)var).setValue(value);
            }
            return new ValueFieldPanel.ValueFieldEditor(var, valueType);
        }
    }

    private class MyExpressionParserHandler
    extends AbstractExpressionParserHandler {
        MyExpressionParserHandler() {
            super(RelativeDialog.this.myRep, null);
        }

        @Override
        protected Operand createFieldOperand(FieldDefinition field, ValueFieldCompositeObject indexObject) {
            ValueFieldCompositeObject vfco = ValueFieldCompositeObject.createForField(field.getFieldName());
            return new ValueFieldCompositeOperand(vfco, indexObject);
        }

        @Override
        public Operand createLiteralOperand(String value, DataType dt) throws ParseException {
            ValueFieldCompositeObject vfco = ValueFieldCompositeObject.createForValue(value, dt);
            return new ValueFieldCompositeOperand(vfco);
        }
    }
}

