/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import com.ericsson.ere.swing.EDT;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;

public class ExceptionUtil {
    public static final String LOGGER_DIFF = "diffTool";
    public static final String LOGGER_SIMULATION = "simulation";
    public static final String LOGGER_RATING_RULE_FRAME = "ratingRuleFrame";
    public static final String LOGGER_RATING_PERIOD = "ratingperiod";
    public static final String LOGGER_PROXY = "ereProxyStructure";
    public static final String LOGGER_NAVIGATOR = "navigator";
    public static final String LOGGER_GENERATION = "generation";
    public static final String LOGGER_DISTRIBUTION = "distribution";
    public static final String LOGGER_SERVICE = "service";
    public static final String LOGGER_MULTIDATAUPDATE = "multidataupdate";
    public static final int FINE = 0;
    public static final int WARNING = 1;
    public static final int SEVERE = 2;

    private static String exceptionToString(Throwable e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        e.printStackTrace(pw);
        pw.close();
        return baos.toString();
    }

    public static long handleException(Throwable e, String logger2) {
        return ExceptionUtil.handleException(e, logger2, 0, null, false);
    }

    public static long handleException(Throwable e, String logger2, int severity, String infoMessage, boolean showDialog) {
        return ExceptionUtil.handleException(e, logger2, severity, infoMessage, showDialog, null);
    }

    public static long handleException(Throwable e, String logger2, int severity, String infoMessage, boolean showDialog, Object[] additionalInfo) {
        Level level;
        String stackTrace = ExceptionUtil.exceptionToString(e);
        switch (severity) {
            case 0: {
                level = Level.FINE;
                break;
            }
            case 1: {
                level = Level.WARNING;
                break;
            }
            case 2: {
                level = Level.SEVERE;
                break;
            }
            default: {
                level = Level.ALL;
            }
        }
        return ExceptionUtil.handleException(e, logger2, level, stackTrace, infoMessage, showDialog, additionalInfo);
    }

    private static long handleException(Throwable e, String logger2, Level severity, String logMessage, String infoMessage, boolean showDialog, Object[] additionalInfo) {
        if (!logger2.startsWith("rma.")) {
            logger2 = "rma." + logger2;
        }
        logMessage = infoMessage == null ? logMessage : infoMessage + "\n\n" + logMessage;
        StackTraceElement[] stack = e.getStackTrace();
        StackTraceElement caller = null;
        if (stack.length > 0) {
            caller = stack[0];
        }
        if (additionalInfo != null) {
            for (Object o : additionalInfo) {
                logMessage = logMessage + "\n\n\nAdditional Info:\n\n" + o.toString();
            }
        }
        LogRecord record = new LogRecord(severity, logMessage);
        if (caller != null) {
            record.setSourceClassName(caller.getClassName());
            record.setSourceMethodName(caller.getMethodName());
        }
        record.setLoggerName(logger2);
        Logger.getLogger(logger2).log(record);
        long logNumber = record.getSequenceNumber();
        if (showDialog && !GraphicsEnvironment.isHeadless()) {
            infoMessage = e.getMessage() != null ? infoMessage + ":\n" + e.getMessage() : infoMessage;
            final String imsg = infoMessage = infoMessage + "\nCheck the log with entry " + logNumber + " for more info.";
            final String lmsg = logMessage;
            final long lnum = logNumber;
            EDT.runAndWait(new Runnable(){

                @Override
                public void run() {
                    ErrorLogDialog dialog = new ErrorLogDialog(imsg, lmsg, lnum);
                    dialog.setVisible(true);
                }
            });
        }
        return logNumber;
    }

    static class ErrorLogDialog
    extends JDialog {
        private String myMessage;
        private String myAdvancedMessage;
        private long myLogNumber;

        ErrorLogDialog(String message, String advancedMsg, long logNr) {
            super(GuiServiceCenter.getInstance().getMainWindow(), "RMA", true);
            this.setLayout(new GridBagLayout());
            this.setName("ExceptionUtil.ErrorLogDialog");
            this.myMessage = message;
            this.myAdvancedMessage = advancedMsg;
            this.myLogNumber = logNr;
            this.initGUI();
            this.setLocationRelativeTo(GuiServiceCenter.getInstance().getMainWindow());
            this.setResizable(true);
        }

        private void initGUI() {
            JButton okButton = new JButton("OK");
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.dispose();
                }
            });
            okButton.setName("ExceptionUtil.ErrorLogDialog.OkButton");
            JButton logButton = new JButton("Show log");
            logButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiServiceCenter.getInstance().showLogWithSelectedEntry(myLogNumber);
                    this.dispose();
                }
            });
            logButton.setName("ExceptionUtil.ErrorLogDialog.LogButton");
            JTextArea advancedArea = new JTextArea();
            advancedArea.setName("ExceptionUtil.ErrorLogDialog.AdvancedMessage");
            advancedArea.setText(this.myAdvancedMessage);
            advancedArea.setLineWrap(true);
            advancedArea.setWrapStyleWord(true);
            advancedArea.setBorder(BorderFactory.createBevelBorder(1));
            final JScrollPane advancedScroll = new JScrollPane(advancedArea);
            advancedScroll.setVisible(false);
            advancedScroll.setPreferredSize(advancedArea.getPreferredScrollableViewportSize());
            JToggleButton advancedButton = new JToggleButton("Advanced");
            advancedButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    advancedScroll.setVisible(!advancedScroll.isVisible());
                    this.pack();
                }
            });
            advancedButton.setName("ExceptionUtil.ErrorLogDialog.AdvancedButton");
            String[] messageRows = this.myMessage.split("\n");
            JTextArea errorLabel = new JTextArea(Math.min(1, messageRows.length), 40);
            errorLabel.setText(this.myMessage);
            errorLabel.setLineWrap(true);
            errorLabel.setWrapStyleWord(true);
            errorLabel.setBackground(this.getBackground());
            errorLabel.setBorder(BorderFactory.createEmptyBorder());
            errorLabel.setEnabled(false);
            errorLabel.setDisabledTextColor(Color.BLACK);
            errorLabel.setCaretPosition(0);
            JScrollPane msgScroll = new JScrollPane(errorLabel);
            msgScroll.setPreferredSize(errorLabel.getPreferredScrollableViewportSize());
            msgScroll.setBorder(BorderFactory.createEmptyBorder());
            JLabel errorIcon = new JLabel(RmaDefs.getImageIcon("dialog_error.gif"));
            JPanel messagePanel = new JPanel(new GridBagLayout());
            messagePanel.add((Component)errorIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            messagePanel.add((Component)msgScroll, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            buttonPanel.add((Component)advancedButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 0, 8, 0), 0, 0));
            buttonPanel.add((Component)logButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 8, 8, 0), 0, 0));
            buttonPanel.add((Component)okButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 8, 8, 0), 0, 0));
            this.getContentPane().add((Component)messagePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.1, 10, 1, new Insets(15, 15, 8, 15), 0, 0));
            this.getContentPane().add((Component)buttonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(8, 0, 8, 0), 0, 0));
            this.getContentPane().add((Component)advancedScroll, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.9, 10, 1, new Insets(8, 8, 8, 8), 0, 0));
            this.pack();
        }
    }
}

