/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import java.util.Calendar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class CalendarModel {
    int myYear;
    int myMonth;
    int myDayOfMonth;
    int myHour;
    int myMinute;
    int mySecond;
    private boolean useTimeOnly = false;
    private boolean useDateOnly = false;
    private EventListenerList myChangeListeners = new EventListenerList();

    public CalendarModel(Calendar calendar) {
        this.myYear = calendar.get(1);
        this.myMonth = calendar.get(2) + 1;
        this.myDayOfMonth = calendar.get(5);
        this.myHour = calendar.get(11);
        this.myMinute = calendar.get(12);
        this.mySecond = calendar.get(13);
    }

    public CalendarModel(int year, int month, int dayOfMonth) {
        this.myYear = year;
        this.myMonth = month;
        this.myDayOfMonth = dayOfMonth;
    }

    public CalendarModel(int year, int month, int dayOfMonth, int hour, int minute, int seconds) {
        this.myYear = year;
        this.myMonth = month;
        this.myDayOfMonth = dayOfMonth;
        this.myHour = hour;
        this.myMinute = minute;
        this.mySecond = seconds;
    }

    public void addChangeListener(ChangeListener listener) {
        this.myChangeListeners.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.myChangeListeners.remove(ChangeListener.class, listener);
    }

    public void fireStateChanged() {
        if (this.myChangeListeners == null) {
            return;
        }
        Object[] listeners = this.myChangeListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ChangeEvent changeEvent = new ChangeEvent(this);
            ChangeListener cl = (ChangeListener)listeners[i + 1];
            cl.stateChanged(changeEvent);
        }
    }

    public void set(int field, int value) {
        switch (field) {
            case 1: {
                this.myYear = value;
                break;
            }
            case 2: {
                this.myMonth = value + 1;
                break;
            }
            case 5: {
                this.myDayOfMonth = value;
                break;
            }
            case 10: 
            case 11: {
                this.myHour = value;
                break;
            }
            case 12: {
                this.myMinute = value;
                break;
            }
            case 13: {
                this.mySecond = value;
            }
        }
        this.fireStateChanged();
    }

    public void setTimeInMillis(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        this.myYear = calendar.get(1);
        this.myMonth = calendar.get(2) + 1;
        this.myDayOfMonth = calendar.get(5);
        this.myHour = calendar.get(11);
        this.myMinute = calendar.get(12);
        this.mySecond = calendar.get(13);
        this.fireStateChanged();
    }

    public int get(int field) {
        switch (field) {
            case 1: {
                return this.myYear;
            }
            case 2: {
                return this.myMonth - 1;
            }
            case 5: {
                return this.myDayOfMonth;
            }
            case 10: 
            case 11: {
                return this.myHour;
            }
            case 12: {
                return this.myMinute;
            }
            case 13: {
                return this.mySecond;
            }
        }
        return -1;
    }

    public Calendar getCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, this.myYear);
        calendar.set(2, this.myMonth - 1);
        calendar.set(5, this.myDayOfMonth);
        calendar.set(11, this.myHour);
        calendar.set(12, this.myMinute);
        calendar.set(13, this.mySecond);
        return calendar;
    }

    public int getActualMaximum(int field) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, this.myYear);
        calendar.set(2, this.myMonth - 1);
        calendar.set(5, 1);
        calendar.set(11, this.myHour);
        calendar.set(12, this.myMinute);
        calendar.set(13, this.mySecond);
        return calendar.getActualMaximum(field);
    }

    public boolean isValid() {
        Calendar calendar = this.getCalendar();
        if (this.myYear != calendar.get(1)) {
            return false;
        }
        if (this.myMonth != calendar.get(2) + 1) {
            return false;
        }
        if (this.myDayOfMonth != calendar.get(5)) {
            return false;
        }
        if (this.myHour != calendar.get(11)) {
            return false;
        }
        if (this.myMinute != calendar.get(12)) {
            return false;
        }
        return this.mySecond == calendar.get(13);
    }

    public boolean isYearValid() {
        Calendar calendar = this.getCalendar();
        return this.myYear == calendar.get(1);
    }

    public boolean isMonthValid() {
        Calendar calendar = this.getCalendar();
        return this.myMonth == calendar.get(2) + 1;
    }

    public boolean isDayOfMonthValid() {
        Calendar calendar = this.getCalendar();
        return this.myDayOfMonth == calendar.get(5);
    }

    public boolean isHourValid() {
        Calendar calendar = this.getCalendar();
        return this.myHour == calendar.get(11);
    }

    public boolean isMinuteValid() {
        Calendar calendar = this.getCalendar();
        return this.myMinute == calendar.get(12);
    }

    public boolean isSecondValid() {
        Calendar calendar = this.getCalendar();
        return this.mySecond == calendar.get(13);
    }

    private String padValue(int value) {
        if (value < 10) {
            return "0" + value;
        }
        return "" + value;
    }

    public void timeOnly() {
        this.useTimeOnly = true;
        this.useDateOnly = false;
    }

    public void dateOnly() {
        this.useDateOnly = true;
        this.useTimeOnly = false;
    }

    public boolean isTimeOnlyMode() {
        return this.useTimeOnly;
    }

    public boolean isDateOnlyMode() {
        return this.useDateOnly;
    }

    public String toLabel() {
        if (this.useDateOnly) {
            return "" + this.myYear + "-" + this.padValue(this.myMonth) + "-" + this.padValue(this.myDayOfMonth);
        }
        if (this.useTimeOnly) {
            return "" + this.padValue(this.myHour) + ":" + this.padValue(this.myMinute) + ":" + this.padValue(this.mySecond);
        }
        return "" + this.myYear + "-" + this.padValue(this.myMonth) + "-" + this.padValue(this.myDayOfMonth) + " " + this.padValue(this.myHour) + ":" + this.padValue(this.myMinute) + ":" + this.padValue(this.mySecond);
    }
}

