/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.undoredo;

import com.ericsson.ere.gui.undoredo.UndoableTree;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class OpenTreeEdit
extends AbstractUndoableEdit {
    private TSTariffStructure oldRoot;
    private TSTariffStructure newRoot;
    private UndoableTree myTree;

    public OpenTreeEdit(UndoableTree tree, TSTariffStructure oldRoot, TSTariffStructure newRoot) {
        this.oldRoot = oldRoot;
        this.newRoot = newRoot;
        this.myTree = tree;
    }

    @Override
    public void undo() throws CannotUndoException {
        this.myTree.setOngoingUndo(true);
        try {
            super.undo();
            this.oldRoot.applyTreeDefinedFields();
            this.myTree.openANewStructure(this.oldRoot);
        }
        finally {
            this.myTree.setOngoingUndo(false);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        this.myTree.setOngoingUndo(true);
        try {
            super.redo();
            this.newRoot.applyTreeDefinedFields();
            this.myTree.openANewStructure(this.newRoot);
        }
        finally {
            this.myTree.setOngoingUndo(false);
        }
    }
}

