/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.testgenerator;

import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationWizardOptions;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.ratingrules.nodes.TSCondition;
import ericsson.ere.gui.ratingrules.nodes.TSModifier;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.InfoVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class TestCaseGenerationDefs {
    public static final String TAG_TEST_SETTINGS = "TestSettings";
    public static final String START_TAG_TEST_SETTINGS = "<TestSettings>";
    public static final String END_TAG_TEST_SETTINGS = "</TestSettings>";
    public static final String TAG_SETTINGS = "Settings";
    public static final String START_TAG_SETTINGS = "<Settings>";
    public static final String END_TAG_SETTINGS = "</Settings>";
    public static final String LBL_CASES = "Cases";
    public static final String TAG_CASES = "Cases";
    public static final String START_TAG_CASES = "<Cases>";
    public static final String END_TAG_CASES = "</Cases>";
    public static final String TAG_VALUE = "Value";
    public static final String TAG_ID = "Id";
    public static final String TAG_TYPE = "Type";
    public static final String TAG_NUMBER = "Number";
    public static final String TAG_INT_VALUE = "IntValue";
    public static final String TAG_LONG_VALUE = "LongValue";
    public static final String TAG_OPERATOR = "Operator";
    public static final String TAG_LENGTH = "Length";
    public static final String TAG_TEXT = "Text";
    public static final String TAG_STRING = "String";
    public static final String TAG_COMPARATION = "Comparation";
    public static final String TAG_COMP_FIELD_VALUE = "CompFieldValue";
    public static final String TAG_MASK = "Mask";
    public static final String TAG_FROM = "From";
    public static final String TAG_TO = "To";
    public static final String TAG_DATE = "Date";
    public static final String TAG_INTERVAL = "Interval";
    public static final String START_TAG_INTERVAL = "<Interval>";
    public static final String END_TAG_INTERVAL = "</Interval>";
    public static final String TAG_BOUNDARIES = "Boundaries";
    public static final String START_TAG_BOUNDARIES = "<Boundaries>";
    public static final String END_TAG_BOUNDARIES = "</Boundaries>";
    public static final String TAG_EDIT_COMPONENT = "EditComponent";
    public static final String TAG_INPUT_RESTRICTION = "InputRestriction";
    public static final String TAG_RANGE = "Range";
    public static final String TAG_ENUM = "Enum";
    public static final String[] NUMBER_TAG_ARRAY = new String[]{"DoubleValue", "IntValue", "LongValue", "ShortValue"};
    public static final String ATTR_ENUM_VALUE = "value";
    public static final String ATTR_MIN = "min";
    public static final String ATTR_MAX = "max";
    public static final String VALUE_SINGEL = "Single case";
    public static final String VALUE_ALL = "All cases";
    public static final String VALUE_BOUNDARIES = "Boundaries";
    public static final String VALUE_SINGLE_AND_BOUNDARIES = "Single values and boundaries";
    public static final String VALUE_FIRST_AND_LAST = "First and last";
    public static final String VALUE_EVERY_MINUTE = "A value for every minute";
    public static final String VALUE_EVERY_HOUR = "A value for every hour";
    public static final String EXCEPTION_MESSAGE = "Condition settings does not allow test case generation.";
    public static final Object USE_SIMULATION_FIELD = new Object(){

        public String toString() {
            return "USE_SIMULATION_FIELD";
        }
    };
    public static final Object DONT_USE_SIMULATION_FIELD = new Object(){

        public String toString() {
            return "DONT_USE_SIMULATION_FIELD";
        }
    };

    public static void printCasesVariable(PrintWriter out, List<Variable> vars) {
        out.print(START_TAG_TEST_SETTINGS);
        out.print(START_TAG_CASES);
        out.print(VarListUtil.getValueStringForName(vars, "Cases"));
        out.print(END_TAG_CASES);
        out.print(END_TAG_TEST_SETTINGS);
    }

    public static List<Variable> getDefaultTestVariables() {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        vars.add(new InfoVariable("Information", " No configuration possible."));
        return vars;
    }

    public static String getDefaultTestSettingsXml() {
        return "<TestSettings></TestSettings>";
    }

    public static String[] extractEnum(Element ecElement) {
        List<Element> enumList = XMLUtil.getElementNodesNamed(TAG_ENUM, ecElement.getChildNodes());
        String[] values = new String[enumList.size()];
        for (int i = 0; i < enumList.size(); ++i) {
            values[i] = XMLUtil.getAttributeFromElement(enumList.get(i), ATTR_ENUM_VALUE, "0");
        }
        return values;
    }

    public static String getDifferingCharacter(String referenceCharacter) {
        if (referenceCharacter.length() > 1) {
            return null;
        }
        if (referenceCharacter.equals("1")) {
            return "2";
        }
        return "1";
    }

    public static String convertValueToDataType(BigInteger aValue, String aDataType) {
        if (aDataType.equals("Short")) {
            if (aValue.compareTo(new BigInteger(Short.toString((short)Short.MAX_VALUE))) > 0) {
                return Short.toString(aValue.shortValue());
            }
        } else if (aDataType.equals("UShort")) {
            if (aValue.compareTo(new BigInteger("0")) < 0) {
                return new BigInteger(Long.toBinaryString(aValue.longValue()).substring(48), 2).toString();
            }
        } else if (aDataType.equals("Integer")) {
            if (aValue.compareTo(new BigInteger(Integer.toString(Integer.MAX_VALUE))) > 0) {
                return Integer.toString(aValue.intValue());
            }
        } else if (aDataType.equals("UInteger")) {
            if (aValue.compareTo(new BigInteger("0")) < 0) {
                return new BigInteger(Long.toBinaryString(aValue.longValue()).substring(32), 2).toString();
            }
        } else if (aDataType.equals("Long")) {
            if (aValue.compareTo(new BigInteger(Long.toString(Long.MAX_VALUE))) > 0) {
                return Long.toString(aValue.longValue());
            }
        } else if (aDataType.equals("ULong") && aValue.compareTo(new BigInteger("0")) < 0) {
            return new BigInteger(Long.toBinaryString(aValue.longValue()), 2).toString();
        }
        return aValue.toString();
    }

    public static String getBasicTestXML(TariffDAGNode element, TestCaseGenerationWizardOptions wizardOptions) {
        String fieldName;
        Map<String, Object> testCaseFieldInformation;
        ClassRepository rep = wizardOptions.myRepository;
        String s = "";
        if (element instanceof TSCondition) {
            testCaseFieldInformation = wizardOptions.mySingleTestCase ? wizardOptions.myConditionSingleTestCaseFieldInformation.get(element) : wizardOptions.myConditionTestCaseFieldInformation.get(element);
        } else if (element instanceof TSModifier) {
            testCaseFieldInformation = wizardOptions.myModifierTestCaseFieldInformation.get(element);
        } else {
            return "";
        }
        String profile = null;
        if (element instanceof TSCondition) {
            profile = ((TSCondition)element).getConditionProfile().getClass().getName();
        } else if (element instanceof TSModifier) {
            profile = ((TSModifier)element).getProfile().getClass().getName();
        } else {
            return "";
        }
        s = s + "\n\n<Test profile=\"" + profile + "\">\n";
        if (element instanceof TSCondition && !(fieldName = rep.getConditionFieldName(element.getNodeName())).equals("") && rep.getFieldDefinitionByName(fieldName) != null) {
            s = s + XMLUtil.getStringRepresentation(rep.getFieldDefinitionByName(fieldName).getDefinitionNode());
        }
        s = s + "<ConditionElement>\n";
        s = s + XMLUtil.getStringRepresentation(wizardOptions.myElementConfigXML.get(element));
        s = s + "</ConditionElement>\n";
        s = s + "<TestElement>\n";
        s = s + XMLUtil.getStringRepresentation(wizardOptions.myElementTestXML.get(element));
        s = s + "</TestElement>\n";
        for (String field : testCaseFieldInformation.keySet()) {
            Object val = testCaseFieldInformation.get(field);
            s = s + "<Expected field=\"" + field + "\">\n";
            if (val.getClass().isArray()) {
                for (int i = 0; i < ((Object[])val).length; ++i) {
                    s = s + "<Value>" + ((Object[])val)[i] + "</Value>\n";
                }
            } else {
                s = s + "<Value>" + val + "</Value>\n";
            }
            s = s + "</Expected>\n";
        }
        s = s + "</Test>\n";
        return s;
    }

    public static class TimeParser {
        private int hours = 0;
        private int minutes = 0;
        private int seconds = 0;
        private boolean valid = false;

        public TimeParser(String timeString) {
            StringTokenizer aTokenizer = new StringTokenizer(timeString, ":");
            if (aTokenizer.countTokens() == 3) {
                this.hours = Integer.parseInt(aTokenizer.nextToken());
                this.minutes = Integer.parseInt(aTokenizer.nextToken());
                this.seconds = Integer.parseInt(aTokenizer.nextToken());
                this.valid = true;
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        public int getHours() {
            return this.hours;
        }

        public int getMinutes() {
            return this.minutes;
        }

        public int getSeconds() {
            return this.seconds;
        }

        public String getLastSecond() {
            int newSeconds = 0;
            int newMinutes = 0;
            int newHours = 0;
            if (this.seconds != 0) {
                newSeconds = this.seconds - 1;
            } else {
                newSeconds = 59;
                if (this.minutes != 0) {
                    newMinutes = this.minutes - 1;
                } else {
                    newMinutes = 59;
                    newHours = this.hours != 0 ? this.hours - 1 : 23;
                }
            }
            return TimeParser.padTimeEntity(newHours) + ":" + TimeParser.padTimeEntity(newMinutes) + ":" + TimeParser.padTimeEntity(newSeconds);
        }

        private static String padTimeEntity(int timeEntity) {
            if (timeEntity <= 9) {
                return "0" + timeEntity;
            }
            return "" + timeEntity;
        }
    }
}

