/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.dag.BaseDAGNode;
import com.ericsson.ere.dag.DAGVisit;
import com.ericsson.ere.defs.ServiceFieldStructure;
import com.ericsson.ere.defs.ServiceFieldStructureVisitor;
import com.ericsson.ere.gui.simulator.SimulationVariableStructureVisitor;
import com.ericsson.ere.interfaces.Acceptable;
import com.ericsson.ere.variable.VariableProducer;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class SimulationVariableStructure
extends ServiceFieldStructureVisitor {
    private static final ServiceFieldStructure.StructureElement ROOT_GROUP = null;
    private final VariableProducer myVariableProducer;
    private final List<String> myInputParameterTypes;
    private final List<String> myParameterTypes;
    private final boolean mySortVariablesByLabel;
    private final Map<ServiceFieldStructure.StructureElement, VariableGroupElement> myGroupMap;

    private SimulationVariableStructure(VariableProducer variableProducer, List<String> inputParameterTypes, List<String> outputParameterTypes, boolean sortVariablesByLabel) {
        this.myVariableProducer = variableProducer;
        this.myInputParameterTypes = inputParameterTypes;
        this.myParameterTypes = new ArrayList<String>(inputParameterTypes);
        this.myParameterTypes.addAll(outputParameterTypes);
        this.myGroupMap = new IdentityHashMap<ServiceFieldStructure.StructureElement, VariableGroupElement>();
        this.mySortVariablesByLabel = sortVariablesByLabel;
        this.myGroupMap.put(ROOT_GROUP, new VariableRootElement());
    }

    public static SimulationVariableStructure create(ServiceFieldStructure.StructureElement fieldStructureRoot, VariableProducer variableProducer, List<String> inputParameterTypes, List<String> outputParameterTypes, boolean sortVariablesByLabel) {
        SimulationVariableStructure structure = new SimulationVariableStructure(variableProducer, inputParameterTypes, outputParameterTypes, sortVariablesByLabel);
        DAGVisit.visitPreOrder(fieldStructureRoot, structure);
        return structure;
    }

    public VariableStructureElement getRoot() {
        return this.myGroupMap.get(ROOT_GROUP);
    }

    @Override
    public void visit(ServiceFieldStructure.RootElement element) {
    }

    @Override
    public void visit(ServiceFieldStructure.ContextElement element) {
    }

    @Override
    public void visit(ServiceFieldStructure.CommonFieldsElement element) {
    }

    @Override
    public void visit(ServiceFieldStructure.ServiceProviderContextElement element) {
    }

    @Override
    public void visit(ServiceFieldStructure.RatingPlanContextElement element) {
    }

    private void visitField(ServiceFieldStructure.FieldElement element, String variableKey) {
        FieldDefinition fd;
        String pt;
        boolean isFieldGroupChild = element.getParent() instanceof ServiceFieldStructure.FieldGroupElement;
        if (!isFieldGroupChild && this.myParameterTypes.contains(pt = (fd = element.getField()).getParameterType())) {
            Variable variable = this.myVariableProducer.produceVariable(fd);
            VariableGroupElement parent = this.getParentGroupForElement(element);
            parent.addChild(this.createVariableElement(variable, pt, false));
            if (variableKey != null) {
                variable.setKey(variableKey);
            }
        }
    }

    @Override
    public void visit(ServiceFieldStructure.FieldElement element) {
        this.visitField(element, null);
    }

    @Override
    public void visit(ServiceFieldStructure.HierarchicalFieldElement element) {
        this.visitField(element, element.getFieldPath());
    }

    private void visitGroup(ServiceFieldStructure.StructureElement element, VariableGroupElement groupToAdd) {
        VariableGroupElement parent = this.getParentGroupForElement(element);
        parent.addChild(groupToAdd);
        this.myGroupMap.put(element, groupToAdd);
    }

    @Override
    public void visit(ServiceFieldStructure.GroupElement element) {
        this.visitGroup(element, new VariableGroupElement(element.getName()));
    }

    @Override
    public void visit(ServiceFieldStructure.HierarchicalStructureElement element) {
        this.visitGroup(element, new VariableHierarchicalGroupElement(element.getName()));
    }

    @Override
    public void visit(ServiceFieldStructure.HierarchicalComplexStructureElement element) {
        FieldHierarchyNode.ComplexType complexType = element.getFieldHierarcyNode().getComplexType();
        ArrayList<ServiceFieldStructure.FieldElement> keyFieldElements = new ArrayList();
        if (complexType == FieldHierarchyNode.ComplexType.MAP || complexType == FieldHierarchyNode.ComplexType.SET) {
            keyFieldElements = element.getKeyFieldElements();
        }
        List<VariableElement> variables = this.createMultiFieldVariables(element, keyFieldElements, true);
        this.addVariables(element, variables);
    }

    @Override
    public void visit(ServiceFieldStructure.ArrayGroupElement element) {
        List<VariableElement> variables = this.createMultiFieldVariables(element, Collections.emptyList(), false);
        this.addVariables(element, variables);
    }

    @Override
    public void visit(ServiceFieldStructure.MapGroupElement element) {
        List<VariableElement> variables = this.createMultiFieldVariables(element, Arrays.asList(element.getKeyFieldElements()), false);
        this.addVariables(element, variables);
    }

    private VariableElement createVariableElement(Variable variable, String pt, boolean isHierarchical) {
        if (!this.myInputParameterTypes.contains(pt)) {
            variable.setSelected(false);
        }
        return isHierarchical ? new VariableHierarchicalElement(variable, pt) : new VariableElement(variable, pt);
    }

    private VariableGroupElement getParentGroupForElement(ServiceFieldStructure.StructureElement element) {
        VariableGroupElement group = this.myGroupMap.get(element.getParent());
        if (group == null) {
            group = this.myGroupMap.get(null);
        }
        return group;
    }

    private void addVariables(ServiceFieldStructure.StructureElement element, List<VariableElement> variables) {
        VariableGroupElement parent = this.getParentGroupForElement(element);
        for (VariableElement v : variables) {
            parent.addChild(v);
        }
    }

    private List<VariableElement> createMultiFieldVariables(ServiceFieldStructure.FieldGroupElement element, List<ServiceFieldStructure.FieldElement> keyFieldElements, boolean isHierarchical) {
        ArrayList<VariableElement> vars = new ArrayList<VariableElement>();
        for (String pt : this.myParameterTypes) {
            List<FieldDefinition> fields = this.getFieldsFromChildren(element, pt, keyFieldElements);
            if (fields.isEmpty()) continue;
            String label = element.getName() + " " + pt;
            Variable var = this.myVariableProducer.produceVariable(label, fields);
            vars.add(this.createVariableElement(var, pt, isHierarchical));
        }
        return vars;
    }

    private List<FieldDefinition> getFieldsFromChildren(ServiceFieldStructure.FieldGroupElement element, String parameterType, List<ServiceFieldStructure.FieldElement> keyFieldElements) {
        ArrayList<FieldDefinition> matchingFields = new ArrayList<FieldDefinition>();
        ArrayList<FieldDefinition> keyFields = new ArrayList<FieldDefinition>();
        int cc = element.getChildCount();
        for (int i = 0; i < cc; ++i) {
            ServiceFieldStructure.FieldElement fe = (ServiceFieldStructure.FieldElement)element.getChildAt(i);
            FieldDefinition fd = fe.getField();
            if (keyFieldElements.contains(fe)) {
                keyFields.add(fd);
            }
            if (!parameterType.equals(fd.getParameterType())) continue;
            matchingFields.add(fe.getField());
        }
        if (!matchingFields.isEmpty()) {
            keyFields.removeAll(matchingFields);
            matchingFields.addAll(0, keyFields);
        }
        return matchingFields;
    }

    public class VariableHierarchicalGroupElement
    extends VariableGroupElement {
        VariableHierarchicalGroupElement(String name) {
            super(name);
        }

        @Override
        public void accept(SimulationVariableStructureVisitor visitor) {
            visitor.visit(this);
        }
    }

    public class VariableHierarchicalElement
    extends VariableElement {
        VariableHierarchicalElement(Variable variable, String parameterType) {
            super(variable, parameterType);
        }

        @Override
        public void accept(SimulationVariableStructureVisitor visitor) {
            visitor.visit(this);
        }
    }

    public class VariableElement
    extends VariableStructureElement {
        private Variable myVariable;
        private String myParameterType;

        VariableElement(Variable variable, String parameterType) {
            assert (variable != null && parameterType != null);
            this.myVariable = variable;
            this.myParameterType = parameterType;
        }

        @Override
        public void insertChildAt(int index, DAGNode node) {
            throw new UnsupportedOperationException("A variable element cannot have children.");
        }

        public Variable getVariable() {
            return this.myVariable;
        }

        public String getParameterType() {
            return this.myParameterType;
        }

        @Override
        public int compareTo(VariableStructureElement other) {
            int result = super.compareTo(other);
            if (result == 0 && other instanceof VariableElement) {
                int p2;
                VariableElement ve = (VariableElement)other;
                int p1 = SimulationVariableStructure.this.myParameterTypes.indexOf(this.myParameterType);
                int n = p1 < (p2 = SimulationVariableStructure.this.myParameterTypes.indexOf(ve.myParameterType)) ? -1 : (result = p1 > p2 ? 1 : 0);
                if (result == 0 && SimulationVariableStructure.this.mySortVariablesByLabel) {
                    Variable otherVariable = ve.getVariable();
                    result = this.myVariable.getLabel().compareTo(otherVariable.getLabel());
                }
            }
            return result;
        }

        @Override
        public VariableStructureElement.VariableStructureElementType getType() {
            boolean isInput = SimulationVariableStructure.this.myInputParameterTypes.contains(this.myParameterType);
            return isInput ? VariableStructureElement.VariableStructureElementType.INPUT : VariableStructureElement.VariableStructureElementType.OUTPUT;
        }

        @Override
        public void accept(SimulationVariableStructureVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.myParameterType == null ? 0 : this.myParameterType.hashCode());
            result = 31 * result + (this.getVariableLabel() == null ? 0 : this.getVariableLabel().hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VariableElement other = (VariableElement)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.myParameterType == null ? other.myParameterType != null : !this.myParameterType.equals(other.myParameterType)) {
                return false;
            }
            return !(this.getVariableLabel() == null ? other.getVariableLabel() != null : !this.getVariableLabel().equals(other.getVariableLabel()));
        }

        public String toString() {
            return "Variable: " + this.myVariable.getLabel() + " (" + this.myParameterType + ")";
        }

        private SimulationVariableStructure getOuterType() {
            return SimulationVariableStructure.this;
        }

        private String getVariableLabel() {
            return this.myVariable != null ? this.myVariable.getLabel() : null;
        }
    }

    public class VariableRootElement
    extends VariableGroupElement {
        VariableRootElement() {
            super(null);
        }

        @Override
        public void accept(SimulationVariableStructureVisitor visitor) {
            visitor.visit(this);
        }
    }

    public class VariableGroupElement
    extends VariableStructureElement {
        private String myGroupName;

        VariableGroupElement(String name) {
            this.myGroupName = name;
        }

        @Override
        public void addChild(DAGNode node) {
            VariableStructureElement child;
            int index;
            VariableStructureElement toInsert = (VariableStructureElement)node;
            for (index = this.getChildCount(); index > 0 && (child = (VariableStructureElement)this.getChildAt(index - 1)).compareTo(toInsert) > 0; --index) {
            }
            this.insertChildAt(index, node);
        }

        @Override
        public VariableStructureElement.VariableStructureElementType getType() {
            return VariableStructureElement.VariableStructureElementType.GROUP;
        }

        @Override
        public void accept(SimulationVariableStructureVisitor visitor) {
            visitor.visit(this);
        }

        public String getGroupName() {
            return this.myGroupName;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.myGroupName == null ? 0 : this.myGroupName.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VariableGroupElement other = (VariableGroupElement)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.myGroupName == null ? other.myGroupName != null : !this.myGroupName.equals(other.myGroupName));
        }

        public String toString() {
            return "Variable group: " + this.myGroupName + " (" + this.getChildCount() + " children)";
        }

        private SimulationVariableStructure getOuterType() {
            return SimulationVariableStructure.this;
        }
    }

    public static abstract class VariableStructureElement
    extends BaseDAGNode
    implements Acceptable<SimulationVariableStructureVisitor>,
    Comparable<VariableStructureElement> {
        public abstract VariableStructureElementType getType();

        @Override
        public int compareTo(VariableStructureElement other) {
            return this.getType().compareTo(other.getType());
        }

        public static enum VariableStructureElementType {
            INPUT,
            GROUP,
            OUTPUT;

        }
    }
}

