/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.dag.DAGVisit;
import com.ericsson.ere.defs.ServiceFieldStructure;
import com.ericsson.ere.gui.simulator.SimulationPanelComponentBuilder;
import com.ericsson.ere.gui.simulator.SimulationVariableStructure;
import com.ericsson.ere.gui.simulator.SimulationVariableStructureVisitor;
import com.ericsson.ere.variable.DefaultVariableProducer;
import com.ericsson.ere.variable.VariableProducer;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.util.EnumEditor;
import ericsson.ere.gui.util.NumberRangeEditor;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.Variable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.w3c.dom.Element;

public class SimulationPanelHelper {
    private static final Map<String, ImageIcon> VARIABLE_ICON_MAP;
    private static final String ATTRIBUTE_TYPE = "Type";
    private static final String PARAMETER_TYPE_VALIDATION = "VALIDATION";
    private static final String PARAMETER_TYPE_VARIABLE = "VARIABLE";
    private static final String PARAMETER_TYPE_OUT = "OUT";
    private static final String PARAMETER_TYPE_IN = "IN";
    private Component myFocusOwner;
    private VariableProducer myVariableProducer;
    private static final List<String> INPUT_PARAMETER_TYPES;
    private static final List<String> OUTPUT_PARAMETER_TYPES;

    @Deprecated
    public static SimulationPanelHelper create(Component focusOwner) {
        return new SimulationPanelHelper(focusOwner, new DefaultVariableProducer(null));
    }

    public static SimulationPanelHelper create(Component focusOwner, VariableProducer producer) {
        return new SimulationPanelHelper(focusOwner, producer);
    }

    private SimulationPanelHelper(Component focusOwner, VariableProducer producer) {
        this.myFocusOwner = focusOwner;
        this.myVariableProducer = new IconVariableProducer(producer);
    }

    public SimulationVariableStructure buildSimulationVariableStructure(ServiceFieldStructure.StructureElement root, boolean sortVariables) {
        SimulationVariableStructure structure = SimulationVariableStructure.create(root, this.myVariableProducer, INPUT_PARAMETER_TYPES, OUTPUT_PARAMETER_TYPES, sortVariables);
        return structure;
    }

    public void collectSimulationVariables(SimulationVariableStructure structure, final List<Variable> inputList, final List<Variable> outputList) {
        SimulationVariableStructureVisitor visitor = new SimulationVariableStructureVisitor(){

            @Override
            public void visit(SimulationVariableStructure.VariableRootElement element) {
            }

            @Override
            public void visit(SimulationVariableStructure.VariableElement element) {
                if (element.getType() == SimulationVariableStructure.VariableStructureElement.VariableStructureElementType.INPUT) {
                    inputList.add(element.getVariable());
                } else {
                    outputList.add(element.getVariable());
                }
            }

            @Override
            public void visit(SimulationVariableStructure.VariableGroupElement element) {
            }

            @Override
            public void visit(SimulationVariableStructure.VariableHierarchicalElement element) {
                this.visit((SimulationVariableStructure.VariableElement)element);
            }

            @Override
            public void visit(SimulationVariableStructure.VariableHierarchicalGroupElement element) {
                this.visit((SimulationVariableStructure.VariableGroupElement)element);
            }
        };
        DAGVisit.visitPreOrder(structure.getRoot(), visitor);
    }

    public List<JComponent> buildSimulationComponents(SimulationVariableStructure structure) {
        SimulationPanelComponentBuilder builder = SimulationPanelComponentBuilder.create(structure, this.myFocusOwner);
        return builder.createComponentList();
    }

    @Deprecated
    public List<JComponent> buildClosableVarPanels(boolean sort, List<Variable> inputList, List<Variable> outputList, ClassRepository classRepository, Element root) {
        ServiceFieldStructure.StructureElement fieldRoot;
        ServiceFieldStructure structure = classRepository.getFieldStructure();
        String tagName = root.getTagName();
        if ("Fields".equals(tagName)) {
            fieldRoot = structure.getRoot().getNamedChild("Common fields");
        } else if ("Context".equals(tagName)) {
            String contextName = root.getAttribute("Name");
            fieldRoot = structure.getRoot().getNamedChild(contextName);
        } else {
            throw new IllegalArgumentException("Unrecognized field root: " + tagName);
        }
        SimulationVariableStructure variableStructure = this.buildSimulationVariableStructure(fieldRoot, sort);
        this.collectSimulationVariables(variableStructure, inputList, outputList);
        return this.buildSimulationComponents(variableStructure);
    }

    public JPanel createVarTable(List<Variable> varList) {
        return SimulationPanelComponentBuilder.createPanelForVariables(varList, this.myFocusOwner);
    }

    public JPanel createVarTableWithArrayVariablesLast(List<Variable> varList) {
        return SimulationPanelComponentBuilder.createPanelForVariablesWithLargeVariablesLast(varList, this.myFocusOwner);
    }

    public static NumberRangeEditor buildNumberRangeEditor(Element element) {
        NumberRangeEditor editor = null;
        Element component = XMLUtil.getFirstElementNamed("EditComponent", element);
        if (component != null) {
            if ("ericsson.ere.gui.util.NumberRangeEditor".equals(component.getAttribute("class"))) {
                editor = new NumberRangeEditor();
            }
        } else {
            component = XMLUtil.getFirstElementNamed("InputRestriction", element);
            if (component != null && component.getAttribute(ATTRIBUTE_TYPE).equals("Range")) {
                editor = new NumberRangeEditor();
            }
        }
        if (editor != null) {
            editor.init(component);
            return editor;
        }
        return null;
    }

    public static EnumEditor buildEnumEditor(Element element) {
        EnumEditor editor = null;
        Element component = XMLUtil.getFirstElementNamed("EditComponent", element);
        if (component != null) {
            if ("ericsson.ere.gui.util.EnumEditor".equals(component.getAttribute("class"))) {
                editor = new EnumEditor();
            }
        } else {
            component = XMLUtil.getFirstElementNamed("InputRestriction", element);
            if (component != null && component.getAttribute(ATTRIBUTE_TYPE).equals("Enum")) {
                editor = new EnumEditor();
            }
        }
        if (editor != null) {
            editor.init(component);
            return editor;
        }
        return null;
    }

    @Deprecated
    public static List<Variable> buildVariablesFromFieldDefinitions(List<FieldDefinition> fields) {
        ArrayList<Variable> variables = new ArrayList<Variable>(fields.size());
        for (FieldDefinition field : fields) {
            variables.add(SimulationPanelHelper.produceVariable(field));
        }
        return variables;
    }

    @Deprecated
    public static Variable createVariableFromField(Element currentElement, ClassRepository classRepository) {
        String name = currentElement.getAttribute("Name");
        FieldDefinition def = classRepository.getFieldDefinitionByName(name);
        if (def == null) {
            return null;
        }
        return SimulationPanelHelper.produceVariable(classRepository, def);
    }

    Variable createVariableFromField(FieldDefinition def) {
        return this.myVariableProducer.produceVariable(def);
    }

    @Deprecated
    public static Variable produceVariable(FieldDefinition field) {
        return SimulationPanelHelper.produceVariable(null, field);
    }

    public static Variable produceVariable(ClassRepository repository, FieldDefinition field) {
        return new DefaultVariableProducer(repository).produceVariable(field);
    }

    public static Object[] createArrayType(String dataType) {
        DataType dt = DataType.lookup(dataType);
        if (dt != null) {
            return dt.createArray();
        }
        return null;
    }

    public static Object[] createArrayType(String dataType, Object value) {
        DataType dt = DataType.lookup(dataType);
        if (dt == null) {
            return null;
        }
        Object val = value instanceof String ? dt.parseValue(value.toString()) : value;
        return dt.createArray(val);
    }

    public static Collection<Object> parseValue(String theDefaultValues, String theDataType) {
        DataType dt = DataType.lookup(theDataType);
        if (dt == null) {
            RmaDefs.loggerSimulator.warning("DataType " + theDataType + " unknown in SimulationPanelHelper.parseValue(String, String)");
            return Collections.emptyList();
        }
        Object[] array = dt.parseMultiValue(theDefaultValues);
        return Arrays.asList(array);
    }

    public static Object convertToCorrectDataType(DropDownVariable var, ClassRepository rep) {
        String fieldName = var.getKey();
        if (fieldName.endsWith(" (IN)")) {
            fieldName = fieldName.substring(0, fieldName.length() - " (IN)".length());
        } else if (fieldName.endsWith(" (OUT)")) {
            fieldName = fieldName.substring(0, fieldName.length() - " (OUT)".length());
        }
        DataType dt = rep.getFieldDefinitionByName(fieldName).getTypedDataType();
        if (dt != null) {
            return dt.parseValue(var.getValueObject().toString());
        }
        return var.getValueObject().toString();
    }

    static {
        INPUT_PARAMETER_TYPES = Arrays.asList(PARAMETER_TYPE_IN);
        OUTPUT_PARAMETER_TYPES = Arrays.asList(PARAMETER_TYPE_OUT, PARAMETER_TYPE_VARIABLE, PARAMETER_TYPE_VALIDATION);
        VARIABLE_ICON_MAP = new HashMap<String, ImageIcon>();
        VARIABLE_ICON_MAP.put(PARAMETER_TYPE_OUT, RmaDefs.getImageIcon("field_out.png"));
        VARIABLE_ICON_MAP.put(PARAMETER_TYPE_IN, RmaDefs.getImageIcon("field_in.png"));
        VARIABLE_ICON_MAP.put(PARAMETER_TYPE_VARIABLE, RmaDefs.getImageIcon("field_variable.png"));
        VARIABLE_ICON_MAP.put(PARAMETER_TYPE_VALIDATION, RmaDefs.getImageIcon("field_validate.png"));
    }

    private static class IconVariableProducer
    implements VariableProducer {
        private VariableProducer myProducer;

        IconVariableProducer(VariableProducer producer) {
            this.myProducer = producer;
        }

        @Override
        public Variable produceVariable(FieldDefinition field) {
            Variable variable = this.myProducer.produceVariable(field);
            this.setIcon(variable, field.getParameterType());
            return variable;
        }

        private void setIcon(Variable variable, String parameterType) {
            ImageIcon icon = (ImageIcon)VARIABLE_ICON_MAP.get(parameterType);
            if (icon != null) {
                variable.setIcon(icon);
            }
        }

        @Override
        public Variable produceVariable(DataType dataType, Object value) {
            return this.myProducer.produceVariable(dataType, value);
        }

        @Override
        public Variable produceVariable(String groupName, List<FieldDefinition> fields) {
            return this.myProducer.produceVariable(groupName, fields);
        }
    }
}

