/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.dataset.DataDescriber;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.gui.simulator.GroupedObjectArrayVariableValidator;
import com.ericsson.ere.gui.simulator.SimulationDataPanel;
import com.ericsson.ere.gui.simulator.SimulationDataPanelValidator;
import com.ericsson.ere.gui.simulator.StandardVariableValidator;
import com.ericsson.ere.gui.simulator.VariableValidator;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.array.GroupedObjectArrayVariable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultSimulationDataPanelValidator
implements SimulationDataPanelValidator {
    private ClassRepository myClassRepository;
    private DataDescriber myDataDescriber;
    private VariableValidator myDefaultVariableValidator;
    private Map<Class<? extends Variable>, VariableValidator> myVariableValidators;

    public DefaultSimulationDataPanelValidator(ClassRepository repository, DataDescriber describer) {
        this.myClassRepository = repository;
        this.myDataDescriber = describer;
        this.myDefaultVariableValidator = new StandardVariableValidator(repository, describer);
        this.myVariableValidators = this.initializeValidators(repository, describer);
    }

    private Map<Class<? extends Variable>, VariableValidator> initializeValidators(ClassRepository repository, DataDescriber describer) {
        HashMap<Class<? extends Variable>, VariableValidator> map = new HashMap<Class<? extends Variable>, VariableValidator>();
        map.put(GroupedObjectArrayVariable.class, new GroupedObjectArrayVariableValidator(repository, describer));
        return map;
    }

    @Override
    public boolean validate(SimulationDataPanel panel, DataSet dataSet, List<String> info) {
        return this.validate(dataSet, info, panel.getAllOutputParameters());
    }

    boolean validate(DataSet dataset, List<String> info, List<Variable> varList) {
        for (Variable variable : varList) {
            if (!variable.isSelected()) continue;
            VariableValidator validator = this.selectVariableValidator(variable);
            validator.validateVariable(variable, dataset, info);
        }
        return info.isEmpty();
    }

    protected VariableValidator selectVariableValidator(Variable variable) {
        VariableValidator validator = this.myVariableValidators.get(variable.getClass());
        if (validator == null) {
            validator = this.myDefaultVariableValidator;
        }
        return validator;
    }

    boolean compare(Object actualValue, ArrayModel expectedModel) {
        return new StandardVariableValidator(this.myClassRepository, this.myDataDescriber).compare(actualValue, expectedModel);
    }

    void printFieldDiff(String label, DataType dataType, Object variableValue, Object dataSetValue, List<String> info) {
        new StandardVariableValidator(this.myClassRepository, this.myDataDescriber).printFieldDiff(label, dataType, variableValue, dataSetValue, info);
    }

    void printFieldDiff(FieldDefinition fd, Object variableValue, Object dataSetValue, List<String> info) {
        new StandardVariableValidator(this.myClassRepository, this.myDataDescriber).printFieldDiff(fd, variableValue, dataSetValue, info);
    }
}

