/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.search.presenter;

import com.ericsson.ere.gui.search.BranchSearchStateHandler;
import com.ericsson.ere.gui.search.presenter.BranchSearchFilterEditPresenter;
import com.ericsson.ere.gui.search.presenter.BranchSearchFilterSelectionPresenter;
import com.ericsson.ere.gui.search.view.BranchSearchFilterEditView;
import com.ericsson.ere.gui.search.view.BranchSearchFilterSelectionView;
import com.ericsson.ere.gui.search.view.BranchSearchSearchView;
import com.ericsson.ere.selectiontree.search.BranchList;
import com.ericsson.ere.selectiontree.search.BranchSearchModel;
import ericsson.ere.gui.util.ProgressDialog;
import ericsson.ere.management.ContextAwareServiceContainer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;

public class BranchSearchSearchPresenter {
    private BranchSearchSearchView mySearchView;
    private BranchSearchFilterSelectionPresenter mySelectionPresenter;
    private BranchSearchStateHandler myStateHandler;

    public BranchSearchSearchPresenter(BranchSearchSearchView searchView, ContextAwareServiceContainer serviceContainer, File storage, BranchSearchStateHandler stateHandler) {
        this.mySearchView = searchView;
        this.myStateHandler = stateHandler;
        this.createModel(serviceContainer, storage);
        this.subscribeToViewEvents();
    }

    private void createModel(ContextAwareServiceContainer serviceContainer, File storage) {
        BranchSearchModel model = new BranchSearchModel();
        BranchSearchFilterSelectionView selectionView = this.mySearchView.getFilterSelectionView();
        BranchSearchFilterEditView editView = this.mySearchView.getFilterEditView();
        this.mySelectionPresenter = new BranchSearchFilterSelectionPresenter(selectionView, model, storage, serviceContainer);
        new BranchSearchFilterEditPresenter(editView, selectionView, model, serviceContainer);
    }

    private void subscribeToViewEvents() {
        this.mySearchView.searchFiltersEvent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSearchSearchPresenter.this.performSearch();
            }
        });
    }

    void performSearch() {
        boolean yes;
        if (!this.myStateHandler.isTreeValid()) {
            this.mySearchView.handleError(null, "The selection tree has invalid configuration.\nPlease correct faulty settings before performing a branch search.");
            return;
        }
        if (this.mySearchView.getFilterEditView().isModified() && !(yes = this.mySearchView.askYesNoQuestion("The filter being edited has unsaved changes that will not be considered. Do you want to search anyway?"))) {
            return;
        }
        ProgressDialog dialog = new ProgressDialog("Searching", "Searching for branches...", false);
        dialog.setIndeterminate(true);
        dialog.setStringPainted(false);
        new Searcher(dialog).execute();
        dialog.setVisible(true);
    }

    private class Searcher
    extends SwingWorker<BranchList, Void> {
        private ProgressDialog myDialog;

        Searcher(ProgressDialog dialog) {
            this.myDialog = dialog;
        }

        @Override
        protected BranchList doInBackground() throws Exception {
            boolean includeZeroScore = BranchSearchSearchPresenter.this.mySearchView.shouldConsiderZeroScores();
            BranchList branches = BranchSearchSearchPresenter.this.myStateHandler.findAllBranches();
            branches = BranchSearchSearchPresenter.this.mySelectionPresenter.filterBranches(branches, includeZeroScore);
            return branches;
        }

        @Override
        protected void done() {
            this.myDialog.dispose();
            try {
                BranchList branches = (BranchList)this.get();
                BranchSearchSearchPresenter.this.myStateHandler.populateResultView(branches);
            }
            catch (InterruptedException branches) {
            }
            catch (ExecutionException ex) {
                BranchSearchSearchPresenter.this.mySearchView.handleError(ex.getCause(), "Failed to search for branches.");
            }
        }
    }
}

