/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.search.presenter;

import com.ericsson.ere.gui.search.view.BranchSearchFilterSelectionView;
import com.ericsson.ere.selectiontree.search.BranchList;
import com.ericsson.ere.selectiontree.search.BranchSearchModel;
import com.ericsson.ere.selectiontree.search.filter.BranchFilter;
import com.ericsson.ere.selectiontree.search.filter.SimulationBasedParameterBranchFilter;
import com.ericsson.ere.selectiontree.search.predicate.BranchPredicate;
import ericsson.ere.management.ContextAwareServiceContainer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class BranchSearchFilterSelectionPresenter {
    private BranchSearchModel myMainModel;
    private BranchSearchModel.BranchSearchSelectionModel myIncludeModel;
    private BranchSearchModel.BranchSearchSelectionModel myExcludeModel;
    private BranchSearchFilterSelectionView myView;
    private File myStorage;
    private ContextAwareServiceContainer myServiceContainer;
    private Handler myHandler = new Handler();

    public BranchSearchFilterSelectionPresenter(BranchSearchFilterSelectionView view, BranchSearchModel model, File storage, ContextAwareServiceContainer serviceContainer) {
        if (serviceContainer == null || view == null || model == null) {
            throw new IllegalArgumentException("Service, view and model must be non-null.");
        }
        this.myStorage = storage;
        this.myServiceContainer = serviceContainer;
        this.myView = view;
        this.myMainModel = model;
        this.createAndSetModels();
        this.subscribeToViewEvents();
    }

    private void subscribeToViewEvents() {
        this.myView.selectIncludeEvent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSearchFilterSelectionPresenter.this.selectFilters(BranchSearchFilterSelectionPresenter.this.myView.getSelectedMainFilters(), BranchSearchFilterSelectionPresenter.this.myIncludeModel);
            }
        });
        this.myView.selectExcludeEvent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSearchFilterSelectionPresenter.this.selectFilters(BranchSearchFilterSelectionPresenter.this.myView.getSelectedMainFilters(), BranchSearchFilterSelectionPresenter.this.myExcludeModel);
            }
        });
        this.myView.deselectIncludeEvent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSearchFilterSelectionPresenter.this.deselectFilters(BranchSearchFilterSelectionPresenter.this.myView.getSelectedIncludeFilters(), BranchSearchFilterSelectionPresenter.this.myIncludeModel);
            }
        });
        this.myView.deselectExcludeEvent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSearchFilterSelectionPresenter.this.deselectFilters(BranchSearchFilterSelectionPresenter.this.myView.getSelectedExcludeFilters(), BranchSearchFilterSelectionPresenter.this.myExcludeModel);
            }
        });
        this.myView.deleteFiltersEvent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSearchFilterSelectionPresenter.this.deleteSelectedFilters();
            }
        });
        this.myView.exportFiltersEvent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSearchFilterSelectionPresenter.this.exportSelectedFilters();
            }
        });
        this.myView.importFiltersEvent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSearchFilterSelectionPresenter.this.importFilters();
            }
        });
    }

    private void createAndSetModels() {
        this.loadMainModel();
        this.myIncludeModel = this.myMainModel.createSelectionModel();
        this.myExcludeModel = this.myMainModel.createSelectionModel();
        this.myIncludeModel.mutuallyExclusiveWith(this.myExcludeModel);
        this.myView.setMainFilterModel(this.myMainModel);
        this.myView.setIncludeFilterModel(this.myIncludeModel);
        this.myView.setExcludeFilterModel(this.myExcludeModel);
        this.myMainModel.addListDataListener(this.myHandler);
    }

    private void loadMainModel() {
        if (this.myStorage != null && this.myStorage.exists()) {
            try {
                this.myMainModel.importFiltersFromFile(this.myStorage, null);
            }
            catch (IOException ex) {
                this.myView.handleError(ex, "Failed to load all or some filters from " + this.myStorage.getPath());
            }
            List<BranchFilter> failedFilters = this.initializeFilters(this.myMainModel);
            this.removeFailedFiltersAndNotify(this.myMainModel, failedFilters);
        }
        this.trackFilters(this.myMainModel, 0, this.myMainModel.getSize() - 1);
    }

    private void removeFailedFiltersAndNotify(BranchSearchModel model, List<BranchFilter> filters) {
        if (!filters.isEmpty()) {
            int count = filters.size();
            model.removeFilters(this.filterNames(filters.toArray()));
            StringBuilder msg = new StringBuilder("Failed to initialize ");
            msg.append(count);
            this.appendWithOptionalPluralS(msg, " filter", count);
            msg.append(" (perhaps a service mismatch).");
            this.myView.handleError(null, msg.toString());
        }
    }

    private List<BranchFilter> initializeFilters(BranchSearchModel model) {
        ArrayList<BranchFilter> initFailedList = new ArrayList<BranchFilter>();
        for (BranchFilter filter : model.getFilters()) {
            if (this.setServiceOnFilter(filter)) continue;
            initFailedList.add(filter);
        }
        return initFailedList;
    }

    private void trackFilters(BranchSearchModel model, int index0, int index1) {
        for (int i = index0; i <= index1; ++i) {
            BranchFilter filter = (BranchFilter)model.getElementAt(i);
            filter.removePropertyListener(this.myHandler);
            filter.addPropertyListener(this.myHandler);
        }
    }

    private boolean setServiceOnFilter(BranchFilter filter) {
        boolean succeeded = true;
        if (filter instanceof SimulationBasedParameterBranchFilter) {
            try {
                ((SimulationBasedParameterBranchFilter)filter).setService(this.myServiceContainer);
            }
            catch (IllegalStateException ex) {
                throw new AssertionError((Object)ex);
            }
            catch (IllegalArgumentException ex) {
                succeeded = false;
            }
        }
        return succeeded;
    }

    private void saveMainModel(boolean makeBackup) throws IOException {
        if (this.myStorage == null) {
            return;
        }
        if (makeBackup) {
            File backupFile = new File(this.removeExtension(this.myStorage.getCanonicalPath()) + ".bak");
            backupFile.delete();
            this.myStorage.renameTo(backupFile);
        }
        this.myMainModel.saveToFile(this.myStorage);
    }

    private String removeExtension(String path) {
        int slash;
        int dot = path.lastIndexOf(46);
        return dot > (slash = Math.max(path.lastIndexOf(47), path.lastIndexOf(92))) ? path.substring(0, dot) : path;
    }

    void deselectFilters(Object[] filters, BranchSearchModel.BranchSearchSelectionModel model) {
        for (Object filter : filters) {
            model.deselectFilter(this.filterName(filter));
        }
    }

    void selectFilters(Object[] filters, BranchSearchModel.BranchSearchSelectionModel destModel) {
        for (Object filter : filters) {
            destModel.selectFilter(this.filterName(filter));
        }
    }

    void deleteSelectedFilters() {
        Object[] filters = this.myView.getSelectedMainFilters();
        if (filters.length == 0 || !this.myView.askYesNoQuestion("Filter deletion cannot be undone. Do you want to continue?")) {
            return;
        }
        this.myMainModel.removeFilters(this.filterNames(filters));
        this.saveMainModelWithErrorHandling(true);
    }

    void saveMainModelWithErrorHandling(boolean makeBackup) {
        try {
            this.saveMainModel(makeBackup);
        }
        catch (IOException ex) {
            this.myView.handleError(ex, "Failed to save filters to " + this.myStorage.getPath());
        }
    }

    void exportSelectedFilters() {
        Object[] filters = this.myView.getSelectedMainFilters();
        if (filters.length == 0) {
            return;
        }
        this.exportFilters(filters);
    }

    private void exportFilters(Object[] filters) {
        boolean overwrite;
        File file = this.myView.getExportFile();
        if (file == null) {
            return;
        }
        if (file.exists() && !(overwrite = this.myView.askYesNoQuestion("File " + file.getPath() + " exists. Do you want to overwrite it?"))) {
            this.exportFilters(filters);
            return;
        }
        ArrayList<String> filterNames = new ArrayList<String>(filters.length);
        for (Object filter : filters) {
            filterNames.add(this.filterName(filter));
        }
        try {
            this.myMainModel.exportFiltersToFile(file, filterNames);
            this.myView.showInformation(this.createExportMessage(file, filters.length));
        }
        catch (IOException ex) {
            this.myView.handleError(ex, "Failed to export filters to " + file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importFilters() {
        File file = this.myView.getImportFile();
        if (file != null) {
            boolean imported = false;
            ArrayList<BranchFilter> conflicts = new ArrayList<BranchFilter>();
            try {
                this.myMainModel.removeListDataListener(this.myHandler);
                BranchSearchModel copy = this.copyOf(this.myMainModel);
                int before = copy.getSize();
                copy.importFiltersFromFile(file, conflicts);
                int filterCount = copy.getSize() - before;
                int conflictCount = conflicts.size();
                if (conflictCount > 0) {
                    this.renameConflictingFiltersAndAddToModel(copy, conflicts);
                }
                for (BranchFilter mainFilter : this.myMainModel.getFilters()) {
                    copy.removeFilter(mainFilter.getName());
                }
                int totalCount = filterCount + conflictCount;
                if (totalCount > 0) {
                    List<BranchFilter> failedFilters = this.initializeFilters(copy);
                    this.removeFailedFiltersAndNotify(copy, failedFilters);
                    int totalFailCount = failedFilters.size();
                    failedFilters.retainAll(conflicts);
                    int conflictFailCount = failedFilters.size();
                    int filterFailCount = totalFailCount - conflictCount;
                    filterCount -= filterFailCount;
                    conflictCount -= conflictFailCount;
                }
                if ((totalCount = filterCount + conflictCount) > 0) {
                    imported = true;
                    this.trackFilters(copy, 0, copy.getSize() - 1);
                    this.transferFilters(copy, this.myMainModel, true);
                    this.myView.showInformation(this.createImportMessage(filterCount, conflictCount));
                }
            }
            catch (IOException ex) {
                this.myView.handleError(ex, "Failed to import filters from " + file.getPath());
            }
            finally {
                this.myMainModel.addListDataListener(this.myHandler);
                if (imported) {
                    this.saveMainModelWithErrorHandling(false);
                }
            }
        }
    }

    private String filterName(Object filter) {
        return ((BranchFilter)filter).getName();
    }

    private String[] filterNames(Object[] filters) {
        String[] names = new String[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            names[i] = ((BranchFilter)filters[i]).getName();
        }
        return names;
    }

    private BranchSearchModel copyOf(BranchSearchModel model) {
        BranchSearchModel copy = new BranchSearchModel();
        this.transferFilters(model, copy, false);
        return copy;
    }

    private void transferFilters(BranchSearchModel source, BranchSearchModel dest, boolean move) {
        ArrayList<BranchFilter> filters = new ArrayList<BranchFilter>(source.getFilters());
        for (BranchFilter filter : filters) {
            dest.addFilter(filter);
            if (!move) continue;
            source.removeFilter(filter.getName());
        }
    }

    public BranchList filterBranches(BranchList input, boolean includeZeroScoreBranches) {
        BranchPredicate includePredicate = this.myIncludeModel.getSize() > 0 ? this.createPredicate(this.myIncludeModel) : null;
        BranchPredicate excludePredicate = this.myExcludeModel.getSize() > 0 ? this.createPredicate(this.myExcludeModel) : null;
        return BranchSearchFilterSelectionPresenter.filterBranches(input, includeZeroScoreBranches, includePredicate, excludePredicate);
    }

    public static BranchList filterBranches(BranchList input, boolean includeZeroScoreBranches, BranchPredicate includePredicate, BranchPredicate excludePredicate) {
        BranchList ret = input;
        if (includePredicate != null) {
            ret = includeZeroScoreBranches ? ret.considerZeroScoreBranchesInFiltering() : ret;
            ret = ret.includeBy(includePredicate);
        }
        if (excludePredicate != null) {
            ret = ret.excludeBy(excludePredicate);
        }
        return ret;
    }

    private String createExportMessage(File file, int filterCount) {
        StringBuilder b = new StringBuilder();
        b.append("Successfully exported ");
        b.append(filterCount);
        this.appendWithOptionalPluralS(b, " filter", filterCount);
        b.append(" to ");
        b.append(file.getPath());
        b.append(".");
        return b.toString();
    }

    private String createImportMessage(int filterCount, int conflictCount) {
        int totalCount = filterCount + conflictCount;
        StringBuilder b = new StringBuilder();
        b.append("Successfully imported ");
        b.append(totalCount);
        this.appendWithOptionalPluralS(b, " filter", totalCount);
        if (conflictCount > 0) {
            b.append(", of which ");
            b.append(conflictCount).append(" ");
            this.appendWasWere(b, conflictCount);
            b.append(" renamed due to name conflicts");
        }
        b.append(".");
        return b.toString();
    }

    private void appendWithOptionalPluralS(StringBuilder b, String s, int count) {
        b.append(s);
        if (count > 1) {
            b.append("s");
        }
    }

    private void appendWasWere(StringBuilder b, int count) {
        b.append(count > 1 ? "were" : "was");
    }

    private void renameConflictingFiltersAndAddToModel(BranchSearchModel model, List<BranchFilter> conflicts) throws IOException {
        block0: for (BranchFilter filter : conflicts) {
            String name = filter.getName();
            int num = 2;
            while (true) {
                if (num > 1000) {
                    throw new IOException("Failed to resolve conflict for filter " + name);
                }
                String newname = name + " (" + num + ")";
                filter.setName(newname);
                if (model.addFilter(filter)) continue block0;
                ++num;
            }
        }
    }

    private BranchPredicate createPredicate(BranchSearchModel.BranchSearchSelectionModel model) {
        return model.createIntersectionPredicate();
    }

    private class Handler
    implements VetoableChangeListener,
    ListDataListener {
        private Handler() {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (evt.getPropertyName().equals("data")) {
                BranchSearchFilterSelectionPresenter.this.saveMainModelWithErrorHandling(false);
            }
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            assert (e.getSource() == BranchSearchFilterSelectionPresenter.this.myMainModel);
            BranchSearchFilterSelectionPresenter.this.trackFilters(BranchSearchFilterSelectionPresenter.this.myMainModel, e.getIndex0(), e.getIndex1());
            BranchSearchFilterSelectionPresenter.this.saveMainModelWithErrorHandling(false);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }
    }
}

