/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.search;

import com.ericsson.ere.gui.search.BranchElementCellRenderer;
import com.ericsson.ere.gui.search.BranchSearchTableModelImpl;
import com.ericsson.ere.gui.search.BranchSearchUIContext;
import com.ericsson.ere.gui.search.view.CommonView;
import com.ericsson.ere.selectiontree.search.BranchTreeElement;
import com.ericsson.ere.selectiontree.util.SelectionTreeUtil;
import com.ericsson.ere.swing.TableColumnResizer;
import com.ericsson.ere.swing.TableRowResizer;
import com.ericsson.ere.swing.TransposingTableModel;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.ratingrules.RatingRuleTree;
import ericsson.ere.gui.ratingrules.nodes.TSLink;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.DAGUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;

public class BranchSearchResultTable
extends JTable {
    private BranchSearchUIContext myContext;
    private CommonView myView;

    public BranchSearchResultTable(BranchSearchUIContext ctx, CommonView view) {
        this.myContext = ctx;
        this.myView = view;
        this.init();
    }

    private void init() {
        this.setName("BranchSearch.ResultPanel.ResultTable");
        this.setAutoResizeMode(0);
        Color defaultGray = new Color(238, 238, 238);
        this.setBackground(defaultGray);
        this.setGridColor(Color.black);
        this.setCellSelectionEnabled(true);
        this.setSelectionMode(0);
        this.setRowHeight(50);
        this.getTableHeader().setReorderingAllowed(false);
        new TableColumnResizer(this, 130, Integer.MAX_VALUE, 50);
        new TableRowResizer(this, 50, Integer.MAX_VALUE);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                int row = BranchSearchResultTable.this.rowAtPoint(p);
                int column = BranchSearchResultTable.this.columnAtPoint(p);
                if (row != -1) {
                    BranchSearchResultTable.this.checkIfElementPathIsUnique(row, column);
                    if (e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(e)) {
                        BranchSearchResultTable.this.showSelectedElement(row, column, false);
                    } else if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                        BranchSearchResultTable.this.showSelectedElement(row, column, true);
                    }
                }
            }
        });
    }

    private void checkIfElementPathIsUnique(int row, int column) {
        Object cellData = this.getModel().getValueAt(row, column);
        if (cellData instanceof BranchTreeElement) {
            BranchTreeElement data = (BranchTreeElement)this.getModel().getValueAt(row, column);
            Object[] pathToRoot = DAGUtil.getPathToRoot((DAGNode)((Object)data)).getPath();
            this.replaceViewWrappers(pathToRoot);
            String nodeId = TSLink.checkDuplicatesInPath(pathToRoot, 0, new int[1]);
            if (nodeId != null) {
                this.myView.handleError(null, "Selected element has an ambiguous path, selecting path in the tree may fail.");
            } else {
                this.myView.handleError(null, "");
            }
        } else {
            this.myView.handleError(null, "");
        }
    }

    private void replaceViewWrappers(Object[] pathToRoot) {
        for (int i = 0; i < pathToRoot.length; ++i) {
            TariffStructureNode elem = (TariffStructureNode)pathToRoot[i];
            Integer level = SelectionTreeUtil.getElementData(elem, BranchSearchTableModelImpl.ELEMENT_CHILD_LEVEL, Integer.class);
            if (level == null) continue;
            pathToRoot[i] = ((BranchTreeElement)((Object)elem)).getElement();
        }
    }

    private void showSelectedElement(int row, int column, boolean selectRuleFrame) {
        Object cellData = this.getModel().getValueAt(row, column);
        if (cellData instanceof BranchTreeElement) {
            BranchTreeElement data = (BranchTreeElement)this.getModel().getValueAt(row, column);
            TreePath tempPath = DAGUtil.getPathToRoot((DAGNode)((Object)data));
            String pathString = DAGUtil.getTreePathToString(tempPath);
            RatingRuleTree tree = this.myContext.getTree();
            TariffStructureNode treeRoot = (TariffStructureNode)tree.getModel().getRoot();
            TreePath path = DAGUtil.getStringToTreePath(pathString, treeRoot);
            tree.scrollPathToVisible(path);
            tree.setSelectionPath(path);
            if (selectRuleFrame) {
                GuiServiceCenter.setSelectedNoVeto(this.myContext.getSearchFrame(), false);
                GuiUtil.setIconIgnoringException(this.myContext.getOwnerFrame(), false);
                GuiServiceCenter.setSelectedNoVeto(this.myContext.getOwnerFrame(), true);
            }
        }
    }

    private void configureTableForModel() {
        boolean isRowBased = this.isRowBasedModel();
        JTableHeader header = this.getTableHeader();
        if (header != null) {
            header.setVisible(!isRowBased);
        }
        this.setShowVerticalLines(!isRowBased);
        this.setShowHorizontalLines(isRowBased);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn col = this.getColumn(this.getColumnName(i));
            if (i == 0 && isRowBased) {
                col.setCellRenderer(new TransposingTableModel.HeaderColumnRenderer(this));
                continue;
            }
            col.setCellRenderer(new BranchElementCellRenderer(isRowBased));
            col.setPreferredWidth(130);
        }
    }

    @Override
    public void setModel(TableModel model) {
        super.setModel(model);
        this.configureTableForModel();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (e.getFirstRow() == -1) {
            this.configureTableForModel();
        }
    }

    public void setRowBased(boolean rowBased) {
        TableModel model = this.getModel();
        if (rowBased != this.isRowBasedModel()) {
            if (rowBased) {
                TransposingTableModel newModel = new TransposingTableModel(model);
                this.setModel(newModel);
            } else {
                TableModel inner = ((TransposingTableModel)model).getInnerModel();
                this.setModel(inner);
            }
        }
    }

    private boolean isRowBasedModel() {
        return this.getModel() instanceof TransposingTableModel;
    }
}

