/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.ratingrules;

import com.ericsson.ere.gui.ratingrules.SelectionTree;
import com.ericsson.ere.gui.ratingrules.SelectionTreeActionBuilder;
import com.ericsson.ere.gui.ratingrules.SelectionTreeActionHandler;
import com.ericsson.ere.gui.ratingrules.actions.AddElement;
import com.ericsson.ere.gui.ratingrules.actions.Copy;
import com.ericsson.ere.gui.ratingrules.actions.DeleteAction;
import com.ericsson.ere.gui.ratingrules.actions.GotoLinkTargetAction;
import com.ericsson.ere.gui.ratingrules.actions.Import;
import com.ericsson.ere.gui.ratingrules.actions.InternalPrint;
import com.ericsson.ere.gui.ratingrules.actions.Invokable;
import com.ericsson.ere.gui.ratingrules.actions.InvokableAction;
import com.ericsson.ere.gui.ratingrules.actions.Move;
import com.ericsson.ere.gui.ratingrules.actions.Paste;
import com.ericsson.ere.gui.ratingrules.actions.Save;
import com.ericsson.ere.gui.ratingrules.actions.Search;
import com.ericsson.ere.gui.ratingrules.actions.SelectionTreeActionContext;
import com.ericsson.ere.gui.ratingrules.actions.ShowReferencesAction;
import com.ericsson.ere.gui.ratingrules.actions.TestGenerationAction;
import com.ericsson.ere.gui.ratingrules.actions.TreeState;
import com.ericsson.ere.gui.ratingrules.actions.Undo;
import com.ericsson.ere.swing.AbstractActionBasedPopupMenu;
import com.ericsson.ere.swing.ActionBuilder;
import com.ericsson.ere.swing.ConditionallyEnabledAbstractAction;
import com.ericsson.ere.swing.DispatchActionEvent;
import ericsson.ere.integration.settingsmap.SettingsMap;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.JTree;

public class SelectionTreePopupMenu
extends AbstractActionBasedPopupMenu {
    private static final long serialVersionUID = 1L;
    private SelectionTreeActionContext myActionContext;
    private SettingsMap mySettingsMap;
    private SelectionTreeActionHandler myActionHandler;
    static final String VISIBILITY_PROPERTY_KEY = "visibility-property-name";
    static final String LBL_COPY = "Copy";
    static final String LBL_COPY_LINK = "Copy Link";
    static final String LBL_PASTE = "Paste";
    static final String LBL_PASTE_SPECIAL = "Paste...";
    static final String LBL_DELETE = "Delete";
    static final String LBL_SHOW_REF = "Show References";
    static final String LBL_OPEN = "Import...";
    static final String LBL_SAVE = "Save";
    static final String LBL_SAVE_AS = "Save As...";
    static final String LBL_SAVE_SINGLE = "To associated ERE";
    static final String LBL_SAVE_FILE = "To current file";
    static final String LBL_DISTRIBUTE = "To multiple EREs...";
    static final String LBL_EXPORT = "Export...";
    static final String LBL_FIND = "Find";
    static final String LBL_SHOW_FIND_PARAMETERS = "Show Find Parameters";
    static final String LBL_BRANCH_SEARCH = "Search for branches...";
    static final String LBL_PRINT_CLASS = "Print Class";
    static final String LBL_PRINT_STRUCTURE = "Print Tariff";
    static final String LBL_MOVE_UP = "Move Up";
    static final String LBL_MOVE_DOWN = "Move Down";
    static final String LBL_UNDO = "Undo";
    static final String LBL_REDO = "Redo";
    static final String LBL_GENERATE = "Generate Simulation set";
    static final String LBL_EXPAND_ALL = "Expand All";
    static final String LBL_COLLAPSE_ALL = "Collapse All";
    static final String LBL_PASTE_AS_CHILD = "Paste as child";
    static final String LBL_PASTE_AS_SIBLING = "Paste as sibling";
    static final String LBL_ADD_NODE_AS_SIBLING = "Add";
    static final String LBL_ADD_NODE_AS_CHILD = "Add child";
    static final String LBL_ADD_NODE = "Node";
    static final String LBL_ADD_CONDITION = "Condition";
    static final String LBL_ADD_MODIFIER = "Modifier";
    static final String CMD_ADD_CHILD_NODE = "Node";
    static final String CMD_ADD_CHILD_CONDITION = "Condition";
    static final String CMD_ADD_CHILD_MODIFIER = "Modifier";
    static final String LBL_GOTO_LINK_TARGET = "Goto Link Target";
    private Action myAddNodeAction;
    private Action myAddChildNodeAction;
    private Action myAddConditionAction;
    private Action myAddChildConditionAction;
    private Action myAddModifierAction;
    private Action myAddChildModifierAction;
    private Action myCopyAction;
    private Action myCopyLinkAction;
    private Action myPasteDefaultAction;
    private Action myPasteAsChildAction;
    private Action myPasteAsSiblingAction;
    private Action myDeleteAction;
    private Action mySaveAction;
    private Action mySaveAsAction;
    private Action myDistributeAction;
    private Action myImportAction;
    private Action myExportAction;
    private Action myShowRefAction;
    private Action myGotoLinkTargetAction;
    private Action myFindAction;
    private Action myBranchSearchAction;
    private Action myShowFindParameterAction;
    private Action myMoveUpAction;
    private Action myMoveDownAction;
    private Action myUndoAction;
    private Action myRedoAction;
    private Action myGenerateCasesAction;
    private Action myExpandAllAction;
    private Action myCollapseAllAction;
    private Action myPrintClassNameAction;
    private Action myPrintTariffAction;

    public SelectionTreePopupMenu(SelectionTree tree, SelectionTreeActionHandler actionHandler, SettingsMap settings) {
        this.myActionContext = new SelectionTreeActionContext(tree, actionHandler);
        this.mySettingsMap = settings;
        this.myActionHandler = actionHandler;
        this.createMenuActions(tree.getTreeComponent());
        this.build();
    }

    private void createMenuActions(JTree treeComponent) {
        PropertyVisibilityController propVC = new PropertyVisibilityController();
        MouseStateVisibilityController ctrlShiftVC = new MouseStateVisibilityController(192, 0);
        ActionMap am = treeComponent.getActionMap();
        ActionBuilder<SelectionTreeActionBuilder> builder = ActionBuilder.newActionBuilder(SelectionTreeActionBuilder.class);
        this.myImportAction = builder.buildAction(this.invokableAction(this.myActionHandler, Import.Import)).withName(LBL_OPEN).withDescription("Open a new Selection Tree from file").withAccelerator("ctrl I").visibleBy(propVC).get();
        this.myExportAction = builder.buildAction(this.invokableAction(this.myActionHandler, Import.Export)).withName(LBL_EXPORT).withDescription("Export the current structure to a new file").withAccelerator("ctrl E").get();
        this.mySaveAction = builder.buildAction(this.invokableAction(this.myActionHandler, Save.Standard)).withName(this.getSaveLabel()).withDescription("Save the current Selection Tree").withAccelerator("ctrl S").visibleBy(propVC).get();
        this.mySaveAsAction = builder.buildAction(this.invokableAction(this.myActionHandler, Save.SaveAs)).withName(LBL_SAVE_AS).withDescription("Save the current Selection Tree with a new name").get();
        this.myDistributeAction = builder.buildAction(this.invokableAction(this.myActionHandler, Save.Distribute)).withName(LBL_DISTRIBUTE).withDescription("Distributes the current file to multiple EREs").withAccelerator("ctrl shift S").visibleBy(propVC).get();
        this.myFindAction = builder.buildAction(this.invokableAction(this.myActionHandler, Search.Find)).withName(LBL_FIND).withDescription("Show the Find window").withAccelerator("ctrl F").get();
        this.myShowFindParameterAction = builder.buildAction(this.invokableAction(this.myActionHandler, Search.ShowFindParameter)).withName(LBL_SHOW_FIND_PARAMETERS).withDescription("Show the Show Find Parameters window").withAccelerator("ctrl P").visibleBy(propVC).get();
        this.myBranchSearchAction = builder.buildAction(this.invokableAction(this.myActionHandler, Search.BranchSearch)).withName(LBL_BRANCH_SEARCH).withDescription("Show the Branch Search window").withAccelerator("ctrl B").visibleBy(propVC).get();
        this.myShowRefAction = builder.buildAction(this.dispatcher(new ShowReferencesAction())).disabledOnMultiSelect().withName(LBL_SHOW_REF).withDescription("Show links that point to the currently selected item").withAccelerator("ctrl R").get();
        this.myGotoLinkTargetAction = builder.buildAction(this.dispatcher(new GotoLinkTargetAction())).disabledOnMultiSelect().withName(LBL_GOTO_LINK_TARGET).withDescription("Goto the link target for the currently selected item").withAccelerator("ctrl T").get();
        this.myUndoAction = builder.buildAction(this.invokableAction(this.myActionHandler, Undo.Undo)).withName(LBL_UNDO).withDescription("Undo the latest action").withAccelerator("ctrl Z").get();
        this.myRedoAction = builder.buildAction(this.invokableAction(this.myActionHandler, Undo.Redo)).withName(LBL_REDO).withDescription("Redo the latest undone action").withAccelerator("ctrl Y").get();
        this.myGenerateCasesAction = builder.buildAction(this.dispatcher(new TestGenerationAction())).disabledOnMultiSelect().withName(LBL_GENERATE).withDescription("Generate Simulation cases for this modifier").withAccelerator("ctrl G").visibleBy(propVC).get();
        builder.bindInputForall(am, treeComponent.getInputMap(2));
        this.myAddNodeAction = builder.buildAction(this.invokableAction(this.myActionContext.tree(), AddElement.AddNodeAsSibling)).disabledOnMultiSelect().withName("Node").withDescription("Adds a node after the currently selected item").withAccelerator("ctrl N").get();
        this.myAddChildNodeAction = builder.buildAction(this.invokableAction(this.myActionContext.tree(), AddElement.AddNodeAsChild)).disabledOnMultiSelect().withName("Node").withDescription("Adds a node into the currently selected item").withAccelerator("ctrl shift N").get();
        this.myAddConditionAction = builder.buildAction(this.invokableAction(this.myActionContext.tree(), AddElement.AddConditionAsSibling)).disabledOnMultiSelect().withName("Condition").withDescription("Adds a condition after the currently selected item").withAccelerator("ctrl A").get();
        this.myAddChildConditionAction = builder.buildAction(this.invokableAction(this.myActionContext.tree(), AddElement.AddConditionAsChild)).disabledOnMultiSelect().withName("Condition").withDescription("Adds a condition into the currently selected item").withAccelerator("ctrl shift A").get();
        this.myAddModifierAction = builder.buildAction(this.invokableAction(this.myActionContext.tree(), AddElement.AddModifierAsSibling)).disabledOnMultiSelect().withName("Modifier").withDescription("Adds a modifier after the currently selected item").withAccelerator("ctrl M").get();
        this.myAddChildModifierAction = builder.buildAction(this.invokableAction(this.myActionContext.tree(), AddElement.AddModifierAsChild)).disabledOnMultiSelect().withName("Modifier").withDescription("Adds a modifier into the currently selected item").withAccelerator("ctrl shift M").get();
        this.myCopyAction = builder.buildAction(this.invokableAction(this.myActionHandler, Copy.Standard)).disabledOnInvalidNode().withName(LBL_COPY).withDescription("Copies the currently selected item").withAccelerator("ctrl C").get();
        this.myCopyLinkAction = builder.buildAction(this.invokableAction(this.myActionHandler, Copy.Link)).disabledOnInvalidNode().withName(LBL_COPY_LINK).withDescription("Copies the currently selected item as a link").withAccelerator("ctrl shift C").get();
        this.myPasteDefaultAction = builder.buildAction(this.invokableAction(this.myActionHandler, Paste.Default)).disabledOnMultiSelect().withName(LBL_PASTE).withDescription("Paste the current clipboard contents to the currently selected item").withAccelerator("ctrl V").get();
        builder.buildAction(this.invokableAction(this.myActionHandler, Paste.Special)).disabledOnMultiSelect().withName(LBL_PASTE_SPECIAL).withDescription("Paste the current clipboard contents to the currently selected item").withAccelerator("ctrl shift V");
        this.myPasteAsChildAction = builder.buildAction(this.invokableAction(this.myActionHandler, Paste.Child)).disabledOnMultiSelect().withName(LBL_PASTE_AS_CHILD).withDescription("Paste the current clipboard contents as child to the currently selected item").visibleBy(propVC).get();
        this.myPasteAsSiblingAction = builder.buildAction(this.invokableAction(this.myActionHandler, Paste.Sibling)).disabledOnMultiSelect().withName(LBL_PASTE_AS_SIBLING).withDescription("Paste the current clipboard contents as sibling to the currently selected item").visibleBy(propVC).get();
        this.myDeleteAction = builder.buildAction(this.dispatcher(new DeleteAction())).enabledOnMultiSelect().withName(LBL_DELETE).withDescription("Delete the currently selected item").withAccelerator("DELETE").get();
        this.myMoveUpAction = builder.buildAction(this.invokableAction(this.myActionHandler, Move.Up)).disabledOnMultiSelect().withName(LBL_MOVE_UP).withRmaIcon("Up16.gif").withDescription("Move the current selection one step up").withAccelerator("ctrl UP").get();
        this.myMoveDownAction = builder.buildAction(this.invokableAction(this.myActionHandler, Move.Down)).disabledOnMultiSelect().withName(LBL_MOVE_DOWN).withRmaIcon("Down16.gif").withDescription("Move the current selection one step down").withAccelerator("ctrl DOWN").get();
        this.myExpandAllAction = builder.buildAction(this.invokableAction(this.myActionHandler, TreeState.ExpandAll)).disabledOnMultiSelect().withName(LBL_EXPAND_ALL).withDescription("Expand all nodes below this node").withAccelerator("ctrl ADD").get();
        this.myCollapseAllAction = builder.buildAction(this.invokableAction(this.myActionHandler, TreeState.CollapseAll)).disabledOnMultiSelect().withName(LBL_COLLAPSE_ALL).withDescription("Collapse all nodes below this node").withAccelerator("ctrl SUBTRACT").get();
        this.myPrintClassNameAction = builder.buildAction(this.invokableAction(this.myActionHandler, InternalPrint.ClassName)).withName(LBL_PRINT_CLASS).withDescription("Prints the name of the class of the selected item").visibleBy(ctrlShiftVC).get();
        this.myPrintTariffAction = builder.buildAction(this.invokableAction(this.myActionHandler, InternalPrint.Structure)).withName(LBL_PRINT_STRUCTURE).withDescription("Prints the tree structure rooted at the selected item").visibleBy(ctrlShiftVC).get();
        InputMap[] ims = new InputMap[]{treeComponent.getInputMap(1), treeComponent.getInputMap()};
        builder.bindInputForall(am, ims);
        this.mySaveAction.putValue(VISIBILITY_PROPERTY_KEY, "allow-save");
        this.myDistributeAction.putValue(VISIBILITY_PROPERTY_KEY, new String[]{"allow-save", "editing-proxy"});
        this.myGenerateCasesAction.putValue(VISIBILITY_PROPERTY_KEY, "show-testgen");
        this.myPasteAsChildAction.putValue(VISIBILITY_PROPERTY_KEY, "allow-paste-special");
        this.myPasteAsSiblingAction.putValue(VISIBILITY_PROPERTY_KEY, "allow-paste-special");
        this.myBranchSearchAction.putValue(VISIBILITY_PROPERTY_KEY, "branch-search");
        this.myShowFindParameterAction.putValue(VISIBILITY_PROPERTY_KEY, "show-find-parameters");
        this.myImportAction.putValue(VISIBILITY_PROPERTY_KEY, "allow-import");
    }

    private String getSaveLabel() {
        boolean hasProxy = Boolean.parseBoolean(this.mySettingsMap.getParameter("editing-proxy").getValue());
        return hasProxy ? LBL_SAVE_SINGLE : LBL_SAVE_FILE;
    }

    private <TARGET, CMD extends Enum<CMD>> Action invokableAction(TARGET tgt, CMD command) {
        return this.dispatcher(new InvokableAction<TARGET, Invokable>(tgt, (Invokable)((Object)command)));
    }

    private Action dispatcher(AbstractAction a) {
        return new ActionDispatcher(a);
    }

    private boolean isTurnedOn(String property) {
        String value = this.mySettingsMap.getParameterAsString(property);
        return value == null || Boolean.parseBoolean(value);
    }

    private void build() {
        String namePrefix = "RatingRuleTree.menu.";
        JMenu addSibling = new JMenu(LBL_ADD_NODE_AS_SIBLING);
        addSibling.add(this.myAddNodeAction).setName(namePrefix + "add-node-as-sibling");
        addSibling.add(this.myAddConditionAction).setName(namePrefix + "add-condition-as-sibling");
        addSibling.add(this.myAddModifierAction).setName(namePrefix + "add-modifier-as-sibling");
        this.add(addSibling).setName(namePrefix + "add-as-sibling");
        JMenu addChild = new JMenu(LBL_ADD_NODE_AS_CHILD);
        addChild.add(this.myAddChildNodeAction).setName(namePrefix + "add-node-as-child");
        addChild.add(this.myAddChildConditionAction).setName(namePrefix + "add-condition-as-child");
        addChild.add(this.myAddChildModifierAction).setName(namePrefix + "add-modifier-as-child");
        this.add(addChild).setName(namePrefix + "add-as-child");
        this.addSeparator();
        this.add(this.myCopyAction).setName(namePrefix + "copy");
        this.add(this.myCopyLinkAction).setName(namePrefix + "copy-link");
        this.add(this.myPasteDefaultAction).setName(namePrefix + "paste-default");
        JMenu extendedPaste = new JMenu(LBL_PASTE_SPECIAL);
        extendedPaste.add(this.myPasteAsChildAction).setName(namePrefix + "paste-as-child");
        extendedPaste.add(this.myPasteAsSiblingAction).setName(namePrefix + "paste-as-sibling");
        this.add(extendedPaste).setName(namePrefix + "paste-choice");
        this.add(this.myDeleteAction).setName(namePrefix + "delete");
        this.addSeparator();
        JMenu saveMenu = new JMenu(LBL_SAVE);
        saveMenu.add(this.mySaveAction).setName(namePrefix + "save-standard");
        saveMenu.add(this.myDistributeAction).setName(namePrefix + "save-distribute");
        this.add(saveMenu).setName(namePrefix + "save");
        this.add(this.mySaveAsAction).setName(namePrefix + "save-as");
        this.addSeparator();
        this.add(this.myImportAction).setName(namePrefix + "import");
        this.add(this.myExportAction).setName(namePrefix + "export");
        this.addSeparator();
        this.add(this.myShowRefAction).setName(namePrefix + "show-references");
        this.add(this.myFindAction).setName(namePrefix + "find");
        this.add(this.myGotoLinkTargetAction).setName(namePrefix + "goto-link-target");
        this.add(this.myShowFindParameterAction).setName(namePrefix + "show-find-parameters");
        this.add(this.myBranchSearchAction).setName(namePrefix + "find-branch");
        this.add(this.myPrintClassNameAction).setName(namePrefix + "print-classname");
        this.add(this.myPrintTariffAction).setName(namePrefix + "print-structure");
        this.addSeparator();
        this.add(this.myGenerateCasesAction).setName(namePrefix + "generate-test-cases");
        this.add(this.myMoveUpAction).setName(namePrefix + "move-up");
        this.add(this.myMoveDownAction).setName(namePrefix + "move-down");
        this.add(this.myExpandAllAction).setName(namePrefix + "expand-all");
        this.add(this.myCollapseAllAction).setName(namePrefix + "collapse-all");
        this.addSeparator();
        this.add(this.myUndoAction).setName(namePrefix + "undo");
        this.add(this.myRedoAction).setName(namePrefix + "redo");
    }

    @Override
    protected SelectionTreeActionContext createActionContext() {
        return this.myActionContext;
    }

    private class ActionDispatcher
    extends ConditionallyEnabledAbstractAction<ConditionallyEnabledAbstractAction.ActionContext> {
        private AbstractAction myAction;

        ActionDispatcher(AbstractAction a) {
            this.myAction = a;
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException("No cloning.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DispatchActionEvent<SelectionTreeActionContext> de = new DispatchActionEvent<SelectionTreeActionContext>(e, SelectionTreePopupMenu.this.createActionContext());
            this.myAction.actionPerformed(de);
        }

        @Override
        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            this.myAction.addPropertyChangeListener(listener);
        }

        @Override
        public Object[] getKeys() {
            return this.myAction.getKeys();
        }

        @Override
        public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
            return this.myAction.getPropertyChangeListeners();
        }

        @Override
        public boolean isEnabled() {
            return this.myAction.isEnabled();
        }

        @Override
        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            this.myAction.removePropertyChangeListener(listener);
        }

        @Override
        public void setEnabled(boolean newValue) {
            this.myAction.setEnabled(newValue);
        }

        @Override
        public Object getValue(String key) {
            return this.myAction.getValue(key);
        }

        @Override
        public void putValue(String key, Object newValue) {
            this.myAction.putValue(key, newValue);
        }

        @Override
        public boolean shouldBeEnabled(ConditionallyEnabledAbstractAction.ActionContext ctx) {
            if (this.myAction instanceof ConditionallyEnabledAbstractAction) {
                ConditionallyEnabledAbstractAction ca = (ConditionallyEnabledAbstractAction)this.myAction;
                return ca.shouldBeEnabled(ctx);
            }
            return this.isEnabled();
        }

        @Override
        public boolean isApplicable(ConditionallyEnabledAbstractAction.ActionContext ctx) {
            if (this.myAction instanceof ConditionallyEnabledAbstractAction) {
                ConditionallyEnabledAbstractAction ca = (ConditionallyEnabledAbstractAction)this.myAction;
                return ca.isApplicable(ctx);
            }
            return super.isApplicable(ctx);
        }
    }

    final class MouseStateVisibilityController
    implements ActionBuilder.VisibilityController {
        private int myOnMask;
        private int myOffMask;

        MouseStateVisibilityController(int onMask, int offMask) {
            this.myOnMask = onMask;
            this.myOffMask = offMask;
        }

        @Override
        public boolean shouldBeVisible(Action a, MouseEvent me) {
            if (me == null) {
                return true;
            }
            return (me.getModifiersEx() & (this.myOnMask | this.myOffMask)) == this.myOnMask;
        }
    }

    final class PropertyVisibilityController
    implements ActionBuilder.VisibilityController {
        PropertyVisibilityController() {
        }

        @Override
        public boolean shouldBeVisible(Action a, MouseEvent me) {
            boolean visible;
            Object value = a.getValue(SelectionTreePopupMenu.VISIBILITY_PROPERTY_KEY);
            if (value instanceof String[]) {
                visible = true;
                for (String str : (String[])value) {
                    visible &= SelectionTreePopupMenu.this.isTurnedOn(str);
                }
            } else {
                String str = (String)value;
                visible = SelectionTreePopupMenu.this.isTurnedOn(str);
            }
            return visible;
        }
    }
}

