/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.popupmenus;

import com.ericsson.ere.functioncontrol.FunctionContext;
import com.ericsson.ere.functioncontrol.FunctionManager;
import com.ericsson.ere.functioncontrol.FunctionManagerImpl;
import com.ericsson.ere.functioncontrol.FunctionState;
import com.ericsson.ere.functioncontrol.FunctionToken;
import com.ericsson.ere.gui.navigator.NavigatorTree;
import com.ericsson.ere.gui.navigator.NavigatorTreeUtil;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.ActiveListNode;
import com.ericsson.ere.gui.navigator.nodes.RatingPeriodNode;
import com.ericsson.ere.gui.navigator.nodes.RatingPlanNode;
import com.ericsson.ere.gui.navigator.nodes.SavedListNode;
import com.ericsson.ere.gui.navigator.nodes.ServiceProviderListNode;
import com.ericsson.ere.gui.navigator.nodes.ServiceProviderNode;
import com.ericsson.ere.gui.navigator.popupmenus.AbstractNavigatorPopupMenu;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxyManager;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class RatingPopupMenu
extends AbstractNavigatorPopupMenu {
    static String LBL_NEW_SERVICE_PROVIDER = "Add Service Provider";
    static String LBL_NEW_RATING_PLAN = "Add Rating Plan";
    static String LBL_NEW_RATING_PERIOD = "Add Rating Period";
    static String LBL_EDIT_SELECTION_TREE = "Edit Selection Tree";
    private FunctionManager myFunctionManager = FunctionManagerImpl.getInstance();

    public RatingPopupMenu(NavigatorTree owner) {
        super(owner);
    }

    protected void menuForServiceProviderList() {
        this.removeAll();
        this.addNewRatingPeriodMenuIfAllowed();
        this.addSeparator();
        this.addImportMenuIfAllowed();
        this.addExportMenu();
    }

    protected void addNewRatingPeriodMenuIfAllowed() {
        if (this.isFunctionOnRatingPeriodAllowed((AbstractNavigatorNode)this.myOwner.getSelectedNode(), FunctionToken.NEW_RATING_PERIOD)) {
            this.addNewRatingPeriodMenu();
            this.addSeparator();
        }
    }

    protected void addImportMenuIfAllowed() {
        if (this.isFunctionOnRatingPeriodAllowed((AbstractNavigatorNode)this.myOwner.getSelectedNode(), FunctionToken.IMPORT_ALLOWED)) {
            this.addImportMenu();
        }
    }

    void addPropertiesMenuIfAllowed() {
        boolean isOpened;
        this.addSeparator();
        AbstractNavigatorNode node = (AbstractNavigatorNode)this.myOwner.getSelectedNode();
        boolean bl = isOpened = node != null && NavigatorTreeUtil.nodeIsInEditState(node.getProxy());
        if (isOpened) {
            propertiesMenu.setEnabled(false);
            myPopupMenu.add(propertiesMenu);
        } else {
            propertiesMenu.setVisible(true);
            propertiesMenu.setEnabled(true);
            myPopupMenu.add(propertiesMenu);
        }
    }

    private boolean isFunctionOnRatingPeriodAllowed(AbstractNavigatorNode node, FunctionToken token) {
        FunctionContext ctx;
        FunctionState state;
        AbstractEreProxy proxy = node.getProxy();
        if (proxy instanceof RatingPeriodProxy) {
            proxy = (AbstractEreProxy)((RatingPeriodProxy)proxy).getParentProxy();
        }
        return (state = this.myFunctionManager.getStateForFunction(token, ctx = FunctionContext.createFunctionCtxFromProxy(proxy))).getState() == FunctionState.State.ON;
    }

    protected void addDeleteRatingPeriodMenuIfAllowed() {
        AbstractNavigatorNode node = (AbstractNavigatorNode)this.myOwner.getSelectedNode();
        if (NavigatorTreeUtil.nodeIsDeletable(node)) {
            this.addDeleteMenu(true);
            this.addSeparator();
        }
    }

    protected void addEditRatingPeriodMenuIfAllowed() {
        if (this.isFunctionOnRatingPeriodAllowed((AbstractNavigatorNode)this.myOwner.getSelectedNode(), FunctionToken.DELETE_RATING_PERIOD)) {
            this.addEditMenu(LBL_EDIT_SELECTION_TREE);
            this.addSeparator();
        }
    }

    protected void addMultiDataUpdateMenuIfAllowed() {
        if (this.isFunctionOnRatingPeriodAllowed((AbstractNavigatorNode)this.myOwner.getSelectedNode(), FunctionToken.MULTI_DATA_UPDATE)) {
            this.addMultiDataUpdateMenu();
        }
    }

    protected void menuForServiceProvider() {
        this.removeAll();
        this.addNewRatingPeriodMenuIfAllowed();
        this.addDeleteRatingPeriodMenuIfAllowed();
        this.addImportMenuIfAllowed();
        this.addExportMenu();
    }

    protected void menuForRatingPlan(TreeNode ratingPlanNode) {
        this.removeAll();
        this.addNewRatingPeriodMenuIfAllowed();
        this.addAddNodeFilterMenu();
        this.addDeleteRatingPeriodMenuIfAllowed();
        this.addImportMenuIfAllowed();
        this.addExportMenu();
    }

    protected void menuForRatingPeriod(TreeNode ratingPeriodNode) {
        this.removeAll();
        this.addNewRatingPeriodMenuIfAllowed();
        this.addDeleteRatingPeriodMenuIfAllowed();
        this.addEditRatingPeriodMenuIfAllowed();
        this.addImportMenuIfAllowed();
        this.addExportMenu();
        this.addDistributeMenu();
        this.addMultiDataUpdateMenuIfAllowed();
        this.addSeparator();
        this.addCompareToMenu();
        this.addPropertiesMenuIfAllowed();
    }

    protected void menuForSavedListNode(TreeNode saveListNode) {
        this.removeAll();
        this.addNewRatingPeriodMenuIfAllowed();
        this.addAddNodeFilterMenu();
        this.addSeparator();
        this.addImportMenuIfAllowed();
        this.addExportMenu();
    }

    protected void menuForActiveListNode(TreeNode activeListNode) {
        this.removeAll();
        this.addAddNodeFilterMenu();
        this.addSeparator();
        this.addExportMenu();
    }

    @Override
    public void enablePopupMenu() {
        DefaultMutableTreeNode tmpTreeNode = this.myOwner.getSelectedNode();
        if (tmpTreeNode == null) {
            this.removeAll();
            return;
        }
        if (tmpTreeNode instanceof ServiceProviderListNode) {
            this.menuForServiceProviderList();
        } else if (tmpTreeNode instanceof ServiceProviderNode) {
            this.menuForServiceProvider();
        } else if (tmpTreeNode instanceof RatingPlanNode) {
            this.menuForRatingPlan(tmpTreeNode);
        } else if (tmpTreeNode instanceof RatingPeriodNode) {
            this.menuForRatingPeriod(tmpTreeNode.getParent());
        }
    }

    @Override
    public void enableActions() {
        this.myOwner.disableAllActions();
        DefaultMutableTreeNode tmpTreeNode = this.myOwner.getSelectedNode();
        if (tmpTreeNode == null) {
            return;
        }
        if (tmpTreeNode instanceof ServiceProviderListNode) {
            NavigatorTree.newRatingPeriodAction.setEnabled(true);
            NavigatorTree.exportAction.setEnabled(true);
            NavigatorTree.importAction.setEnabled(true);
        } else if (tmpTreeNode instanceof ServiceProviderNode) {
            NavigatorTree.newRatingPeriodAction.setEnabled(true);
            NavigatorTree.deleteAction.setEnabled(true);
            NavigatorTree.exportAction.setEnabled(true);
            NavigatorTree.importAction.setEnabled(true);
        } else if (tmpTreeNode instanceof RatingPlanNode) {
            NavigatorTree.newRatingPeriodAction.setEnabled(true);
            NavigatorTree.deleteAction.setEnabled(true);
            NavigatorTree.exportAction.setEnabled(true);
            NavigatorTree.importAction.setEnabled(true);
        } else if (tmpTreeNode instanceof RatingPeriodNode) {
            NavigatorTree.newRatingPeriodAction.setEnabled(true);
            NavigatorTree.editAction.setEnabled(true);
            NavigatorTree.exportAction.setEnabled(true);
            NavigatorTree.importAction.setEnabled(true);
            NavigatorTree.propertiesAction.setEnabled(true);
            NavigatorTree.compareToAction.setEnabled(true);
            NavigatorTree.deleteAction.setEnabled(true);
            NavigatorTree.distributedDeleteAction.setEnabled(true);
            NavigatorTree.distributedSaveAction.setEnabled(true);
            NavigatorTree.mduAction.setEnabled(true);
        } else if (tmpTreeNode instanceof SavedListNode) {
            NavigatorTree.newRatingPeriodAction.setEnabled(true);
            NavigatorTree.editAction.setEnabled(true);
            NavigatorTree.exportAction.setEnabled(true);
            NavigatorTree.importAction.setEnabled(true);
        } else if (tmpTreeNode instanceof ActiveListNode) {
            NavigatorTree.newRatingPeriodAction.setEnabled(false);
            NavigatorTree.editAction.setEnabled(true);
            NavigatorTree.exportAction.setEnabled(true);
            NavigatorTree.importAction.setEnabled(true);
        }
        int ereCount = 0;
        if (EreProxyManager.getInstance().getInternalEreProxy() != null) {
            ++ereCount;
        }
        if ((ereCount += EreProxyManager.getInstance().getRemoteEreList().size()) <= 1) {
            NavigatorTree.distributedDeleteAction.setEnabled(false);
            NavigatorTree.distributedSaveAction.setEnabled(false);
        }
    }
}

