/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodes;

import com.ericsson.ere.functioncontrol.FunctionContext;
import com.ericsson.ere.functioncontrol.FunctionManager;
import com.ericsson.ere.functioncontrol.FunctionManagerImpl;
import com.ericsson.ere.functioncontrol.FunctionState;
import com.ericsson.ere.functioncontrol.FunctionToken;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.ServiceProviderListProxy;
import ericsson.ere.defs.RmaDefs;
import javax.swing.ImageIcon;

public class ServiceProviderListNode
extends AbstractNavigatorNode {
    private String myTitle = "Service provider list";
    public static final String PROP_SERVICEPROVIDERLIST_NAME = "ServiceProviderList.name";
    public static final String PROP_SERVICEPROVIDERLIST_MENU = "ServiceProviderList.menu";
    public static final String NODE_TYPE = "ServiceProviderListNode";
    private static final String TOOL_TIP = "Holds the Service Providers on the ERE node";
    private ServiceProviderListProxy myServiceProviderListProxy = null;

    public ServiceProviderListNode(ServiceProviderListProxy anySPLP) {
        this.myServiceProviderListProxy = anySPLP;
        if (this.myServiceProviderListProxy != null) {
            this.setTitle(this.myServiceProviderListProxy.getProperty(PROP_SERVICEPROVIDERLIST_NAME));
            this.setAllowMenu(this.allowMenuForServiceProviderList());
        } else {
            this.setTitle("UNDEFINED");
            this.setAllowMenu(false);
        }
    }

    private boolean allowMenuForServiceProviderList() {
        FunctionContext ctx = FunctionContext.build().withProxy(this.myServiceProviderListProxy).get();
        FunctionManager mgr = FunctionManagerImpl.getInstance();
        FunctionState state = mgr.getStateForFunction(FunctionToken.ALLOW_SERVICEPROVIDERLIST_MENU, ctx);
        return state.getState() == FunctionState.State.ON;
    }

    @Override
    public String toString() {
        return this.myTitle;
    }

    @Override
    public String getTitle() {
        return this.toString();
    }

    public void setTitle(String title) {
        if (title != null && title.trim().length() > 0) {
            this.myTitle = title;
        }
    }

    @Override
    public ImageIcon getNodeIcon(boolean expanded) {
        if (expanded) {
            return RmaDefs.getImageIcon("navigator_open_folder.png");
        }
        return RmaDefs.getImageIcon("navigator_closed_folder.png");
    }

    @Override
    public String getNodeToolTip() {
        if (this.myServiceProviderListProxy == null) {
            return "UNDEFINED";
        }
        if (this.myServiceProviderListProxy.getProperty(PROP_SERVICEPROVIDERLIST_NAME) != null) {
            return "Holds the " + this.myServiceProviderListProxy.getProperty(PROP_SERVICEPROVIDERLIST_NAME) + " on the ERE node \n" + this.myServiceProviderListProxy.getId();
        }
        return "Holds the Service Providers on the ERE node\n" + this.myServiceProviderListProxy.getId();
    }

    @Override
    public AbstractEreProxy getProxy() {
        return this.myServiceProviderListProxy;
    }
}

