/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodes;

import com.ericsson.ere.gui.editors.interfaces.NavigatorNodePropertiesInterface;
import com.ericsson.ere.gui.editors.interfaces.ProxySettingsEditorInterface;
import com.ericsson.ere.gui.editors.propertyeditor.DefaultNavigatorNodeEditor;
import com.ericsson.ere.gui.navigator.NavigatorTree;
import com.ericsson.ere.gui.navigator.model.filter.NavigatorFilter;
import com.ericsson.ere.gui.navigator.nodes.NavigatorNodeInterface;
import com.ericsson.ere.gui.navigator.nodes.RatingPeriodNode;
import com.ericsson.ere.gui.navigator.nodes.RatingPlanNode;
import com.ericsson.ere.proxy.AbstractEreProxy;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.propertieseditor.EditablePropertiesInterface;
import ericsson.ere.gui.propertieseditor.PropertiesException;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.Variable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class AbstractNavigatorNode
extends DefaultMutableTreeNode
implements EditablePropertiesInterface,
NavigatorNodeInterface {
    protected static final String IMPORT_TITLE = "ERE Navigator import";
    protected static final String EXPORT_TITLE = "ERE Navigator export";
    protected static final String TAG_EXPORT = "EreExport";
    protected static final String ATTR_TYPE = "Type";
    public String NODE_TYPE = "UNDEFINED";
    public boolean isNew = false;
    private Class<?> myNodeEditorClassToUse = null;
    private Class<?> myNavigatorNodeDataClassToUse = null;
    public NavigatorTree myOwner = null;
    public boolean myAllowMenu = true;
    public static final String PROP_NAVIGATORNODEEDITOR = "NavigatorNodeEditor";
    public static final String PROP_NAVIGATORNODEPROPERTIES = "NavigatorNodeProperties";
    private List<AbstractNavigatorNode> myHiddenNodes = new ArrayList<AbstractNavigatorNode>();

    public boolean hasFilteredChildren() {
        return !this.myHiddenNodes.isEmpty();
    }

    public void showFilteredChildren() {
        while (!this.myHiddenNodes.isEmpty()) {
            this.add(this.myHiddenNodes.remove(0));
        }
    }

    public void filterChildren(NavigatorFilter filter) {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            AbstractNavigatorNode child = (AbstractNavigatorNode)e.nextElement();
            if (filter.matches(child)) continue;
            this.myHiddenNodes.add(child);
        }
        for (AbstractNavigatorNode n : this.myHiddenNodes) {
            this.remove(n);
        }
    }

    protected void setHelpKey(NavigatorNodePropertiesInterface properties) {
        List<Variable> variableList = properties.getVariableList();
        for (int ii = 0; ii < variableList.size(); ++ii) {
            variableList.get(ii).setHelpId(this.getClass().toString());
        }
    }

    protected static String createAttribute(String name, String value) {
        return " " + name + "=\"" + value + "\"";
    }

    @Override
    public void cancel() {
    }

    @Override
    public void deleteNode() {
    }

    @Override
    public void exportNode() {
    }

    @Override
    public Color getNodeColor() {
        return null;
    }

    @Override
    public String getNodeToolTip() {
        return null;
    }

    @Override
    public EditablePropertiesInterface getPropertyOwner() {
        return this;
    }

    @Override
    public void importNode() {
    }

    @Override
    public void newNode(String type) {
    }

    @Override
    public void setNavigatorNodeEditorClass(Class<?> navigatorNodeEditorClass) {
        this.myNodeEditorClassToUse = navigatorNodeEditorClass;
    }

    @Override
    public ProxySettingsEditorInterface getNavigatorNodeEditor() {
        ProxySettingsEditorInterface navEditorToUse = new DefaultNavigatorNodeEditor();
        try {
            Object preEditor = this.myNodeEditorClassToUse.newInstance();
            if (preEditor instanceof ProxySettingsEditorInterface) {
                navEditorToUse = (ProxySettingsEditorInterface)preEditor;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return navEditorToUse;
    }

    public void setNavigatorNodeDataClass(Class<?> navigatorNodeDataClass) {
        this.myNavigatorNodeDataClassToUse = navigatorNodeDataClass;
    }

    public Class<?> getNavigatorNodeDataClass() {
        return this.myNavigatorNodeDataClassToUse;
    }

    @Deprecated
    public SettingsMap createDefaultNodeProperties(AbstractEreProxy abstractEreProxy) {
        System.err.println("AbstractNavigatorNode.createDefaultNodeProperties has to be reimplemented!");
        return null;
    }

    @Override
    public void performNodeAction() {
    }

    @Override
    public void saveNode() {
    }

    @Override
    public void update(VarTableModel newProperties) throws PropertiesException {
        System.err.println("AbstractNavigatorNode.update() has to be fixed!");
    }

    @Override
    public void setNavigatorTree(NavigatorTree owner) {
        this.myOwner = owner;
    }

    @Override
    public void add(MutableTreeNode newChild) {
        super.add(newChild);
        ((AbstractNavigatorNode)newChild).myOwner = this.myOwner;
        Collections.sort(this.children, new NodeComparator());
    }

    public void setAllowMenu(boolean allowMenu) {
        this.myAllowMenu = allowMenu;
    }

    @Override
    public boolean isMenuOn() {
        return this.myAllowMenu;
    }

    @Deprecated
    public void superAdd(MutableTreeNode newChild) {
        super.add(newChild);
        ((AbstractNavigatorNode)newChild).myOwner = this.myOwner;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    private static class NodeComparator
    implements Comparator<Object> {
        private NodeComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof RatingPlanNode && o2 instanceof RatingPlanNode) {
                return this.ratingPlanCompareTo((RatingPlanNode)o1, (RatingPlanNode)o2);
            }
            if (o1 instanceof RatingPeriodNode && o2 instanceof RatingPeriodNode) {
                return this.ratingPeriodCompareTo((RatingPeriodNode)o1, (RatingPeriodNode)o2);
            }
            return o1.toString().compareTo(o2.toString());
        }

        private int ratingPeriodCompareTo(RatingPeriodNode rpNode1, RatingPeriodNode rpNode2) {
            if (RmaDefs.getInstance().getPeriodSortingSetting() == 1) {
                String rpDate1 = rpNode1.getRatingPeriodStartTime();
                String rpDate2 = rpNode2.getRatingPeriodStartTime();
                return rpDate1.compareTo(rpDate2);
            }
            String rpName1 = rpNode1.getRatingPeriodName();
            String rpName2 = rpNode2.getRatingPeriodName();
            return rpName1.compareTo(rpName2);
        }

        private int ratingPlanCompareTo(RatingPlanNode rpNode1, RatingPlanNode rpNode2) {
            String rpName1 = rpNode1.getRatingPlanName();
            String rpName2 = rpNode2.getRatingPlanName();
            try {
                Integer rpValue1 = Integer.parseInt(rpName1);
                Integer rpValue2 = Integer.parseInt(rpName2);
                return rpValue1.compareTo(rpValue2);
            }
            catch (NumberFormatException e) {
                return rpName1.compareTo(rpName2);
            }
        }
    }
}

