/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodeimport.states;

import com.ericsson.ere.gui.navigator.nodeimport.ImportUtil;
import com.ericsson.ere.gui.navigator.nodeimport.ImportWizardModel;
import com.ericsson.ere.gui.navigator.nodeimport.panels.MigrateFilePanel;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.gui.wizard.AbstractWizardState;
import com.ericsson.ere.gui.wizard.panels.WizardStateView;
import com.ericsson.ere.io.IOCloser;
import com.ericsson.ere.migration.MigrationContext;
import com.ericsson.ere.migration.MigrationException;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.xml.XMLUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ImportWizardMigrateState
extends AbstractWizardState {
    private MigrateFilePanel myPanel;
    private boolean hasSkipped = false;
    private static final String INVALID_FILE_TEXT = "Import file is invalid";

    public ImportWizardMigrateState(ImportWizardModel model) {
        super(model);
        this.createPanel();
    }

    private void createPanel() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ImportWizardMigrateState.this.myPanel = new MigrateFilePanel((ImportWizardModel)ImportWizardMigrateState.this.myModel);
            }
        });
    }

    @Override
    public void activate() {
        if (this.isPossibleToSkipThisState()) {
            this.setNextSelectedStateWhenSkippingState();
            return;
        }
        this.setUpState();
    }

    private void setUpState() {
        this.setBackEnabled(true);
        try {
            if (!this.hasRequiredInformation()) {
                this.clearAllVariablesInPanel();
                this.setVariables();
            }
            this.setStatusMessageInPanel("");
        }
        catch (IOException ex) {
            ExceptionUtil.handleException(ex, "navigator", 2, "Unexpected I/O exception.", false);
            this.setStatusMessageInPanel("Failed to initialize panel, an unexpected I/O error has occurred.");
        }
        catch (SAXException ex) {
            ExceptionUtil.handleException(ex, "navigator", 2, INVALID_FILE_TEXT, false);
            this.setStatusMessageInPanel("Failed to initialize panel, an unexpected error has occurred. The XML document seems to be invalid.");
        }
    }

    private void clearAllVariablesInPanel() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ImportWizardMigrateState.this.myPanel.clearAllVariables();
            }
        });
    }

    private void setNextSelectedStateWhenSkippingState() {
        if (this.hasSkipped) {
            this.selectPreviousState();
            this.hasSkipped = false;
        } else {
            this.hasSkipped = true;
            this.selectNextState();
        }
    }

    @Override
    public WizardStateView getPanel() {
        return this.myPanel;
    }

    @Override
    public void selectNextState() {
        if (this.myNextState != null) {
            if (!this.hasSkipped) {
                boolean success = this.executeState();
                if (success) {
                    this.myModel.setCurrentState(this.myNextState);
                }
            } else {
                this.myModel.setCurrentState(this.myNextState);
            }
        } else {
            this.executeState();
        }
    }

    @Override
    public void selectPreviousState() {
        if (this.myPreviousState != null) {
            this.myModel.setCurrentState(this.myPreviousState);
            if (!this.hasSkipped) {
                ((ImportWizardModel)this.myModel).resetMigration();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVariables() throws IOException, SAXException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(((ImportWizardModel)this.myModel).getSelectedSourceFile());
            Document doc = this.buildDocumentFromStream(in);
            boolean singleService = ImportUtil.containsSingleOrFloatingServiceElements(doc);
            boolean singleServiceDef = false;
            if (!singleService) {
                singleServiceDef = ImportUtil.containsSingleServiceDefinition(doc);
            }
            boolean singleServiceOrDef = singleService || singleServiceDef;
            this.setServiceStatus(doc, singleServiceDef);
            this.setServiceProviderStatus(doc, singleServiceOrDef);
            this.setRatingPlanStatus(doc, singleServiceOrDef);
            this.setRatingPeriodStatus(doc, singleServiceOrDef);
            this.setStartdateStatus(doc, singleServiceOrDef);
        }
        catch (Throwable throwable) {
            IOCloser.closeIgnoringException(in);
            throw throwable;
        }
        IOCloser.closeIgnoringException(in);
    }

    private Document buildDocumentFromStream(InputStream in) throws IOException, SAXException {
        Document doc = null;
        try {
            doc = XMLUtil.buildDocument(in);
        }
        catch (ParserConfigurationException ex) {
            throw new AssertionError((Object)ex);
        }
        return doc;
    }

    private void setServiceStatus(Document doc, boolean isSingleServiceDef) {
        String serviceName = this.getServiceNameFromDocument(doc);
        if (serviceName != null) {
            this.setServiceNameAndEnablingInPanel(serviceName, false);
        } else if (isSingleServiceDef) {
            this.setServiceEnabledAndAllowEditingInPanel(true, true);
        } else {
            this.setServiceNameAndEnablingInPanel("N/A", false);
        }
    }

    private String getServiceNameFromDocument(Document doc) {
        String serviceName = ImportUtil.getAttributeValueFromXml("RatingPlan", "Service", doc);
        if (serviceName == null && (serviceName = ImportUtil.getFirstExistingAttributeValue("TariffStructure", "ServiceId", doc)) == null) {
            serviceName = ImportUtil.getAttributeValueFromXml("ServiceDefinition", "Service", doc);
        }
        return serviceName;
    }

    private void setServiceProviderStatus(Document doc, boolean isSingleServiceOrDef) {
        this.setEnablingForAllInputVariablesInPanel(true);
        if (isSingleServiceOrDef) {
            this.setServiceProviderNameAndEnablingInPanel("N/A", false);
            return;
        }
        String serviceProviderName = ImportUtil.getAttributeValueFromXml("ServiceProvider", "Name", doc);
        if (serviceProviderName != null) {
            this.setServiceProviderNameAndEnablingInPanel(serviceProviderName, false);
        }
    }

    private void setRatingPlanStatus(Document doc, boolean isSingleServiceOrDef) {
        if (isSingleServiceOrDef) {
            this.setRatingPlanNameAndEnablingInPanel("N/A", false);
            return;
        }
        String ratingPlanName = ImportUtil.getAttributeValueFromXml("RatingPlan", "Name", doc);
        if (ratingPlanName != null) {
            this.setRatingPlanNameAndEnablingInPanel(ratingPlanName, false);
        }
    }

    private void setRatingPeriodStatus(Document doc, boolean isSingleServiceOrDef) {
        if (isSingleServiceOrDef) {
            this.setRatingPeriodNameAndEnablingInPanel("N/A", false);
            return;
        }
        String ratingPeriodName = ImportUtil.getAttributeValueFromXml("RatingPeriod", "Name", doc);
        if (ratingPeriodName != null) {
            this.setRatingPeriodNameAndEnablingInPanel(ratingPeriodName, false);
        }
    }

    private void setStartdateStatus(Document doc, boolean isSingleServiceOrDef) {
        if (isSingleServiceOrDef) {
            this.setStartdateAndEnablingInPanel("N/A", false);
            return;
        }
        String startDate = ImportUtil.getAttributeValueFromXml("RatingPeriod", "StartDate", doc);
        if (startDate != null) {
            this.setStartdateAndEnablingInPanel(startDate, false);
        }
    }

    private boolean isPossibleToSkipThisState() {
        return !((ImportWizardModel)this.myModel).isNeedingMigration();
    }

    public boolean executeState() {
        boolean isSuccessful = false;
        boolean hasNeededInput = this.validateInput();
        if (hasNeededInput) {
            try {
                this.doMigration();
                if (((ImportWizardModel)this.myModel).isMigratedFileValid()) {
                    Document doc = XMLUtil.buildDocumentFromFile(((ImportWizardModel)this.myModel).getMigratedFile());
                    ((ImportWizardModel)this.myModel).setRootElement(doc.getDocumentElement());
                    this.setStatusMessageInPanel("Migration successful");
                    isSuccessful = true;
                } else {
                    this.setStatusMessageInPanel("Migration failed, the file does not contain correct XML to import. See the log for more information.");
                }
            }
            catch (MigrationException migEx) {
                this.setStatusMessageInPanel("Migration failed, file may be corrupted. See the log for more information.");
                ExceptionUtil.handleException(migEx, "navigator", 1, INVALID_FILE_TEXT, true);
            }
            catch (IOException ioEx) {
                this.handleUnexpectedException(ioEx);
            }
            catch (ParserConfigurationException ex) {
                throw new AssertionError((Object)ex);
            }
            catch (SAXException ex) {
                this.handleUnexpectedException(ex);
            }
        }
        return isSuccessful;
    }

    private void setServiceProviderNameAndEnablingInPanel(final String name, final boolean isEnabled) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ImportWizardMigrateState.this.myPanel.setServiceProviderNameAndEnabling(name, isEnabled);
            }
        });
    }

    private void setServiceNameAndEnablingInPanel(final String name, final boolean isEnabled) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ImportWizardMigrateState.this.myPanel.setServiceNameAndEnabling(name, isEnabled);
            }
        });
    }

    private void setServiceEnabledAndAllowEditingInPanel(final boolean isEnabled, final boolean isAllowEdit) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ImportWizardMigrateState.this.myPanel.setServiceEnabledAndAllowEditing(isEnabled, isAllowEdit);
            }
        });
    }

    private void setRatingPlanNameAndEnablingInPanel(final String name, final boolean isEnabled) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ImportWizardMigrateState.this.myPanel.setRatingPlanNameAndEnabling(name, isEnabled);
            }
        });
    }

    private void setRatingPeriodNameAndEnablingInPanel(final String name, final boolean isEnabled) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ImportWizardMigrateState.this.myPanel.setRatingPeriodNameAndEnabling(name, isEnabled);
            }
        });
    }

    private void setEnablingForAllInputVariablesInPanel(final boolean isEnabled) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ImportWizardMigrateState.this.myPanel.setEnablingForAllInputVariables(isEnabled);
            }
        });
    }

    private void setStartdateAndEnablingInPanel(final String date, final boolean isEnabled) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ImportWizardMigrateState.this.myPanel.setStartdateAndEnabling(date, isEnabled);
            }
        });
    }

    private void setStatusMessageInPanel(final String text) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ImportWizardMigrateState.this.myPanel.setStatusMessage(text);
            }
        });
    }

    private void handleUnexpectedException(Exception ex) {
        this.setStatusMessageInPanel("Failed to migrate file, an unexpected I/O error has occurred.");
        ExceptionUtil.handleException(ex, "navigator", 2, INVALID_FILE_TEXT, true);
    }

    private boolean validateInput() {
        boolean valid = false;
        if (!this.inputStringHasValidValue(this.myPanel.getServiceProvider())) {
            this.setStatusMessageInPanel("Service provider must not be empty");
        } else if (!this.inputStringHasValidValue(this.myPanel.getService())) {
            this.setStatusMessageInPanel("Service name must not be empty");
        } else if (!this.inputStringHasValidValue(this.myPanel.getRatingPlan())) {
            this.setStatusMessageInPanel("Rating plan must not be empty");
        } else if (!this.inputStringHasValidValue(this.myPanel.getRatingPeriodName())) {
            this.setStatusMessageInPanel("Rating period must not be empty");
        } else if (!this.inputStringHasValidValue(this.myPanel.getStartdate())) {
            this.setStatusMessageInPanel("Start date must not be null");
        } else {
            valid = true;
        }
        return valid;
    }

    public boolean hasRequiredInformation() {
        boolean result = false;
        if (this.inputStringHasValidValue(this.myPanel.getServiceProvider()) && this.inputStringHasValidValue(this.myPanel.getService()) && this.inputStringHasValidValue(this.myPanel.getRatingPeriodName()) && this.inputStringHasValidValue(this.myPanel.getRatingPlan()) && this.myPanel.isStartdateValid()) {
            result = true;
        }
        return result;
    }

    private boolean inputStringHasValidValue(String value) {
        return value != null && !"".equals(value.trim());
    }

    private void doMigration() throws MigrationException, IOException, ParserConfigurationException, SAXException {
        MigrationContext.MigrationContextBuilder builder = new MigrationContext.MigrationContextBuilder();
        MigrationContext ctx = builder.serviceProviderName(this.myPanel.getServiceProvider()).serviceName(this.myPanel.getService()).ratingPlanName(this.myPanel.getRatingPlan()).ratingPeriodName(this.myPanel.getRatingPeriodName()).ratingPeriodStartTime(this.myPanel.getStartdate()).build();
        ((ImportWizardModel)this.myModel).migrateSelectedSourceFile(ctx);
    }

    public void setPanelInPremigrationState() {
        this.setStatusMessageInPanel("");
        this.setNextEnabled(false);
    }
}

