/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodeimport;

import com.ericsson.ere.gui.navigator.nodeimport.ProxyTreeNode;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceListProxy;
import com.ericsson.ere.proxy.ServiceProviderListProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import ericsson.ere.defs.RmaDefs;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ProxyTreeRenderer
extends DefaultTreeCellRenderer {
    ImageIcon navigatorRatingPlanOpen = RmaDefs.getImageIcon("navigator_open_ratingplan2.png");
    ImageIcon navigatorRatingPlanClosed = RmaDefs.getImageIcon("navigator_closed_ratingplan2.png");
    ImageIcon navigatorFolderClosed = RmaDefs.getImageIcon("navigator_folder.gif");
    ImageIcon navigatorFolderOpen = null;
    ImageIcon navigatorRatingPeriod = RmaDefs.getImageIcon("text_tree.png");
    ImageIcon navigatorRatingManager = RmaDefs.getImageIcon("navigator_rating_manager.png");
    ImageIcon navigatorService = RmaDefs.getImageIcon("navigator_service.png");
    ImageIcon navigatorServiceProviderOpen = RmaDefs.getImageIcon("navigator_open_folder.png");
    ImageIcon navigatorServiceProviderClosed = RmaDefs.getImageIcon("navigator_closed_folder.png");

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
        if (!(value instanceof ProxyTreeNode)) {
            return this;
        }
        ProxyTreeNode proxyTreeNode = (ProxyTreeNode)value;
        AbstractEreProxy abstractProxy = proxyTreeNode.wrappedProxy;
        if (abstractProxy instanceof RatingManagerProxy) {
            this.setIcon(this.navigatorRatingManager);
            this.setText(((RatingManagerProxy)abstractProxy).getRatingManagerName());
        } else if (abstractProxy instanceof ServiceListProxy) {
            this.setIcon(this.navigatorServiceProviderClosed);
            this.setText("Service list");
        } else if (abstractProxy instanceof ServiceProviderListProxy) {
            ServiceProviderListProxy splProxy = (ServiceProviderListProxy)abstractProxy;
            this.setIcon(this.navigatorServiceProviderClosed);
            if (splProxy.getProperty("ServiceProviderList.name") != null) {
                this.setText(splProxy.getProperty("ServiceProviderList.name"));
            } else {
                this.setText("Service provider list");
            }
        } else if (abstractProxy instanceof ServiceProviderProxy) {
            this.setIcon(this.navigatorServiceProviderClosed);
            this.setText(((ServiceProviderProxy)abstractProxy).toString());
        } else if (abstractProxy instanceof RatingPlanProxy) {
            this.setIcon(this.navigatorRatingPlanClosed);
            this.setText(((RatingPlanProxy)abstractProxy).toString() + " (" + ((RatingPlanProxy)abstractProxy).getServiceName() + ")");
        }
        return this;
    }
}

