/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodeimport;

import com.ericsson.ere.gui.wizard.interfaces.PreprocessorInterface;
import ericsson.ere.xml.ElementIterator;
import ericsson.ere.xml.XMLUtil;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Deprecated
public class ImportPreprocessor
implements PreprocessorInterface {
    public static final int UNDEFINED = -1;
    public static final int RATINGPLAN = 1;
    public static final int RATINGPERIOD = 2;
    public static final int SERVICEPROVIDER = 3;
    public static final int SERVICEPROVIDERLIST = 4;
    public static final int RATINGMANAGER = 5;
    public static final int SERVICELIST = 6;
    public static final int SERVICE = 7;
    private boolean myImportReady = false;
    private int myImportType = -1;
    private Document myImportDocument = null;
    private Element myStartElement = null;
    public int importableElements = 0;
    private boolean myMayBeExportedFromEditor;
    private Exception myImportException;

    public ImportPreprocessor(File fileToImport) {
        this.initFromFile(fileToImport);
    }

    private void initFromFile(File fileToImport) {
        try {
            this.myImportDocument = XMLUtil.buildDocumentFromFile(fileToImport);
            this.myStartElement = this.myImportDocument.getDocumentElement();
            if (this.myStartElement.getNodeName().equals("EreExport")) {
                this.myMayBeExportedFromEditor = false;
                boolean containsListOfServices = false;
                boolean containsService = false;
                boolean containsServiceProviderList = false;
                boolean containsServiceProvider = false;
                boolean containsRatingPlan = false;
                boolean containsRatingPeriod = false;
                containsListOfServices = XMLUtil.containsElementNamed(this.myStartElement, "ServiceList");
                containsService = XMLUtil.containsElementNamed(this.myStartElement, "Service");
                containsServiceProviderList = XMLUtil.containsElementNamed(this.myStartElement, "ServiceProviderList");
                containsServiceProvider = XMLUtil.containsElementNamed(this.myStartElement, "ServiceProvider");
                containsRatingPlan = XMLUtil.containsElementNamed(this.myStartElement, "RatingPlan");
                containsRatingPeriod = XMLUtil.containsElementNamed(this.myStartElement, "RatingPeriod");
                if (containsListOfServices || containsRatingPeriod || containsRatingPlan || containsService || containsServiceProvider || containsServiceProviderList) {
                    if (containsListOfServices) {
                        this.checkServiceList(this.myStartElement);
                    }
                    if (containsService) {
                        this.checkService(this.myStartElement);
                    }
                    if (containsServiceProviderList) {
                        this.checkServiceProviderList(this.myStartElement);
                    }
                    if (containsServiceProvider) {
                        this.checkServiceProvider(this.myStartElement);
                    }
                    if (containsRatingPlan) {
                        this.checkRatingPlan(this.myStartElement);
                    }
                    if (containsRatingPeriod) {
                        this.checkRatingPeriod(this.myStartElement);
                    }
                    if (!containsServiceProviderList && !containsServiceProvider && !containsRatingPlan && containsRatingPeriod) {
                        this.myImportType = 2;
                    } else if (!containsServiceProviderList && containsRatingPlan && containsRatingPeriod) {
                        this.myImportType = containsServiceProvider ? 3 : 1;
                    } else if (containsServiceProviderList && containsServiceProvider && containsRatingPlan) {
                        this.myImportType = containsRatingPeriod ? 4 : 5;
                    } else if (containsService) {
                        this.myImportType = containsListOfServices ? 6 : 7;
                    }
                    this.myImportReady = true;
                }
            } else {
                this.myMayBeExportedFromEditor = true;
            }
        }
        catch (Exception e) {
            this.myImportException = e;
        }
    }

    private boolean checkServiceList(Element serviceList) {
        boolean result = false;
        ElementIterator nodes = new ElementIterator(serviceList.getElementsByTagName("Service"));
        for (Element node : nodes) {
            if (!this.checkService(node)) {
                return false;
            }
            ++this.importableElements;
            result = true;
        }
        return result;
    }

    private boolean checkService(Element service) {
        boolean result = false;
        ElementIterator nodes = new ElementIterator(service.getElementsByTagName("ServiceDefinition"));
        for (Element node : nodes) {
            if (!this.checkServiceDefinition(node)) {
                return false;
            }
            ++this.importableElements;
            result = true;
        }
        return result;
    }

    private boolean checkServiceDefinition(Element serviceDefinition) {
        boolean result = false;
        if (serviceDefinition.getChildNodes().getLength() > 0) {
            ++this.importableElements;
            result = true;
        }
        return result;
    }

    private boolean checkServiceProvider(Element serviceProvider) {
        boolean result = false;
        ElementIterator nodes = new ElementIterator(serviceProvider.getElementsByTagName("RatingPlan"));
        for (Element node : nodes) {
            if (!this.checkRatingPlan(node)) {
                return false;
            }
            ++this.importableElements;
            result = true;
        }
        return result;
    }

    private boolean checkServiceProviderList(Element serviceProviderList) {
        boolean result = false;
        ElementIterator nodes = new ElementIterator(serviceProviderList.getElementsByTagName("ServiceProvider"));
        for (Element node : nodes) {
            if (!this.checkServiceProvider(node)) {
                return false;
            }
            ++this.importableElements;
            result = true;
        }
        return result;
    }

    private boolean checkRatingPlan(Element ratingPlan) {
        boolean result = false;
        ElementIterator nodes = new ElementIterator(ratingPlan.getElementsByTagName("RatingPeriod"));
        for (Element node : nodes) {
            if (!this.checkRatingPeriod(node)) {
                return false;
            }
            ++this.importableElements;
            result = true;
        }
        return result;
    }

    private boolean checkRatingPeriod(Element ratingPeriod) {
        boolean result = false;
        ElementIterator nodes = new ElementIterator(ratingPeriod.getElementsByTagName("TariffStructure"));
        for (Element node : nodes) {
            if (!this.checkTariffStructure(node)) {
                return false;
            }
            ++this.importableElements;
            result = true;
        }
        return result;
    }

    private boolean checkTariffStructure(Element tariffStructure) {
        boolean result = false;
        if (tariffStructure.getChildNodes().getLength() > 0) {
            ++this.importableElements;
            result = true;
        }
        return result;
    }

    @Override
    public String getImportType() {
        return this.myStartElement.getAttribute("Type");
    }

    @Override
    public boolean isValidFile() {
        return this.myImportReady;
    }

    public int getImportElementType() {
        return this.myImportType;
    }

    @Override
    public Element getRootElement() {
        return this.myStartElement;
    }

    public void throwImportException() throws Exception {
        if (this.myImportException != null) {
            throw this.myImportException;
        }
        if (this.myMayBeExportedFromEditor) {
            throw new Exception("The file has an unknown format. Try importing it in the service or selection tree editor.");
        }
    }
}

