/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodeexport.states;

import com.ericsson.ere.gui.navigator.nodeexport.ExportWizardModel;
import com.ericsson.ere.gui.navigator.nodeexport.panels.ExportNodesPanel;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.RatingPeriodNode;
import com.ericsson.ere.gui.navigator.nodes.ServiceNode;
import com.ericsson.ere.gui.wizard.AbstractWizardState;
import com.ericsson.ere.gui.wizard.panels.WizardStateView;
import com.ericsson.ere.swing.EDT;
import java.util.Observable;
import java.util.Observer;

public class ExportWizardNodesState
extends AbstractWizardState
implements Observer {
    private ExportNodesPanel myPanel;
    private boolean hasSkipped = false;

    public ExportWizardNodesState(ExportWizardModel model) {
        super(model);
        this.createPanel();
        this.myPanel.addObserver(this);
    }

    private void createPanel() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ExportWizardNodesState.this.myPanel = new ExportNodesPanel((ExportWizardModel)ExportWizardNodesState.this.myModel);
                ExportWizardNodesState.this.myPanel.setName("ExportWizardNodesState.ExportNodesPanel");
            }
        });
    }

    @Override
    public void activate() {
        if (this.isPossibleToSkipThisState()) {
            this.setNextSelectedStateWhenSkippingState();
            return;
        }
        this.validateState();
        this.setBackEnabled(true);
    }

    private void setNextSelectedStateWhenSkippingState() {
        if (this.hasSkipped) {
            this.hasSkipped = false;
            this.selectPreviousState();
        } else {
            this.hasSkipped = true;
            this.selectNextState();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.validateState();
    }

    private void validateState() {
        boolean hasExportableSelection = this.myPanel.hasExportableSelection();
        if (hasExportableSelection) {
            ((ExportWizardModel)this.myModel).clearSelectedNodes();
            ((ExportWizardModel)this.myModel).addAllNodesToSelectedNodes(this.myPanel.getAllNodesToExport());
            this.setNextEnabled(true);
        } else {
            this.setNextEnabled(false);
        }
    }

    private boolean isPossibleToSkipThisState() {
        boolean couldSkip = false;
        AbstractNavigatorNode sourceNode = ((ExportWizardModel)this.myModel).getSourceNavigatorTreeNode();
        if (sourceNode instanceof ServiceNode || sourceNode instanceof RatingPeriodNode) {
            this.validateState();
            couldSkip = true;
        }
        return couldSkip;
    }

    @Override
    public WizardStateView getPanel() {
        return this.myPanel;
    }
}

