/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodednd.states;

import com.ericsson.ere.exportmanager.ExportFailedException;
import com.ericsson.ere.exportmanager.NavigatorNodeExportContext;
import com.ericsson.ere.exportmanager.NavigatorNodeExportManager;
import com.ericsson.ere.gui.navigator.NavigatorTreeUtil;
import com.ericsson.ere.gui.navigator.nodednd.DndWizardModel;
import com.ericsson.ere.gui.navigator.nodednd.panels.DndProgressPanel;
import com.ericsson.ere.gui.navigator.nodeimport.ImportPreprocessor;
import com.ericsson.ere.gui.navigator.nodeimport.ProxiedNavigatorTreeImporter;
import com.ericsson.ere.gui.wizard.AbstractWizardState;
import com.ericsson.ere.gui.wizard.panels.WizardStateView;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.swing.EDT;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Element;

public class DndWizardProgressState
extends AbstractWizardState {
    private DndProgressPanel myPanel;
    private SwingWorker<Boolean, Void> myDndWorker;

    public DndWizardProgressState(DndWizardModel model) {
        super(model);
        this.createPanel();
    }

    private void createPanel() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                DndWizardProgressState.this.myPanel = new DndProgressPanel();
            }
        });
    }

    @Override
    public void activate() {
        this.myModel.setStandardStartNavigationButtonMode();
        this.clearPanelsInfoText();
        this.myDndWorker = new SwingWorker<Boolean, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Boolean doInBackground() throws Exception {
                Vector<AbstractEreProxy> exportProxies = new Vector<AbstractEreProxy>();
                Vector<DefaultMutableTreeNode> selectedNodes = NavigatorTreeUtil.getAllDescendantExportableNodesAsVector(((DndWizardModel)DndWizardProgressState.this.myModel).getSourceNavigatorTreeNode());
                exportProxies.addAll(NavigatorNodeExportManager.createProxyVector(selectedNodes));
                File tmpFile = DndWizardProgressState.this.createTemporaryFile();
                try {
                    if (this.isCancelled()) {
                        Boolean bl = false;
                        return bl;
                    }
                    DndWizardProgressState.this.handleExport(exportProxies, tmpFile);
                    if (this.isCancelled()) {
                        Boolean bl = false;
                        return bl;
                    }
                    DndWizardProgressState.this.handleImport(tmpFile);
                }
                finally {
                    tmpFile.delete();
                }
                return true;
            }

            @Override
            protected void done() {
                boolean isSuccess;
                DndWizardProgressState.this.myModel.setFinishedNavigationButtonMode();
                try {
                    isSuccess = (Boolean)this.get();
                }
                catch (InterruptedException ex) {
                    isSuccess = false;
                }
                catch (ExecutionException ex) {
                    isSuccess = false;
                }
                if (!isSuccess) {
                    DndWizardProgressState.this.myPanel.handleDnDFailure("Import failed!");
                }
            }
        };
        this.myDndWorker.execute();
    }

    private void clearPanelsInfoText() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                DndWizardProgressState.this.myPanel.clearInfoText();
            }
        });
    }

    private void handleExport(Vector<AbstractEreProxy> exportProxies, File tmpFile) throws ExportFailedException {
        ((DndWizardModel)this.myModel).doExport(new NavigatorNodeExportContext(exportProxies, tmpFile, this.myPanel));
    }

    private void handleImport(File tmpFile) throws Exception {
        ImportPreprocessor preprocessor = new ImportPreprocessor(tmpFile);
        if (preprocessor.isValidFile()) {
            Element rootElement = preprocessor.getRootElement();
            int totalNumberOfElements = preprocessor.importableElements;
            ProxiedNavigatorTreeImporter importer = new ProxiedNavigatorTreeImporter(this.myPanel);
            importer.importXML(rootElement, ((DndWizardModel)this.myModel).getTargetNavigatorTreeNode(), totalNumberOfElements);
        }
    }

    private File createTemporaryFile() throws IOException {
        File tmpFile = File.createTempFile("ERE_DnDWizardProgressState", null);
        return tmpFile;
    }

    @Override
    public WizardStateView getPanel() {
        return this.myPanel;
    }

    @Override
    public void cancelStateActions() {
        if (this.myDndWorker != null) {
            this.myDndWorker.cancel(true);
        }
    }
}

