/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.interfaces;

import com.ericsson.ere.interfaces.XMLAppendable;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.integration.settingsmap.propertyio.XMLOutput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NavigatorNodeConfiguration
implements XMLAppendable {
    private final String myType;
    private final SettingsMap mySettings;

    private NavigatorNodeConfiguration(String type, SettingsMap settings) {
        this.myType = type;
        this.mySettings = settings;
    }

    @Override
    public void appendXML(Node parent) {
        Document ownerDocument = parent.getOwnerDocument();
        Element ereNodeElement = ownerDocument.createElement("EreNode");
        ereNodeElement.setAttribute("type", this.myType);
        XMLOutput.appendToElement(this.mySettings, ereNodeElement);
        parent.appendChild(ereNodeElement);
    }

    public static class Builder {
        private final String myType;
        private SettingsMap mySettings = new SettingsMap();

        public Builder(String type) {
            this.myType = type;
        }

        public Builder setParameter(String key, String value, ParameterType type) {
            this.mySettings.setParameter(key, value, type.myValue, false);
            return this;
        }

        public NavigatorNodeConfiguration build() {
            return new NavigatorNodeConfiguration(this.myType, this.mySettings);
        }
    }

    public static enum ParameterType {
        TYPE_INTEGER(0),
        TYPE_STRING(1),
        TYPE_FILE(2),
        TYPE_BOOLEAN(3),
        TYPE_TIME(4);

        private final int myValue;

        private ParameterType(int value) {
            this.myValue = value;
        }
    }
}

