/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.distribute;

import com.ericsson.ere.gui.navigator.distribute.AbstractEREDistributeTask;
import com.ericsson.ere.gui.navigator.distribute.DistributionWizardOptions;
import com.ericsson.ere.gui.navigator.distribute.EREDistributionItem;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.gui.wizard.panels.DefaultWizardPanel;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.EreProxyManager;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.ProgressDialog;
import ericsson.ere.gui.util.SwingWorker;
import ericsson.ere.progress.ProgressIndicator;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Element;

public class EREDistributorDialog
extends DefaultWizardPanel {
    private DistributionMode myMode;
    private Class<?> myTask;
    private AbstractEreProxy mySource;
    private Element mySourceStructure;
    private EREDistributionItem myAssociatedEREItem;
    private List<EREDistributionItem> myOtherEREs;
    private List<AbstractEREDistributeTask> myTasks;
    private static List<EREDistributionItem> mySelectedEres = new ArrayList<EREDistributionItem>();
    private static boolean isAnalyzePanelRevisited;
    private DistributionWizardOptions myWizardOptions;
    private boolean performOnAssociatedERE;

    public EREDistributorDialog(AbstractEreProxy source, Element sourceStructure, Class<?> task, DistributionMode mode, DistributionWizardOptions wizardOptions) {
        this.mySource = source;
        this.mySourceStructure = sourceStructure;
        this.myTask = task;
        this.myMode = mode;
        this.myWizardOptions = wizardOptions;
        if (mode == DistributionMode.ANALYZE) {
            try {
                this.performOnAssociatedERE = (Boolean)task.getMethod("performOnAssociatedERE", null).invoke((Object)this, (Object[])null);
                isAnalyzePanelRevisited = false;
                mySelectedEres.clear();
                this.initComponents(this.mySource.getEreProxy(), this.performOnAssociatedERE);
            }
            catch (Exception e) {
                ExceptionUtil.handleException(e, "distribution", 2, "There was an error opening the RMA distribution dialog!", true);
            }
        }
    }

    private void initComponents(EreProxy associatedERE, boolean showAssociatedERE) throws Exception {
        EREDistributionItem ereItem;
        boolean even;
        int i;
        this.removeAll();
        Vector<EreProxy> ereProxies = EreProxyManager.getInstance().getRemoteEreList();
        Vector<EreProxy> ereList = new Vector<EreProxy>(ereProxies.size() + 1);
        ereList.addAll(ereProxies);
        ereList.add(0, EreProxyManager.getInstance().getInternalEreProxy());
        JPanel associatedERELabel = new JPanel(new GridBagLayout());
        associatedERELabel.add((Component)new JLabel("Associated ERE:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(2, 5, 2, 0), 0, 0));
        associatedERELabel.setBackground(new Color(210, 226, 240));
        JPanel associatedEREPanel = new JPanel(new GridBagLayout());
        associatedEREPanel.setBackground(new Color(248, 248, 248));
        if (showAssociatedERE && associatedERE != null) {
            if (this.myMode == DistributionMode.ANALYZE) {
                this.myAssociatedEREItem = new EREDistributionItem(associatedERE, this.getNewTask(associatedERE), new Color(248, 248, 248), this.myMode, this);
                this.myAssociatedEREItem.select(new ProgressDialog("Selecting associated ERE", "").getProgressIndicator());
            } else if (this.myMode == DistributionMode.PERFORM) {
                for (AbstractEREDistributeTask task : this.myTasks) {
                    this.myAssociatedEREItem = null;
                    if (task.getEREProxy() != associatedERE) continue;
                    this.myAssociatedEREItem = new EREDistributionItem(associatedERE, task, new Color(248, 248, 248), this.myMode, this);
                    break;
                }
            }
            associatedEREPanel.add((Component)associatedERELabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            if (this.myAssociatedEREItem != null) {
                associatedEREPanel.add((Component)this.myAssociatedEREItem, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 1), 0, 0));
            }
        } else {
            associatedEREPanel.setVisible(false);
        }
        final JPanel otherEresPanel = new JPanel(new GridBagLayout());
        otherEresPanel.setBackground(new Color(248, 248, 248));
        JPanel selectAllEresPanel = new JPanel(new GridBagLayout());
        selectAllEresPanel.setBackground(null);
        JLabel selectAllNameLabel = new JLabel("Select All");
        selectAllNameLabel.setIcon(RmaDefs.getImageIcon("MultiSelect16.gif"));
        selectAllNameLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                final ProgressDialog progressDialog = new ProgressDialog("ERE Distribution Dialog", "Selecting all EREs");
                new SwingWorker(){

                    @Override
                    public Object construct() {
                        ProgressIndicator[] progress = progressDialog.getProgressIndicator(100).splitProgress(EREDistributorDialog.this.myOtherEREs.size());
                        for (int i = 0; i < EREDistributorDialog.this.myOtherEREs.size(); ++i) {
                            ((EREDistributionItem)EREDistributorDialog.this.myOtherEREs.get(i)).select(progress[i]);
                        }
                        return null;
                    }

                    @Override
                    public void finished() {
                        progressDialog.dispose();
                    }
                }.start();
                progressDialog.setVisible(true);
            }
        });
        JLabel deselectAllNameLabel = new JLabel("Deselect All");
        deselectAllNameLabel.setIcon(RmaDefs.getImageIcon("MultiDeSelect16.gif"));
        deselectAllNameLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                for (Component c : otherEresPanel.getComponents()) {
                    EREDistributionItem ere;
                    if (!(c instanceof EREDistributionItem) || !(ere = (EREDistributionItem)c).isSelected()) continue;
                    ere.deselect();
                }
            }
        });
        JLabel expandAllLabel = new JLabel("Expand All");
        expandAllLabel.setIcon(RmaDefs.getImageIcon("expand16.gif"));
        expandAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                for (EREDistributionItem ere : EREDistributorDialog.this.myOtherEREs) {
                    ere.showInfo();
                }
            }
        });
        JLabel collapseAllLabel = new JLabel("Collapse All");
        collapseAllLabel.setIcon(RmaDefs.getImageIcon("collapse16.gif"));
        collapseAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                for (EREDistributionItem ere : EREDistributorDialog.this.myOtherEREs) {
                    ere.hideInfo();
                }
            }
        });
        if (this.myMode == DistributionMode.ANALYZE) {
            selectAllEresPanel.add((Component)selectAllNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            selectAllEresPanel.add((Component)deselectAllNameLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 20), 0, 0));
        }
        selectAllEresPanel.add((Component)expandAllLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        selectAllEresPanel.add((Component)collapseAllLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        JPanel otherEresLabelPanel = new JPanel(new GridBagLayout());
        otherEresLabelPanel.setBackground(new Color(210, 226, 240));
        JLabel otherEresLabel = new JLabel("Other EREs:");
        if (!showAssociatedERE) {
            otherEresLabel.setText("EREs:");
        }
        otherEresLabelPanel.add((Component)otherEresLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 0), 0, 0));
        otherEresLabelPanel.add((Component)new JLabel("  ( "), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        otherEresLabelPanel.add((Component)selectAllEresPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 0, 2, 0), 0, 0));
        otherEresLabelPanel.add((Component)new JLabel(" )"), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        otherEresPanel.add((Component)otherEresLabelPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.myOtherEREs = new ArrayList<EREDistributionItem>();
        if (this.myMode == DistributionMode.ANALYZE) {
            for (i = 0; i < ereList.size(); ++i) {
                EreProxy ere = (EreProxy)ereList.get(i);
                if (ere == associatedERE) continue;
                even = otherEresPanel.getComponentCount() % 2 == 0;
                ereItem = new EREDistributionItem(ere, this.getNewTask(ere), even ? new Color(232, 240, 247) : new Color(248, 248, 248), this.myMode, this);
                ereItem.setName("EREDistributorDialog.JPanel.ereItem");
                otherEresPanel.add((Component)ereItem, new GridBagConstraints(0, i + 1, 4, 1, 1.0, 0.0, 10, 2, new Insets(0, 2, 4, 2), 0, 0));
                this.myOtherEREs.add(ereItem);
            }
        } else if (this.myMode == DistributionMode.PERFORM) {
            while (i < this.myTasks.size()) {
                AbstractEREDistributeTask task = this.myTasks.get(i);
                if (this.myAssociatedEREItem == null || task != this.myAssociatedEREItem.getTask()) {
                    even = otherEresPanel.getComponentCount() % 2 == 0;
                    ereItem = new EREDistributionItem(task.getEREProxy(), task, even ? new Color(232, 240, 247) : new Color(248, 248, 248), this.myMode, this);
                    ereItem.setName("EREDistributorDialog.JPanel.ereItem");
                    otherEresPanel.add((Component)ereItem, new GridBagConstraints(0, i + 1, 4, 1, 1.0, 0.0, 10, 2, new Insets(0, 2, 4, 2), 0, 0));
                    this.myOtherEREs.add(ereItem);
                }
                ++i;
            }
        }
        JPanel emptyPanel = new JPanel();
        emptyPanel.setBackground(new Color(248, 248, 248));
        otherEresPanel.add((Component)emptyPanel, new GridBagConstraints(0, i + 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel erePanel = new JPanel(new GridBagLayout());
        erePanel.setBackground(new Color(248, 248, 248));
        erePanel.add((Component)associatedEREPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        erePanel.add((Component)otherEresPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane eREsScroll = new JScrollPane(erePanel);
        eREsScroll.getVerticalScrollBar().setUnitIncrement(10);
        eREsScroll.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new GridBagLayout());
        this.add((Component)eREsScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(12, 12, 12, 12), 0, 0));
    }

    private AbstractEREDistributeTask getNewTask(EreProxy proxy) {
        try {
            Class[] parameterClasses = new Class[]{EreProxy.class, AbstractEreProxy.class, Element.class};
            Object[] parameters = new Object[]{proxy, this.mySource, this.mySourceStructure};
            AbstractEREDistributeTask task = (AbstractEREDistributeTask)this.myTask.getConstructor(parameterClasses).newInstance(parameters);
            return task;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getTaskDescription() {
        String description = "You have chosen ";
        String type = "";
        String name = "";
        if (this.mySource instanceof RatingPeriodProxy) {
            type = "Rating Period";
            name = ((RatingPeriodProxy)this.mySource).getName();
        } else if (this.mySource instanceof ServiceProxy) {
            type = "Service";
            name = ((ServiceProxy)this.mySource).getName();
        }
        try {
            Method method = this.myTask.getMethod("getDescription", null);
            description = description + " to " + (String)method.invoke((Object)this, (Object[])null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        description = description + " the " + type + " '" + name + "'.";
        return description;
    }

    private void performSelectedTasks() {
        final ProgressDialog progressDialog = new ProgressDialog("ERE Distributor", "Performing the task");
        new SwingWorker(){

            @Override
            public Object construct() {
                ProgressIndicator[] progress = progressDialog.getProgressIndicator(100).splitProgress(mySelectedEres.size());
                for (int i = 0; i < mySelectedEres.size(); ++i) {
                    EREDistributionItem ere = (EREDistributionItem)mySelectedEres.get(i);
                    progress[i].progressStart();
                    progress[i].setInfo("Performing task on " + ere);
                    ere.performTask(progress[i]);
                    progress[i].progressFinished();
                }
                return null;
            }

            @Override
            public void finished() {
                progressDialog.dispose();
            }
        }.start();
        progressDialog.setVisible(true);
        this.myTasks = new ArrayList<AbstractEREDistributeTask>();
        for (EREDistributionItem i : mySelectedEres) {
            this.myTasks.add(i.getTask());
        }
    }

    @Override
    public String getPanelIdentifier() {
        return "EREDistributionDialog " + (Object)((Object)this.myMode);
    }

    @Override
    public boolean hasNeededData() {
        if (this.myMode == DistributionMode.ANALYZE) {
            return mySelectedEres.size() > 0;
        }
        return false;
    }

    @Override
    public void panelIsVisible() {
        if (this.myMode == DistributionMode.ANALYZE) {
            this.myWizardOptions.wizardState.setStandardMode();
            if (mySelectedEres.size() > 0 && isAnalyzePanelRevisited && DialogFactory.getQuestionDialog(this, "Analyzation results may have changed.", "Would you like to refresh the refresh the selected eres?")) {
                isAnalyzePanelRevisited = false;
                final ProgressDialog progressDialog = new ProgressDialog("ERE Distributor", "Analyzing the selected tasks");
                new SwingWorker(){

                    @Override
                    public Object construct() {
                        ProgressIndicator[] progress = progressDialog.getProgressIndicator(100).splitProgress(mySelectedEres.size());
                        ArrayList selectedEresClone = new ArrayList();
                        selectedEresClone.addAll(mySelectedEres);
                        for (int i = 0; i < selectedEresClone.size(); ++i) {
                            EREDistributionItem ere = (EREDistributionItem)selectedEresClone.get(i);
                            progress[i].progressStart();
                            progress[i].setInfo("Analyzing task at " + ere);
                            ere.analyzeTask(progress[i]);
                            progress[i].progressFinished();
                        }
                        return null;
                    }

                    @Override
                    public void finished() {
                        EREDistributorDialog.this.triggerObservers();
                        progressDialog.dispose();
                    }
                }.start();
                progressDialog.setVisible(true);
                this.validate();
            }
        } else if (this.myMode == DistributionMode.PERFORM) {
            isAnalyzePanelRevisited = true;
            EreProxy associatedERE = this.mySource.getEreProxy();
            try {
                this.performSelectedTasks();
                this.performOnAssociatedERE = (Boolean)this.myTask.getMethod("performOnAssociatedERE", null).invoke((Object)this, (Object[])null);
                this.initComponents(associatedERE, this.performOnAssociatedERE);
                this.validate();
            }
            catch (Exception e) {
                ExceptionUtil.handleException(e, "distribution", 2, "There was an error opening the RMA distribution dialog!", true);
            }
            this.myWizardOptions.wizardState.setFinishMode();
        }
    }

    @Override
    public String getPanelDescription() {
        String description = this.getTaskDescription();
        if (this.myMode == DistributionMode.ANALYZE) {
            return description + "\nPlease select the EREs on which the desired operation will be executed:";
        }
        return description + "\nThe results of the operation can be viewed below:";
    }

    public void addSelectedERE(EREDistributionItem ere) {
        if (!mySelectedEres.contains(ere)) {
            mySelectedEres.add(ere);
        }
        this.triggerObservers();
    }

    public void removeSelectedERE(EREDistributionItem ere) {
        mySelectedEres.remove(ere);
        this.triggerObservers();
    }

    @Override
    public void wizardCanceled() {
    }

    public static enum DistributionMode {
        ANALYZE,
        PERFORM;

    }
}

