/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.actions;

import com.ericsson.ere.gui.navigator.NavigatorTree;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.RatingPeriodNode;
import com.ericsson.ere.gui.navigator.nodes.ServiceNode;
import com.ericsson.ere.gui.wizard.WizardFactory;
import com.ericsson.ere.gui.wizard.WizardView;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.tree.DefaultMutableTreeNode;

public class ExportAction
extends AbstractAction {
    NavigatorTree myTreeOwner = null;

    public ExportAction(NavigatorTree owner) {
        super("Export...");
        this.myTreeOwner = owner;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DefaultMutableTreeNode node = this.myTreeOwner.getSelectedNode();
        if (node instanceof AbstractNavigatorNode) {
            if (ExportAction.nodeHasExportabelDecendants(node)) {
                WizardView view = WizardFactory.createNavigatorExportWizard(GuiServiceCenter.getInstance().getMainWindow(), (AbstractNavigatorNode)node);
                view.run();
            } else {
                DialogFactory.getErrorDialog("Export not possible", "The selected node in the Navigator does not contain any exportable elements.");
            }
        }
    }

    private static boolean nodeHasExportabelDecendants(DefaultMutableTreeNode node) {
        if (node instanceof ServiceNode || node instanceof RatingPeriodNode) {
            return true;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (!ExportAction.nodeHasExportabelDecendants((DefaultMutableTreeNode)node.getChildAt(i))) continue;
            return true;
        }
        return false;
    }
}

