/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.multiupdate;

import com.ericsson.ere.gui.multiupdate.Status;
import com.ericsson.ere.gui.multiupdate.view.MultiDataUpdateInfoView;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.defs.RmaDefs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class MultiDataUpdateInfoPanel
extends JPanel
implements MultiDataUpdateInfoView {
    private JLabel myTitleLabel;
    private JPanel myIconPanel;
    private JTextArea myInfoTextArea;
    private static final ImageIcon INFO_ICON = RmaDefs.getImageIcon("information_32.png");
    private static final ImageIcon WARNING_ICON = RmaDefs.getImageIcon("warning_32.png");
    private static final ImageIcon ERROR_ICON = RmaDefs.getImageIcon("error_32.png");
    private static final ImageIcon MULTI_DATA_UPDATE_ICON = RmaDefs.getImageIcon("index_down.png");

    public MultiDataUpdateInfoPanel() {
        super(new GridBagLayout());
        this.setPreferredSize(new Dimension(600, 75));
        this.init();
    }

    private void init() {
        this.setBackground(Color.WHITE);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.myTitleLabel = new JLabel();
        this.myTitleLabel.setFont(new Font("Verdana", 1, 12));
        this.myTitleLabel.setAlignmentX(0.0f);
        this.myTitleLabel.setName("MultiDataUpdateInfoPanel.JLabel.TitleLabel");
        this.myInfoTextArea = new JTextArea();
        this.myInfoTextArea.setFont(new Font("Verdana", 0, 10));
        this.myInfoTextArea.setWrapStyleWord(true);
        this.myInfoTextArea.setLineWrap(true);
        this.myInfoTextArea.setEditable(false);
        this.myInfoTextArea.setName("MultiDataUpdateInfoPanel.JTextArea.TextArea");
        this.myIconPanel = new JPanel();
        this.myIconPanel.setBackground(Color.WHITE);
        this.add((Component)this.myIconPanel, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.myTitleLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.myInfoTextArea, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
    }

    private void showError(String title, String text) {
        this.showOnEDT(ERROR_ICON, title, text);
        this.flashRed(832);
    }

    private void showText(String title, String text) {
        this.showOnEDT(MULTI_DATA_UPDATE_ICON, title, text);
    }

    private void showWarning(String title, String text) {
        this.showOnEDT(WARNING_ICON, title, text);
    }

    private void showInformation(String title, String text) {
        this.showOnEDT(INFO_ICON, title, text);
    }

    private void showOnEDT(final ImageIcon icon, final String title, final String text) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                MultiDataUpdateInfoPanel.this.setInfoIcon(icon);
                MultiDataUpdateInfoPanel.this.applyTexts(title, text);
            }
        });
    }

    private void flashRed(final int msecs) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                MultiDataUpdateInfoPanel.this.myTitleLabel.setForeground(Color.red);
                MultiDataUpdateInfoPanel.this.myInfoTextArea.setForeground(Color.red);
            }
        });
        new Thread(){

            @Override
            public void run() {
                try {
                    3.sleep(msecs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                EDT.runLater(new Runnable(){

                    @Override
                    public void run() {
                        MultiDataUpdateInfoPanel.this.myTitleLabel.setForeground(Color.black);
                        MultiDataUpdateInfoPanel.this.myInfoTextArea.setForeground(Color.black);
                    }
                });
            }
        }.start();
    }

    private void applyTexts(String title, String text) {
        this.myTitleLabel.setText(title);
        this.myInfoTextArea.setText(text);
        this.cutExtensiveTexts(text);
    }

    private void cutExtensiveTexts(String text) {
        if (text.length() > 400) {
            this.myInfoTextArea.setText(text.substring(0, 400) + "...");
        }
    }

    private void setInfoIcon(ImageIcon icon) {
        this.myIconPanel.removeAll();
        if (icon != null) {
            this.myIconPanel.add(new JLabel(icon));
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == null) {
            return;
        }
        if (arg instanceof Status) {
            Status status = (Status)arg;
            switch (status.getSeverity()) {
                case INFO: {
                    this.showInformation(status.getTitle(), status.getMessage());
                    break;
                }
                case WARNING: {
                    this.showWarning(status.getTitle(), status.getMessage());
                    break;
                }
                case ERROR: {
                    this.showError(status.getTitle(), status.getMessage());
                    break;
                }
                case TEXT: {
                    this.showText(status.getTitle(), status.getMessage());
                }
            }
        }
    }
}

