/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.settingseditor;

import com.ericsson.ere.gui.editors.settingseditor.SettingsHandler;
import com.ericsson.ere.gui.editors.settingseditor.SettingsNode;
import com.ericsson.ere.gui.editors.settingseditor.SettingsPanel;
import com.ericsson.ere.gui.editors.settingseditor.SettingsTreeRenderer;
import ericsson.ere.defs.RmaDefs;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class SettingsEditorPanel
extends JPanel
implements TreeSelectionListener {
    private JInternalFrame myParentFrame;
    private SettingsPanel mySettingsPanel;
    private SettingsHandler mySettingsHandler;
    private static String ICON_FILE = "settings_icon16.png";

    public SettingsEditorPanel(JInternalFrame parentFrame) {
        this(parentFrame, null);
    }

    public SettingsEditorPanel(JInternalFrame parentFrame, String activeViewInRmaSettings) {
        this.initSettingEditorPanel(parentFrame, activeViewInRmaSettings);
    }

    private void initSettingEditorPanel(JInternalFrame parentFrame, String activeViewInRmaSettings) {
        this.myParentFrame = parentFrame;
        this.myParentFrame.setFrameIcon(RmaDefs.getImageIcon(ICON_FILE));
        this.mySettingsHandler = new SettingsHandler();
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(1);
        splitPane.setDividerSize(8);
        splitPane.setDividerLocation(150);
        splitPane.setResizeWeight(0.5);
        splitPane.setOneTouchExpandable(false);
        splitPane.setRightComponent(this.buildSettingsPanel());
        splitPane.setLeftComponent(this.buildSettingsTree(activeViewInRmaSettings));
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.buildButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel buildSettingsTree(String activeViewInRmaSettings) {
        TreeNode theRoot = this.buildTreeRoot();
        JTree settingsTree = new JTree(new DefaultTreeModel(theRoot));
        settingsTree.setCellRenderer(new SettingsTreeRenderer());
        settingsTree.setRootVisible(true);
        settingsTree.setName("SettingWindow.JTree.RmaSettings");
        settingsTree.addTreeSelectionListener(this);
        JPanel treePanel = new JPanel(new GridBagLayout());
        treePanel.setBackground(Color.WHITE);
        treePanel.add((Component)settingsTree, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(3, 0, 0, 0), 0, 0));
        if (activeViewInRmaSettings != null) {
            this.setActiveViewInRmaSettings(settingsTree, activeViewInRmaSettings);
        }
        return treePanel;
    }

    private void setActiveViewInRmaSettings(JTree settingsTree, String activeViewInRmaSettings) {
        for (int settingIdentifier = 0; settingIdentifier < SettingsHandler.SETTINGS_IDETIFIER_ARRAY.length; ++settingIdentifier) {
            if (!SettingsHandler.SETTINGS_IDETIFIER_ARRAY[settingIdentifier].equals(activeViewInRmaSettings)) continue;
            settingsTree.setSelectionRow(settingIdentifier);
            break;
        }
    }

    private SettingsPanel buildSettingsPanel() {
        this.mySettingsPanel = new SettingsPanel(this.mySettingsHandler.getSettingsPanels());
        return this.mySettingsPanel;
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        JButton okButton = new JButton("Ok");
        okButton.setName("SettingWindow.JButton.OkButton");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsEditorPanel.this.mySettingsHandler.saveConfig();
                try {
                    SettingsEditorPanel.this.myParentFrame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SettingsEditorPanel.this.myParentFrame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
        buttonPanel.add((Component)new JLabel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        buttonPanel.add((Component)okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        buttonPanel.add((Component)cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        return buttonPanel;
    }

    private TreeNode buildTreeRoot() {
        String[] settingIdentifiers = SettingsHandler.getSettingsArray();
        SettingsNode rootNode = new SettingsNode();
        for (int i = 1; i < settingIdentifiers.length; ++i) {
            rootNode.add(new SettingsNode(i));
        }
        return rootNode;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        int settingsIdentifier = ((SettingsNode)e.getPath().getLastPathComponent()).getSettingsIdentifier();
        if (this.mySettingsPanel != null) {
            this.mySettingsPanel.setActivePanel(settingsIdentifier);
        }
    }
}

