/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes;

import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.AbstractPluginTM;
import com.ericsson.ere.util.CountedObjectRepository;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.MultiBoolVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.util.List;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class FieldStructureBaseConditionTM
extends AbstractPluginTM {
    private static final String TAG_CONDITION = "Condition";
    private static final String ATT_CONDITION_ALIAS = "alias";
    private static final String ATT_COLLECTION_TYPE_LIST = "collectionTypeList";
    private static final String ICON = "condition16.png";
    private static final String LABEL_COLLECTION_TYPE = "Collection type";
    private static final FieldHierarchyNode.ComplexType[] ALL_SUPPORTED_COLLECTION_TYPES = new FieldHierarchyNode.ComplexType[]{FieldHierarchyNode.ComplexType.ARRAY, FieldHierarchyNode.ComplexType.MAP, FieldHierarchyNode.ComplexType.SET, FieldHierarchyNode.ComplexType.NONE};
    private MultiBoolVariable<FieldHierarchyNode.ComplexType> myCollectionTypeVariable;

    public FieldStructureBaseConditionTM(CountedObjectRepository<String> conditionNameRepository) {
        super(TAG_CONDITION, conditionNameRepository);
        this.myCollectionTypeVariable = this.createCollectionTypeVariable(ALL_SUPPORTED_COLLECTION_TYPES);
        this.myVarList.add(this.myCollectionTypeVariable);
    }

    public FieldStructureBaseConditionTM(NamedNodeMap attributes, CountedObjectRepository<String> conditionNameRepository) {
        super(TAG_CONDITION, attributes, conditionNameRepository);
        String aliasString = XMLUtil.getAttributeValue(attributes, ATT_CONDITION_ALIAS, "");
        VarListUtil.getVariableForName(this.myVarList, "Alias").setValue(aliasString);
        String supportedCollectionTypesStrList = XMLUtil.getAttributeValue(attributes, ATT_COLLECTION_TYPE_LIST, "");
        String[] supportedCollectionTypesStrArray = supportedCollectionTypesStrList.split(",\\s*");
        FieldHierarchyNode.ComplexType[] supportedCollectionTypes = new FieldHierarchyNode.ComplexType[supportedCollectionTypesStrArray.length];
        int i = 0;
        for (String supportedCollectionTypesStr : supportedCollectionTypesStrArray) {
            supportedCollectionTypes[i++] = FieldHierarchyNode.ComplexType.valueOf(supportedCollectionTypesStr);
        }
        this.myCollectionTypeVariable = this.createCollectionTypeVariable(supportedCollectionTypes);
        this.myVarList.add(this.myCollectionTypeVariable);
    }

    @Override
    protected void setupVarList(CountedObjectRepository<String> nameRepository) {
        super.setupVarList(nameRepository);
        this.addAliasVariable(nameRepository);
    }

    @Override
    public String getAlias() {
        return this.getVariableString("Alias");
    }

    @Override
    public void setDataItem(Object reference, Object object) {
        if (LABEL_COLLECTION_TYPE.equals(reference)) {
            this.setVariableForCollectionType();
        }
        super.setDataItem(reference, object);
    }

    @Override
    protected ImageIcon getNodeIcon(boolean expanded) {
        return RmaDefs.getImageIcon(ICON);
    }

    @Override
    protected Element createConfigurationElement(Document doc) {
        Element e = super.createConfigurationElement(doc);
        e.setAttribute(ATT_CONDITION_ALIAS, this.getAlias());
        e.setAttribute(ATT_COLLECTION_TYPE_LIST, this.getCollectionTypeString());
        return e;
    }

    private String getCollectionTypeString() {
        List selectedTypes = this.myCollectionTypeVariable.getSelectedItems();
        Object[] collectionTypeArray = new String[selectedTypes.size()];
        int i = 0;
        for (FieldHierarchyNode.ComplexType type : selectedTypes) {
            collectionTypeArray[i++] = type.name();
        }
        return StringUtil.join(collectionTypeArray, ",");
    }

    private MultiBoolVariable<FieldHierarchyNode.ComplexType> createCollectionTypeVariable(FieldHierarchyNode.ComplexType[] selected) {
        return new MultiBoolVariable(LABEL_COLLECTION_TYPE, (Enum[])ALL_SUPPORTED_COLLECTION_TYPES, (Enum[])selected, true, true);
    }

    private void setVariableForCollectionType() {
        VarListUtil.removeVariablesByLabel((List<Variable>)this.myVarList, LABEL_COLLECTION_TYPE);
        this.myVarList.add(this.myCollectionTypeVariable);
    }
}

