/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.swing.TreeModelMonitor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.tree.DefaultTreeModel;

public abstract class CommonLinkNode<T extends AbstractTreeNode>
extends AbstractTreeNode {
    private T myTarget;
    private ChangeListener myListener = new ChangeListener();
    protected String myTargetName;

    protected CommonLinkNode(String targetName) {
        this.myTargetName = targetName;
    }

    protected CommonLinkNode(T target) {
        this.myTarget = target;
        this.myTargetName = ((AbstractTreeNode)target).getName();
        this.trackLinkedObject((AbstractTreeNode)target);
    }

    public T getTarget() {
        return this.myTarget;
    }

    @Override
    public void setTreeModel(DefaultTreeModel model) {
        super.setTreeModel(model);
        if (this.myTarget == null) {
            this.myTarget = this.resolveTarget(model, this.myTargetName);
            this.trackLinkedObject((AbstractTreeNode)this.myTarget);
        }
        new TreeModelMonitor(model, this).onRemove(new Runnable(){

            @Override
            public void run() {
                CommonLinkNode.this.untrackLinkedObject(CommonLinkNode.this.myTarget);
            }
        }).onInsert(new Runnable(){

            @Override
            public void run() {
                CommonLinkNode.this.trackLinkedObject(CommonLinkNode.this.myTarget);
            }
        });
    }

    private void targetHasChanged(String propertyName) {
        this.myTargetName = ((AbstractTreeNode)this.getTarget()).getName();
        this.onTargetChange(propertyName);
    }

    protected void switchTarget(T newTarget) {
        this.untrackLinkedObject((AbstractTreeNode)this.myTarget);
        this.myTarget = newTarget;
        this.myTargetName = ((AbstractTreeNode)newTarget).getName();
        this.trackLinkedObject((AbstractTreeNode)newTarget);
    }

    protected abstract T resolveTarget(DefaultTreeModel var1, String var2);

    protected abstract void onTargetChange(String var1);

    private void trackLinkedObject(AbstractTreeNode aLinkObject) {
        if (aLinkObject != null) {
            aLinkObject.addPropertyChangeListener(this.myListener);
            aLinkObject.addReferrer(this);
        }
    }

    private void untrackLinkedObject(AbstractTreeNode aLinkObject) {
        if (aLinkObject != null) {
            aLinkObject.removePropertyChangeListener(this.myListener);
            aLinkObject.removeReferrer(this);
        }
    }

    private class ChangeListener
    implements PropertyChangeListener {
        private ChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CommonLinkNode.this.targetHasChanged(evt.getPropertyName());
        }
    }
}

