/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.datarepository;

import com.ericsson.ere.gui.editors.serviceeditor.datarepository.DataRepositoryListView;
import com.ericsson.ere.gui.mvp.AbstractViewPanel;
import com.ericsson.ere.swing.EventSource;
import ericsson.ere.defs.RmaDefs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListModel;

public class DataRepositoryListPanel
extends AbstractViewPanel
implements DataRepositoryListView {
    private EventSource myAddEvent = new EventSource();
    private EventSource myDeleteEvent = new EventSource();
    private EventSource myListSelectionEvent = new EventSource();
    private JButton myAddButton;
    private JButton myDeleteButton;
    private ListModel myListModel;
    private JList myElementList;
    private static final Object DELETE_KEY = new Object();

    public DataRepositoryListPanel(ListModel listModel) {
        super(new GridBagLayout(), "Element edit", "service");
        this.myListModel = listModel;
        this.init();
    }

    private void init() {
        this.add(this.buildListPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.buildButtonToolBar(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private Component buildListPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JLabel label = new JLabel("Data Elements");
        panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.myElementList = new JList(this.myListModel);
        this.myElementList.setSelectionMode(0);
        this.myElementList.setLayoutOrientation(0);
        this.myElementList.setVisibleRowCount(-1);
        this.myElementList.setFont(Font.decode(null));
        this.myElementList.addListSelectionListener(this.myListSelectionEvent);
        this.myElementList.getInputMap(2).put(KeyStroke.getKeyStroke(127, 0), DELETE_KEY);
        this.myElementList.getActionMap().put(DELETE_KEY, new DeleteActionListener());
        JScrollPane scrollPane = new JScrollPane(this.myElementList);
        panel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JToolBar buildButtonToolBar() {
        this.myAddButton = this.myAddEvent.createButton("Add", RmaDefs.getImageIcon("add2.png"), "Add Data Element.");
        this.myDeleteButton = this.myDeleteEvent.createButton("Delete", RmaDefs.getImageIcon("delete2_16.png"), "Delete Data Element.");
        this.myDeleteButton.setEnabled(false);
        JToolBar buttonToolbar = new JToolBar();
        buttonToolbar.setFloatable(false);
        buttonToolbar.addSeparator(new Dimension(4, 0));
        buttonToolbar.add(this.myAddButton);
        buttonToolbar.add(this.myDeleteButton);
        return buttonToolbar;
    }

    @Override
    public EventSource addElementEvent() {
        return this.myAddEvent;
    }

    @Override
    public EventSource deleteElementEvent() {
        return this.myDeleteEvent;
    }

    @Override
    public EventSource listSelectionEvent() {
        return this.myListSelectionEvent;
    }

    @Override
    public int getSelectedIndex() {
        return this.myElementList.getSelectedIndex();
    }

    @Override
    public void setDeleteEnabled(boolean enabled) {
        this.myDeleteButton.setEnabled(enabled);
        this.myAddButton.requestFocusInWindow();
    }

    @Override
    public void setSelectedIndex(int index) {
        if (index < 0) {
            this.myElementList.clearSelection();
        } else if (index == this.myElementList.getSelectedIndex()) {
            this.myListSelectionEvent.fire(null);
            this.myElementList.ensureIndexIsVisible(index);
        } else {
            this.myElementList.setSelectedIndex(index);
            this.myElementList.ensureIndexIsVisible(index);
        }
    }

    private class DeleteActionListener
    extends AbstractAction {
        private DeleteActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataRepositoryListPanel.this.myDeleteButton.isEnabled()) {
                DataRepositoryListPanel.this.myDeleteEvent.fire(e);
            }
        }
    }
}

