/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.datarepository;

import com.ericsson.ere.defs.AbstractValueType;
import com.ericsson.ere.defs.DataRepositoryModel;
import com.ericsson.ere.defs.DataTypeBasedValueType;
import com.ericsson.ere.defs.ValueClassBasedValueType;
import com.ericsson.ere.defs.ValueType;
import com.ericsson.ere.exception.ServiceDataException;
import com.ericsson.ere.gui.editors.serviceeditor.datarepository.ArrayEditPanelVariable;
import com.ericsson.ere.gui.editors.serviceeditor.datarepository.DataRepositoryEditView;
import com.ericsson.ere.gui.editors.serviceeditor.datarepository.DataRepositoryHelper;
import com.ericsson.ere.gui.editors.serviceeditor.datarepository.DataRepositoryListView;
import com.ericsson.ere.gui.editors.serviceeditor.datarepository.DataRepositorySortedListModel;
import com.ericsson.ere.variable.DefaultVariableProducer;
import com.ericsson.ere.variable.VariableChangeEvent;
import com.ericsson.ere.variable.VariableChangeListener;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.xml.DomWriter;
import ericsson.ere.xml.Entities;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.array.ObjectArrayDataDescription;
import ericsson.vareditor.variable.array.ObjectArrayDescription;
import ericsson.vareditor.variable.array.ObjectArrayVariable;
import ericsson.vareditor.variable.array.ObjectMapModel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;

public class DataRepositoryEditPresenter {
    private static final String LABEL_SINGLE_VALUE = "Value";
    private static final String LABEL_XML_FRAGMENT = "XML fragment";
    private static final String DATA_VARIABLE_KEY = "DataVariableKey";
    private static final String LABEL_KEY_TYPE = "Key type";
    private static final String LABEL_VC = "Value class";
    private static final String LABEL_VCF = "Value class factory";
    private static final String LABEL_VALUE_TYPE = "Value type";
    private static final String LABEL_ELEMENT_TYPE = "Element type";
    private static final String LABEL_NAME = "Name";
    private static final String LABEL_KCF = "Key class factory";
    private static final String LABEL_KC = "Key class";
    private static final DataType[] dataTypes = new DataType[]{DataType.AMOUNT, DataType.BCDSTRING, DataType.BOOLEAN, DataType.DATE, DataType.DECIMAL, DataType.DOUBLE, DataType.INTEGER, DataType.LONG, DataType.MONETARYUNITS, DataType.OBJECT, DataType.OCTETSTRING, DataType.RATINGDECIMAL, DataType.SHORT, DataType.STRING, DataType.TIME, DataType.UNSIGNEDINT, DataType.UNSIGNEDINT8, DataType.UNSIGNEDINT16, DataType.UNSIGNEDINT32, DataType.UNSIGNEDLONG, DataType.UNSIGNEDSHORT};
    private DataRepositoryListView myListView;
    private DataRepositoryEditView myEditView;
    private VarTableModel myEditModel;
    private DefaultVariableProducer myVariableProducer;
    private DefaultVariableProducer myArrayEditorVariableProducer;
    private DataRepositorySortedListModel myListModel;
    private ClassRepository myClassRepository;
    private String myCurrentlyEditing = null;
    private boolean myCommitted = true;
    private EditVariableChangeListener myChangeListener;
    private AbstractWrapper myEditWrapper;

    public DataRepositoryEditPresenter(DataRepositoryEditView editView, DataRepositoryListView listView, DataRepositorySortedListModel listModel, ClassRepository classRepository) {
        if (listView == null || listModel == null || editView == null) {
            throw new IllegalArgumentException("Data list view, list model, edit view and edit model must be non-null.");
        }
        this.myClassRepository = classRepository;
        this.myListView = listView;
        this.myListModel = listModel;
        this.myEditView = editView;
        this.myEditModel = new VarTableModel();
        this.myEditView.setVarTableModel(this.myEditModel);
        this.myVariableProducer = new DataRepositoryHelper.MultilineStringVariableProducer(classRepository, true);
        this.myArrayEditorVariableProducer = new DataRepositoryHelper.MultilineStringVariableProducer(classRepository, false);
        this.myChangeListener = new EditVariableChangeListener();
        this.subscribeToViewEvents();
    }

    private void subscribeToViewEvents() {
        this.myListView.listSelectionEvent().addActionListener(new ListSelectionAction());
        this.myEditView.commitEvent().addActionListener(new CommitAction());
        this.myEditView.cancelEvent().addActionListener(new CancelAction());
    }

    private void initVarTableModelFromDataRep(String name, DataRepositoryModel.RepositoryDataType elementType) {
        this.myEditModel.getData().clear();
        StringVariable nameVar = new StringVariable(LABEL_NAME, name);
        nameVar.addVariableChangeListener(this.myChangeListener);
        this.myEditModel.addRow(nameVar);
        TypedDropDownVariable<DataRepositoryModel.RepositoryDataType> elementTypeDropDownVar = new TypedDropDownVariable<DataRepositoryModel.RepositoryDataType>(LABEL_ELEMENT_TYPE, DataRepositoryModel.RepositoryDataType.values(), elementType, new DataRepositoryHelper.RepositoryDataTypeLabeler());
        elementTypeDropDownVar.addVariableChangeListener(new ElementTypeDropDownChangeListener());
        elementTypeDropDownVar.addVariableChangeListener(this.myChangeListener);
        this.myEditModel.addRow(elementTypeDropDownVar);
        this.myEditWrapper = this.createWrapper(elementType);
        this.myEditWrapper.initFromRepository(name);
    }

    private void updateElementTypeChanged() {
        VarListUtil.retainVariablesByLabel(this.myEditModel.getData(), LABEL_NAME, LABEL_ELEMENT_TYPE);
        DataRepositoryModel.RepositoryDataType selectedElementType = this.myEditWrapper.getSelectedElementType();
        this.myEditWrapper = this.createWrapper(selectedElementType);
        this.myEditWrapper.addDefaultValues();
    }

    private void updateValueTypeChanged() {
        this.myEditWrapper.updateValueVCFVariables(null);
        this.myEditWrapper.updateDataVariable();
    }

    private void updateKeyTypeChanged() {
        this.myEditWrapper.updateKeyVCFVariables(null);
        this.myEditWrapper.updateDataVariable();
    }

    private void commitElementToRepository() throws Exception {
        this.myEditWrapper.commitToRepository();
    }

    private void setCommitted(boolean committed) {
        this.myCommitted = committed;
        this.myEditView.setCommitted(committed);
    }

    private AbstractWrapper createWrapper(DataRepositoryModel.RepositoryDataType elementType) {
        AbstractWrapper editWrapper = null;
        switch (elementType) {
            case SINGLE_VALUE: {
                editWrapper = new SingleValueWrapper();
                break;
            }
            case ARRAY: {
                editWrapper = new ArrayWrapper();
                break;
            }
            case MAP: {
                editWrapper = new MapWrapper();
                break;
            }
            case XML_FRAGMENT: {
                editWrapper = new XmlFragmentWrapper();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled type: " + (Object)((Object)elementType)));
            }
        }
        return editWrapper;
    }

    private class XmlFragmentWrapper
    extends AbstractWrapper {
        private XmlFragmentWrapper() {
        }

        @Override
        void initFromRepository(String name) {
            DataRepositoryModel dataRepModel = DataRepositoryEditPresenter.this.myListModel.getDataRepositoryModel();
            Element xmlFragment = dataRepModel.getXMLFragment(name);
            String initValue = DomWriter.nodeToString(xmlFragment, false);
            this.addDataVariable(initValue);
        }

        @Override
        void addDefaultValues() {
            this.addDataVariable("");
        }

        @Override
        void commitToRepository() throws Exception {
            String name = this.getSelectedElementName();
            String xmlString = VarListUtil.getStringValueForName(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.LABEL_XML_FRAGMENT);
            String unEscapedXmlString = Entities.XML.unescape(xmlString);
            Element xml = XMLUtil.buildDocumentFromString(unEscapedXmlString).getDocumentElement();
            DataRepositoryModel dataRepositoryModel = DataRepositoryEditPresenter.this.myListModel.getDataRepositoryModel();
            dataRepositoryModel.validateXMLFragment(name, xml);
            this.validateName(name);
            dataRepositoryModel.remove(DataRepositoryEditPresenter.this.myCurrentlyEditing);
            dataRepositoryModel.addXMLFragment(name, xml);
        }

        @Override
        void updateDataVariable() {
        }

        private void addDataVariable(String defaultValue) {
            MultilineStringVariable xmlArea = new MultilineStringVariable(DataRepositoryEditPresenter.LABEL_XML_FRAGMENT, defaultValue);
            xmlArea.setKey(DataRepositoryEditPresenter.DATA_VARIABLE_KEY);
            xmlArea.addVariableChangeListener(DataRepositoryEditPresenter.this.myChangeListener);
            DataRepositoryEditPresenter.this.myEditModel.addRow(xmlArea);
        }
    }

    private class MapWrapper
    extends AbstractWrapper {
        private MapWrapper() {
        }

        @Override
        void initFromRepository(String name) {
            DataRepositoryModel dataRepModel = DataRepositoryEditPresenter.this.myListModel.getDataRepositoryModel();
            ValueType valueType = dataRepModel.getValueType(name);
            DataType valueDataType = valueType.containsDataType() ? valueType.getDataType() : DataType.OBJECT;
            ValueType keyType = dataRepModel.getKeyType(name);
            DataType keyDataType = keyType.containsDataType() ? keyType.getDataType() : DataType.OBJECT;
            this.addKeyTypeDropDownVariable(keyDataType, keyType);
            this.addValueTypeDropDownVariable(valueDataType, valueType);
            Map<Object, Object> repValue = dataRepModel.getValueMap(name);
            Map<Object, Object> defaultValue = DataRepositoryHelper.objectToValueStringMap(repValue, keyType.containsDataType() ? null : keyType.getValueClassFactory(), valueType.containsDataType() ? null : valueType.getValueClassFactory());
            this.addDataMapVariable(keyDataType, valueDataType, defaultValue);
        }

        @Override
        void addDefaultValues() {
            this.addKeyTypeDropDownVariable(DataType.INTEGER, null);
            this.addValueTypeDropDownVariable(DataType.STRING, null);
            this.addDataMapVariable(DataType.INTEGER, DataType.STRING, null);
        }

        @Override
        void commitToRepository() {
            Object[] values;
            int i;
            Object[] keys;
            String name = this.getSelectedElementName();
            ObjectArrayVariable var = (ObjectArrayVariable)VarListUtil.getVariableForName(DataRepositoryEditPresenter.this.myEditModel.getData(), "Map values");
            ObjectMapModel varModel = (ObjectMapModel)var.getValueObject();
            ValueType keyValueType = this.getSelectedKeyValueType();
            ValueType valueType = this.getSelectedValueValueType();
            if (keyValueType.containsDataType()) {
                keys = varModel.getColumnArray(0);
            } else {
                String[] keyArray = (String[])varModel.getColumnArray(0);
                keys = new Object[keyArray.length];
                for (i = 0; i < keyArray.length; ++i) {
                    try {
                        keys[i] = keyValueType.createObjectFromString(keyArray[i]);
                        continue;
                    }
                    catch (ServiceDataException ex) {
                        String keyMessage = ex.getMessage().replace(" value string", " key string");
                        throw new ServiceDataException(keyMessage, ex);
                    }
                }
            }
            if (valueType.containsDataType()) {
                values = varModel.getColumnArray(1);
            } else {
                String[] stringArray = (String[])varModel.getColumnArray(1);
                values = new Object[stringArray.length];
                for (i = 0; i < stringArray.length; ++i) {
                    values[i] = valueType.createObjectFromString(stringArray[i]);
                }
            }
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(keys.length);
            for (i = 0; i < keys.length; ++i) {
                map.put(keys[i], values[i]);
            }
            DataRepositoryModel dataRepositoryModel = DataRepositoryEditPresenter.this.myListModel.getDataRepositoryModel();
            dataRepositoryModel.validateValueMap(name, keyValueType, valueType, map);
            this.validateName(name);
            dataRepositoryModel.remove(DataRepositoryEditPresenter.this.myCurrentlyEditing);
            dataRepositoryModel.addValueMap(name, keyValueType, valueType, map);
        }

        @Override
        void updateDataVariable() {
            VarListUtil.removeVariablesByKey(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.DATA_VARIABLE_KEY);
            this.addDataMapVariable(this.getSelectedKeyDataType(), this.getSelectedValueDataType(), null);
        }

        private void addDataMapVariable(DataType keyDataType, DataType valueDataType, Map<Object, Object> defaultValue) {
            ObjectArrayDescription objectArrayDescription = new ObjectArrayDescription();
            objectArrayDescription.add(new ObjectArrayDataDescription("key", keyDataType.getTypeName(), keyDataType.createDefaultInstance()));
            objectArrayDescription.add(new ObjectArrayDataDescription("value", valueDataType.getTypeName(), valueDataType.createDefaultInstance()){

                @Override
                protected Variable getVariable(String label, DataType dataType, Object value) {
                    Variable var = DataRepositoryEditPresenter.this.myVariableProducer.produceVariable(dataType, value);
                    var.setLabel(label);
                    return var;
                }
            });
            ArrayList<Object[]> dataArrayList = new ArrayList<Object[]>();
            if (defaultValue != null) {
                for (Map.Entry<Object, Object> mapEntry : defaultValue.entrySet()) {
                    dataArrayList.add(new Object[]{mapEntry.getKey(), mapEntry.getValue()});
                }
            }
            ObjectMapModel dataModel = new ObjectMapModel("", "", dataArrayList, objectArrayDescription);
            dataModel.setKeyColumns(new int[]{0});
            ObjectArrayVariable objectArrayVariable = new ObjectArrayVariable("Map values", dataModel);
            objectArrayVariable.setKey(DataRepositoryEditPresenter.DATA_VARIABLE_KEY);
            objectArrayVariable.addVariableChangeListener(DataRepositoryEditPresenter.this.myChangeListener);
            DataRepositoryEditPresenter.this.myEditModel.addRow(objectArrayVariable);
        }
    }

    private class ArrayWrapper
    extends AbstractWrapper {
        private ArrayWrapper() {
        }

        @Override
        void initFromRepository(String name) {
            DataRepositoryModel dataRepModel = DataRepositoryEditPresenter.this.myListModel.getDataRepositoryModel();
            ValueType valueType = dataRepModel.getValueType(name);
            DataType valueDataType = valueType.containsDataType() ? valueType.getDataType() : DataType.OBJECT;
            this.addValueTypeDropDownVariable(valueDataType, valueType);
            Object[] repValue = dataRepModel.getValueArray(name);
            Object[] defaultValue = valueDataType == DataType.OBJECT ? DataRepositoryHelper.objectToValueStringArray(repValue, valueType.getValueClassFactory()) : repValue;
            this.addDataVariable(valueDataType, defaultValue);
        }

        @Override
        void addDefaultValues() {
            this.addValueTypeDropDownVariable(DataType.STRING, null);
            this.addDataVariable(DataType.STRING, null);
        }

        @Override
        void commitToRepository() {
            Object[] values;
            String name = this.getSelectedElementName();
            ValueType valueType = this.getSelectedValueValueType();
            ArrayModel model = (ArrayModel)VarListUtil.getVariableForKey(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.DATA_VARIABLE_KEY).getValueObject();
            if (valueType.containsDataType()) {
                values = model.toArray();
            } else {
                String[] stringValues = (String[])model.toArray();
                values = new Object[stringValues.length];
                for (int i = 0; i < stringValues.length; ++i) {
                    values[i] = valueType.createObjectFromString(stringValues[i]);
                }
            }
            DataRepositoryModel dataRepositoryModel = DataRepositoryEditPresenter.this.myListModel.getDataRepositoryModel();
            dataRepositoryModel.validateValueArray(name, valueType, values);
            this.validateName(name);
            dataRepositoryModel.remove(DataRepositoryEditPresenter.this.myCurrentlyEditing);
            dataRepositoryModel.addValueArray(name, valueType, values);
        }

        @Override
        void updateDataVariable() {
            VarListUtil.removeVariablesByKey(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.DATA_VARIABLE_KEY);
            this.addDataVariable(this.getSelectedValueDataType(), null);
        }

        private void addDataVariable(DataType dataType, Object[] defaultValue) {
            Object[] dataArray = defaultValue == null ? dataType.createArray() : defaultValue;
            ArrayEditPanelVariable arrayVariable = new ArrayEditPanelVariable("Array values", dataArray, dataType, DataRepositoryEditPresenter.this.myArrayEditorVariableProducer);
            arrayVariable.setKey(DataRepositoryEditPresenter.DATA_VARIABLE_KEY);
            arrayVariable.addVariableChangeListener(DataRepositoryEditPresenter.this.myChangeListener);
            DataRepositoryEditPresenter.this.myEditModel.addRow(arrayVariable);
        }
    }

    private class SingleValueWrapper
    extends AbstractWrapper {
        private SingleValueWrapper() {
        }

        @Override
        void initFromRepository(String name) {
            DataRepositoryModel dataRepModel = DataRepositoryEditPresenter.this.myListModel.getDataRepositoryModel();
            ValueType valueType = dataRepModel.getValueType(name);
            DataType valueDataType = valueType.containsDataType() ? valueType.getDataType() : DataType.OBJECT;
            this.addValueTypeDropDownVariable(valueDataType, valueType);
            Object repValue = dataRepModel.getValue(name);
            Object defaultValue = valueDataType == DataType.OBJECT ? valueType.getValueClassFactory().makeValueString(repValue) : repValue;
            this.addDataVariable(valueDataType, defaultValue);
        }

        @Override
        void addDefaultValues() {
            this.addValueTypeDropDownVariable(DataType.STRING, null);
            this.addDataVariable(DataType.STRING, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        void commitToRepository() {
            Object value;
            String name = this.getSelectedElementName();
            ValueType valueType = this.getSelectedValueValueType();
            if (valueType.containsDataType()) {
                Variable dataVar = VarListUtil.getVariableForKey(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.DATA_VARIABLE_KEY);
                if (!dataVar.isValueValid()) throw new ServiceDataException("Parameter Value is invalid.");
                value = dataVar.getValueObject();
            } else {
                value = valueType.createObjectFromString(VarListUtil.getValueStringForKey(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.DATA_VARIABLE_KEY));
            }
            DataRepositoryModel dataRepositoryModel = DataRepositoryEditPresenter.this.myListModel.getDataRepositoryModel();
            dataRepositoryModel.validateValue(name, valueType, value);
            this.validateName(name);
            dataRepositoryModel.remove(DataRepositoryEditPresenter.this.myCurrentlyEditing);
            dataRepositoryModel.addValue(name, valueType, value);
        }

        @Override
        void updateDataVariable() {
            VarListUtil.removeVariablesByKey(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.DATA_VARIABLE_KEY);
            this.addDataVariable(this.getSelectedValueDataType(), null);
        }

        private void addDataVariable(DataType dataType, Object defaultValue) {
            Object dataValue = defaultValue == null ? dataType.createDefaultInstance() : defaultValue;
            Variable valueVariable = DataRepositoryEditPresenter.this.myVariableProducer.produceVariable(dataType, dataValue);
            valueVariable.setLabel(DataRepositoryEditPresenter.LABEL_SINGLE_VALUE);
            valueVariable.setKey(DataRepositoryEditPresenter.DATA_VARIABLE_KEY);
            valueVariable.addVariableChangeListener(DataRepositoryEditPresenter.this.myChangeListener);
            DataRepositoryEditPresenter.this.myEditModel.addRow(valueVariable);
        }
    }

    private abstract class AbstractWrapper {
        private AbstractWrapper() {
        }

        abstract void initFromRepository(String var1);

        abstract void addDefaultValues();

        abstract void updateDataVariable();

        abstract void commitToRepository() throws Exception;

        void addValueTypeDropDownVariable(DataType selectedValueDataType, ValueType defaultValue) {
            TypedDropDownVariable<DataType> valueTypeDropDownVar = new TypedDropDownVariable<DataType>(DataRepositoryEditPresenter.LABEL_VALUE_TYPE, dataTypes, selectedValueDataType, new DataRepositoryHelper.DataTypeLabeler());
            valueTypeDropDownVar.addVariableChangeListener(new ValueTypeDropDownChangeListener());
            valueTypeDropDownVar.addVariableChangeListener(DataRepositoryEditPresenter.this.myChangeListener);
            DataRepositoryEditPresenter.this.myEditModel.addRow(valueTypeDropDownVar);
            this.updateValueVCFVariables(defaultValue);
        }

        void addKeyTypeDropDownVariable(DataType selectedKeyDataType, ValueType defaultValue) {
            TypedDropDownVariable<DataType> keyTypeDropDownVar = new TypedDropDownVariable<DataType>(DataRepositoryEditPresenter.LABEL_KEY_TYPE, dataTypes, selectedKeyDataType, new DataRepositoryHelper.DataTypeLabeler());
            keyTypeDropDownVar.addVariableChangeListener(new KeyTypeDropDownChangeListener());
            keyTypeDropDownVar.addVariableChangeListener(DataRepositoryEditPresenter.this.myChangeListener);
            DataRepositoryEditPresenter.this.myEditModel.addRow(keyTypeDropDownVar);
            this.updateKeyVCFVariables(defaultValue);
        }

        private void updateValueVCFVariables(ValueType defaultValue) {
            VarListUtil.removeVariablesByLabel(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.LABEL_VCF, DataRepositoryEditPresenter.LABEL_VC);
            if (this.getSelectedValueDataType() == DataType.OBJECT) {
                String valueVCF = defaultValue == null ? "" : defaultValue.getValueClassFactory().getClass().getName();
                String valueVC = defaultValue == null ? "" : defaultValue.getValueClass().getName();
                StringVariable stringVariableVCF = new StringVariable(DataRepositoryEditPresenter.LABEL_VCF, valueVCF);
                StringVariable stringVariableVC = new StringVariable(DataRepositoryEditPresenter.LABEL_VC, valueVC);
                stringVariableVCF.addVariableChangeListener(DataRepositoryEditPresenter.this.myChangeListener);
                stringVariableVC.addVariableChangeListener(DataRepositoryEditPresenter.this.myChangeListener);
                VarListUtil.insertVariableAfterLabel(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.LABEL_VALUE_TYPE, stringVariableVCF, stringVariableVC);
            }
        }

        private void updateKeyVCFVariables(ValueType defaultValue) {
            VarListUtil.removeVariablesByLabel(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.LABEL_KCF, DataRepositoryEditPresenter.LABEL_KC);
            if (this.getSelectedKeyDataType() == DataType.OBJECT) {
                String valueKCF = defaultValue == null ? "" : defaultValue.getValueClassFactory().getClass().getName();
                String valueKC = defaultValue == null ? "" : defaultValue.getValueClass().getName();
                StringVariable stringVariableKCF = new StringVariable(DataRepositoryEditPresenter.LABEL_KCF, valueKCF);
                StringVariable stringVariableKC = new StringVariable(DataRepositoryEditPresenter.LABEL_KC, valueKC);
                stringVariableKCF.addVariableChangeListener(DataRepositoryEditPresenter.this.myChangeListener);
                stringVariableKC.addVariableChangeListener(DataRepositoryEditPresenter.this.myChangeListener);
                VarListUtil.insertVariableAfterLabel(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.LABEL_KEY_TYPE, stringVariableKCF, stringVariableKC);
            }
        }

        String getSelectedElementName() {
            return VarListUtil.getStringValueForName(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.LABEL_NAME).trim();
        }

        DataRepositoryModel.RepositoryDataType getSelectedElementType() {
            TypedDropDownVariable dropDownVar = (TypedDropDownVariable)VarListUtil.getVariableForName(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.LABEL_ELEMENT_TYPE);
            assert (dropDownVar != null);
            return (DataRepositoryModel.RepositoryDataType)((Object)dropDownVar.getSelectedItem());
        }

        DataType getSelectedValueDataType() {
            TypedDropDownVariable dropDownVar = (TypedDropDownVariable)VarListUtil.getVariableForName(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.LABEL_VALUE_TYPE);
            assert (dropDownVar != null);
            return (DataType)dropDownVar.getSelectedItem();
        }

        DataType getSelectedKeyDataType() {
            TypedDropDownVariable dropDownVar = (TypedDropDownVariable)VarListUtil.getVariableForName(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.LABEL_KEY_TYPE);
            assert (dropDownVar != null);
            return (DataType)dropDownVar.getSelectedItem();
        }

        ValueType getSelectedValueValueType() {
            AbstractValueType valueType = null;
            TypedDropDownVariable dropDownVar = (TypedDropDownVariable)VarListUtil.getVariableForName(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.LABEL_VALUE_TYPE);
            if (dropDownVar != null) {
                DataType selectedItem = (DataType)dropDownVar.getSelectedItem();
                if (selectedItem == DataType.OBJECT) {
                    String vcf = VarListUtil.getStringValueForName(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.LABEL_VCF);
                    String vc = VarListUtil.getStringValueForName(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.LABEL_VC);
                    valueType = ValueClassBasedValueType.createValueType(vcf, vc, DataRepositoryEditPresenter.this.myClassRepository);
                } else {
                    valueType = DataTypeBasedValueType.createValueType(selectedItem, DataRepositoryEditPresenter.this.myClassRepository);
                }
            }
            return valueType;
        }

        ValueType getSelectedKeyValueType() {
            AbstractValueType valueType = null;
            TypedDropDownVariable dropDownVar = (TypedDropDownVariable)VarListUtil.getVariableForName(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.LABEL_KEY_TYPE);
            if (dropDownVar != null) {
                DataType selectedItem = (DataType)dropDownVar.getSelectedItem();
                if (selectedItem == DataType.OBJECT) {
                    String kcf = VarListUtil.getStringValueForName(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.LABEL_KCF);
                    assert (kcf != null);
                    String kc = VarListUtil.getStringValueForName(DataRepositoryEditPresenter.this.myEditModel.getData(), DataRepositoryEditPresenter.LABEL_KC);
                    assert (kc != null);
                    try {
                        valueType = ValueClassBasedValueType.createValueType(kcf, kc, DataRepositoryEditPresenter.this.myClassRepository);
                    }
                    catch (ServiceDataException ex) {
                        String keyMessage = ex.getMessage().replace("value class", "key class");
                        throw new ServiceDataException(keyMessage, ex);
                    }
                } else {
                    valueType = DataTypeBasedValueType.createValueType(selectedItem, DataRepositoryEditPresenter.this.myClassRepository);
                }
            }
            return valueType;
        }

        void validateName(String name) throws ServiceDataException {
            if (DataRepositoryEditPresenter.this.myListModel.getDataRepositoryModel().exists(name) && !name.equals(DataRepositoryEditPresenter.this.myCurrentlyEditing)) {
                throw new ServiceDataException("Name: " + name + " already exists in repository.");
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedIndex = DataRepositoryEditPresenter.this.myListView.getSelectedIndex();
            if (selectedIndex >= 0) {
                String elementString = (String)DataRepositoryEditPresenter.this.myListModel.getElementAt(selectedIndex);
                DataRepositoryModel.RepositoryDataType elementType = DataRepositoryEditPresenter.this.myListModel.getRepositoryDataTypeAt(selectedIndex);
                DataRepositoryEditPresenter.this.initVarTableModelFromDataRep(elementString, elementType);
                DataRepositoryEditPresenter.this.myEditModel.fireTableStructureChanged();
                DataRepositoryEditPresenter.this.setCommitted(true);
            }
        }
    }

    private class CommitAction
    extends AbstractAction {
        private CommitAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DataRepositoryEditPresenter.this.commitElementToRepository();
                DataRepositoryEditPresenter.this.setCommitted(true);
                int index = DataRepositoryEditPresenter.this.myListModel.getIndexOf(DataRepositoryEditPresenter.this.myEditWrapper.getSelectedElementName());
                DataRepositoryEditPresenter.this.myListView.setSelectedIndex(index);
            }
            catch (SAXParseException ex) {
                DataRepositoryEditPresenter.this.myEditView.handleError(null, "Invalid XML: " + ex.getMessage());
            }
            catch (Exception ex) {
                DataRepositoryEditPresenter.this.myEditView.handleError(null, ex.getMessage());
            }
        }
    }

    private class ElementTypeDropDownChangeListener
    implements VariableChangeListener {
        private ElementTypeDropDownChangeListener() {
        }

        @Override
        public void valueChanged(VariableChangeEvent event) {
            DataRepositoryEditPresenter.this.updateElementTypeChanged();
            DataRepositoryEditPresenter.this.myEditModel.fireTableStructureChanged();
        }
    }

    private class KeyTypeDropDownChangeListener
    implements VariableChangeListener {
        private KeyTypeDropDownChangeListener() {
        }

        @Override
        public void valueChanged(VariableChangeEvent event) {
            DataRepositoryEditPresenter.this.updateKeyTypeChanged();
            DataRepositoryEditPresenter.this.myEditModel.fireTableStructureChanged();
        }
    }

    private class ValueTypeDropDownChangeListener
    implements VariableChangeListener {
        private ValueTypeDropDownChangeListener() {
        }

        @Override
        public void valueChanged(VariableChangeEvent event) {
            DataRepositoryEditPresenter.this.updateValueTypeChanged();
            DataRepositoryEditPresenter.this.myEditModel.fireTableStructureChanged();
        }
    }

    private class EditVariableChangeListener
    implements VariableChangeListener {
        private EditVariableChangeListener() {
        }

        @Override
        public void valueChanged(VariableChangeEvent event) {
            if (DataRepositoryEditPresenter.this.myCommitted) {
                DataRepositoryEditPresenter.this.setCommitted(false);
            }
        }
    }

    private class ListSelectionAction
    extends AbstractAction {
        int lastSelection = -1;
        boolean skipNextSelection = false;

        private ListSelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedIndex = DataRepositoryEditPresenter.this.myListView.getSelectedIndex();
            if (this.skipNextSelection) {
                this.skipNextSelection = false;
            } else {
                boolean cont = this.checkIfOkToContinue();
                if (cont) {
                    if (selectedIndex >= 0) {
                        DataRepositoryEditPresenter.this.myEditView.showEditView(true);
                        String elementString = (String)DataRepositoryEditPresenter.this.myListModel.getElementAt(selectedIndex);
                        DataRepositoryModel.RepositoryDataType elementType = DataRepositoryEditPresenter.this.myListModel.getRepositoryDataTypeAt(selectedIndex);
                        DataRepositoryEditPresenter.this.initVarTableModelFromDataRep(elementString, elementType);
                        DataRepositoryEditPresenter.this.myEditModel.fireTableStructureChanged();
                        DataRepositoryEditPresenter.this.myCurrentlyEditing = elementString;
                    } else {
                        DataRepositoryEditPresenter.this.myEditView.showEditView(false);
                        DataRepositoryEditPresenter.this.myCurrentlyEditing = null;
                    }
                    DataRepositoryEditPresenter.this.setCommitted(true);
                    this.lastSelection = selectedIndex;
                } else {
                    this.skipNextSelection = true;
                    DataRepositoryEditPresenter.this.myListView.setSelectedIndex(this.lastSelection);
                }
            }
        }

        private boolean checkIfOkToContinue() {
            boolean skipChanges;
            boolean isOk = true;
            if (!DataRepositoryEditPresenter.this.myCommitted && !(skipChanges = DataRepositoryEditPresenter.this.myEditView.askYesNoQuestion("The changes made to the current element have not been commited and will be lost. Do you want to continue?"))) {
                isOk = false;
            }
            return isOk;
        }
    }
}

