/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.constraint.gui;

import com.ericsson.ere.constraint.ConstraintModel;
import com.ericsson.ere.constraint.entity.Constraint;
import com.ericsson.ere.constraint.entity.ConstraintTargetType;
import com.ericsson.ere.swing.table.FilterableTableModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class FieldConstraintTableModel
extends FilterableTableModel<Constraint>
implements Observer {
    private List<String> myVisibleEntryNames = new ArrayList<String>();
    private static final long serialVersionUID = 1L;
    ConstraintModel myConstraintModel;

    public FieldConstraintTableModel(ConstraintModel constraintModel) {
        this.myConstraintModel = constraintModel;
        constraintModel.addObserver(this);
        this.populateModel(constraintModel);
        this.updateVisibleEntries();
    }

    private void populateModel(ConstraintModel constraintModel) {
        this.myEntries.clear();
        this.myVisibleEntryNames.clear();
        for (Constraint con : constraintModel.getConstraintList()) {
            this.myEntries.add(con);
        }
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public void refresh() {
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return rowIndex > -1 ? this.myVisibleEntries.get(rowIndex) : this.myVisibleEntries.get(0);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.populateModel((ConstraintModel)o);
        this.updateVisibleEntries();
    }

    public ConstraintModel getConstraintModel() {
        return this.myConstraintModel;
    }

    @Override
    protected boolean shouldEntryBeVisible(Constraint entry, int index) {
        if (this.myVisibleEntryNames.contains(entry.getTarget().getTargetValue())) {
            return false;
        }
        if (entry.getTarget().getTargetType() == ConstraintTargetType.FIELD) {
            this.myVisibleEntryNames.add(entry.getTarget().getTargetValue());
            return true;
        }
        return false;
    }
}

