/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.constraint.gui;

import com.ericsson.ere.constraint.contract.AbstractConstrainableProfileContract;
import com.ericsson.ere.constraint.contract.ConstrainableProfileContract;
import com.ericsson.ere.constraint.contract.ConstrainableService;
import com.ericsson.ere.constraint.contract.ConstraintSpecification;
import com.ericsson.ere.constraint.entity.Constrainable;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintTarget;
import com.ericsson.ere.constraint.entity.ConstraintTargetType;
import com.ericsson.ere.gui.editors.serviceeditor.constraint.gui.ConstraintAddEditDialog;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.FieldHierarchyNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FieldConstraintDialogDataSource
implements ConstraintAddEditDialog.ConstraintDialogDataSource {
    @Override
    public Collection<Constrainable> getConstrainables(ClassRepository classRep) throws ClassNotFoundException {
        ConstrainableService service = ConstrainableService.forRepository(classRep);
        ArrayList<Constrainable> result = new ArrayList<Constrainable>(service.getConstrainableConditions());
        result.addAll(service.getConstrainableModifiers());
        Constrainable allConditions = Constrainable.createGeneral(Constrainable.ConstrainableType.CONDITION);
        Constrainable allModifiers = Constrainable.createGeneral(Constrainable.ConstrainableType.MODIFIER);
        result.add(0, allModifiers);
        result.add(0, allConditions);
        return result;
    }

    @Override
    public ConstrainableProfileContract getContractForConstrainable(ClassRepository classRep, Constrainable constrainable) {
        ConstrainableService service = ConstrainableService.forRepository(classRep);
        AnyContextContract contract = constrainable.isGeneral() ? new GeneralConstrainableContract(classRep) : new AnyContextContract(classRep, service.getContractForConstrainable(constrainable));
        return contract;
    }

    static List<String> getAllFieldNames(ClassRepository rep) {
        ArrayList<FieldHierarchyNode> fields = new ArrayList<FieldHierarchyNode>();
        for (FieldHierarchyNode node : rep.getFieldRepository().getTopLevelFields()) {
            if (node instanceof FieldDefinition) {
                String type = ((FieldDefinition)node).getParameterType();
                if (!type.equals("VARIABLE") && !type.equals("IN") && !type.equals("OUT")) continue;
                fields.add(node);
                continue;
            }
            fields.add(node);
        }
        ArrayList<String> names = new ArrayList<String>();
        for (FieldHierarchyNode node : fields) {
            names.add(node.getFieldName());
        }
        Collections.sort(names);
        return names;
    }

    static class GeneralConstrainableContract
    extends AnyContextContract {
        private GeneralConstrainableContract(ClassRepository repository) {
            super(repository, null);
        }

        @Override
        public Set<ConstraintSpecification> supportedConstraintSpecifications() {
            return Collections.singleton(ConstraintSpecification.any(ConstraintTargetType.FIELD));
        }
    }

    static class AnyContextContract
    extends AbstractConstrainableProfileContract {
        private ConstrainableProfileContract myContract;

        AnyContextContract(ClassRepository repository, ConstrainableProfileContract contract) {
            super(repository);
            this.myContract = contract;
        }

        @Override
        public Collection<ConstraintTarget> getConstraintTargets(ConstraintTargetType type, ConstraintContext context) {
            return this.getConstraintTargetsImpl(type, context);
        }

        @Override
        protected Collection<ConstraintTarget> getConstraintTargetsImpl(ConstraintTargetType type, ConstraintContext context) {
            Collection<ConstraintTarget> targets;
            if (context.isAnyContext()) {
                assert (type == ConstraintTargetType.FIELD) : "Expected FIELD target type!";
                List<String> names = FieldConstraintDialogDataSource.getAllFieldNames(this.classRepository());
                targets = this.namesToTargets(names, type);
            } else {
                targets = this.myContract.getConstraintTargets(type, context);
            }
            return targets;
        }

        @Override
        public Set<ConstraintSpecification> supportedConstraintSpecifications() {
            HashSet<ConstraintSpecification> set = new HashSet<ConstraintSpecification>();
            boolean hasFieldTarget = false;
            for (ConstraintSpecification cs : this.myContract.supportedConstraintSpecifications()) {
                set.add(cs);
                if (cs.getTargetType() != ConstraintTargetType.FIELD) continue;
                hasFieldTarget = true;
            }
            if (hasFieldTarget) {
                set.add(ConstraintSpecification.any(ConstraintTargetType.FIELD));
            }
            return set;
        }
    }
}

