/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.Variable;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class TreeNodeSelectionHandler {
    private final VarTableModel myTableModel;
    private AbstractTreeNode myVariableOwner;
    private final Map<JTree, TreeData> myTrees;
    private final Handler myHandler;

    public TreeNodeSelectionHandler(VarTableModel model) {
        this.myTableModel = model;
        this.myTrees = new HashMap<JTree, TreeData>();
        this.myHandler = new Handler();
    }

    public void bindTree(JTree tree, Component ... helpComponents) {
        this.myTrees.put(tree, new TreeData(helpComponents));
        tree.addTreeSelectionListener(this.myHandler);
        tree.addFocusListener(this.myHandler);
    }

    private void populateModelFromNode(JTree tree, AbstractTreeNode node) {
        if (this.myVariableOwner != node) {
            this.discardOldVariables();
            if (node == null) {
                this.clearVariableTable();
            } else {
                this.enableHelpKey(node, this.myTrees.get(tree).getHelpComponents());
                this.populateVariableTable(node);
            }
        }
    }

    private void populateVariableTable(AbstractTreeNode theNode) {
        try {
            List<Variable> vars = theNode.getVariablesForEditing(this.myTableModel);
            this.myTableModel.setData(vars);
            this.myVariableOwner = theNode;
        }
        catch (Exception ee) {
            RmaDefs.loggerServiceDefinition.warning("ERROR " + ee.getMessage());
        }
    }

    private void enableHelpKey(AbstractTreeNode theNode, Component[] helpComponents) {
        for (Component hc : helpComponents) {
            GuiServiceCenter.getInstance().enableHelpKey(hc, theNode.getClass().toString(), null);
        }
    }

    private void clearVariableTable() {
        this.myTableModel.setData(Collections.emptyList());
        this.myVariableOwner = null;
    }

    private void discardOldVariables() {
        if (this.myVariableOwner != null) {
            List<Variable> vars = this.myVariableOwner.getVariablesForEditing(null);
            this.myVariableOwner.editingFinished(vars);
            this.myVariableOwner = null;
        }
    }

    private static class TreeData {
        private Component[] myHelpComponents;

        TreeData(Component[] helpComponents) {
            this.myHelpComponents = Arrays.copyOf(helpComponents, helpComponents.length);
        }

        Component[] getHelpComponents() {
            return this.myHelpComponents;
        }
    }

    private class Handler
    extends FocusAdapter
    implements TreeSelectionListener {
        private Handler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            JTree tree = (JTree)e.getSource();
            TreePath path = e.getNewLeadSelectionPath();
            TreeNodeSelectionHandler.this.populateModelFromNode(tree, this.nodeFromPath(path));
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (!e.isTemporary()) {
                JTree tree = (JTree)e.getSource();
                TreePath path = tree.getSelectionPath();
                TreeNodeSelectionHandler.this.populateModelFromNode(tree, this.nodeFromPath(path));
            }
        }

        private AbstractTreeNode nodeFromPath(TreePath path) {
            return path != null ? (AbstractTreeNode)path.getLastPathComponent() : null;
        }
    }
}

