/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.diff;

import com.ericsson.ere.gui.diff.DiffPoint;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import java.awt.Color;
import javax.swing.tree.TreePath;

public class DiffPointMissingChild
extends DiffPoint {
    public static final Color MY_COLOR = new Color(113, 208, 81);
    private boolean myExistsInLocal;
    private TariffDAGNode myNewElement;

    public DiffPointMissingChild(TreePath localParent, TreePath remoteParent, TariffDAGNode newElement, boolean existsInLocal) {
        super(localParent, remoteParent);
        this.myNewElement = newElement;
        this.myExistsInLocal = existsInLocal;
    }

    public boolean elementExistsInLocalPath() {
        return this.myExistsInLocal;
    }

    @Override
    public String getDiffDescription(boolean useLocalAndRemoteNames) {
        TariffDAGNode newElementParent;
        String firstName = useLocalAndRemoteNames ? "local" : "first";
        String secondName = useLocalAndRemoteNames ? "remote" : "second";
        String description = "There is a difference between";
        if (this.myExistsInLocal) {
            newElementParent = (TariffDAGNode)this.myLocalPath.getLastPathComponent();
            TariffDAGNode otherParent = (TariffDAGNode)this.myRemotePath.getLastPathComponent();
            description = description + " the " + firstName + " " + DiffPointMissingChild.getNodeTypeString(newElementParent) + " \"" + newElementParent.getNodeName() + "\" and the " + secondName + " " + DiffPointMissingChild.getNodeTypeString(otherParent) + " \"" + otherParent.getNodeName() + "\":";
        } else {
            TariffDAGNode otherParent = (TariffDAGNode)this.myLocalPath.getLastPathComponent();
            newElementParent = (TariffDAGNode)this.myRemotePath.getLastPathComponent();
            description = description + " the " + firstName + " " + DiffPointMissingChild.getNodeTypeString(otherParent) + " \"" + otherParent.getNodeName() + "\" and the " + secondName + " " + DiffPointMissingChild.getNodeTypeString(newElementParent) + " \"" + newElementParent.getNodeName() + "\":";
        }
        description = description + "\n\n- The " + DiffPointMissingChild.getNodeTypeString(this.myNewElement) + " called \"" + this.myNewElement.getNodeName() + "\" exists only under ";
        description = this.myExistsInLocal ? description + "the " + firstName + " " + DiffPointMissingChild.getNodeTypeString(newElementParent) : description + "the " + secondName + " " + DiffPointMissingChild.getNodeTypeString(newElementParent);
        return description;
    }

    @Override
    public String getDiffActionDescription(boolean useLocalAndRemoteNames) {
        return "\n\nShould the " + DiffPointMissingChild.getNodeTypeString(this.myNewElement) + " be added to the Result Tree?";
    }

    public TariffDAGNode getNewElement() {
        return this.myNewElement;
    }

    @Override
    public String getLocalActionDescription(boolean useLocalAndRemoteNames) {
        if (this.myExistsInLocal) {
            return "Yes";
        }
        return "No";
    }

    @Override
    public String getRemoteActionDescription(boolean useLocalAndRemoteNames) {
        if (this.myExistsInLocal) {
            return "No";
        }
        return "Yes";
    }

    @Override
    public boolean isBothActionsAllowed() {
        return false;
    }

    @Override
    public boolean isNoActionsAllowed() {
        return false;
    }

    @Override
    public int getDiffPriority() {
        return 3;
    }

    @Override
    public Color getDiffColor() {
        return MY_COLOR;
    }
}

