/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.expression.BinaryAmountOperator;
import com.ericsson.ere.expression.BinaryDateOperator;
import com.ericsson.ere.expression.BinaryTimeOperator;
import com.ericsson.ere.expression.GenericBinaryOperator;
import com.ericsson.ere.math.RatingDecimal;

public final class Subtract
extends GenericBinaryOperator {
    public static final Subtract INSTANCE = new Subtract();

    private Subtract() {
    }

    @Override
    protected Object performImpl(Object left, Object right) {
        Object ret;
        if (BinaryTimeOperator.canHandle(left, right)) {
            ret = BinaryTimeOperator.SUBTRACT.perform(left, right);
        } else if (BinaryDateOperator.canHandle(left, right)) {
            ret = BinaryDateOperator.SUBTRACT.perform(left, right);
        } else if (BinaryAmountOperator.canHandle(left, right)) {
            ret = BinaryAmountOperator.SUBTRACT.perform(left, right);
        } else {
            RatingDecimal rd1 = Subtract.convertToRatingDecimal(left, "left");
            RatingDecimal rd2 = Subtract.convertToRatingDecimal(right, "right");
            ret = rd1.subtract(rd2);
        }
        return ret;
    }

    public String toString() {
        return "-";
    }
}

