/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionConverter;
import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.InfixOperatorRules;
import com.ericsson.ere.expression.Operator;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class PostfixToInfixConverter
implements ExpressionConverter {
    private InfixOperatorRules myRules;

    public PostfixToInfixConverter(InfixOperatorRules rules) {
        this.myRules = rules;
    }

    @Override
    public Expression convert(Expression expr) {
        if (expr.getNotation() != Expression.ExpressionNotation.POSTFIX) {
            throw new IllegalArgumentException("This algorithm requires a postfix expression.");
        }
        Expression result = new Expression(this.convert(expr.getExpressionTokens()), Expression.ExpressionNotation.INFIX);
        return result;
    }

    private List<ExpressionToken> convert(List<ExpressionToken> tokens) {
        Stack<TreeNode> stack = new Stack<TreeNode>();
        for (ExpressionToken token : tokens) {
            if (token instanceof Operator) {
                TreeNode op1 = (TreeNode)stack.pop();
                TreeNode op2 = (TreeNode)stack.pop();
                stack.push(new TreeNode(token, op2, op1));
                continue;
            }
            stack.push(new TreeNode(token, null, null));
        }
        ArrayList<ExpressionToken> result = new ArrayList<ExpressionToken>(tokens.size());
        this.layout((TreeNode)stack.pop(), result);
        return result;
    }

    private void layout(TreeNode temp, List<ExpressionToken> out) {
        if (temp != null) {
            boolean encloseRightInParens;
            boolean encloseLeftInParens = temp.prev != null && temp.prev.isOperator() && this.secondGoesFirst((Operator)temp.prev.token, (Operator)temp.token);
            boolean bl = encloseRightInParens = temp.next != null && temp.next.isOperator() && this.secondGoesFirst((Operator)temp.next.token, (Operator)temp.token);
            if (encloseLeftInParens) {
                out.add(ExpressionToken.LEFT_PAREN);
            }
            this.layout(temp.prev, out);
            if (encloseLeftInParens) {
                out.add(ExpressionToken.RIGHT_PAREN);
            }
            out.add(temp.token);
            if (encloseRightInParens) {
                out.add(ExpressionToken.LEFT_PAREN);
            }
            this.layout(temp.next, out);
            if (encloseRightInParens) {
                out.add(ExpressionToken.RIGHT_PAREN);
            }
        }
    }

    private boolean secondGoesFirst(Operator o1, Operator o2) {
        return this.myRules.precedenceOf(o1) < this.myRules.precedenceOf(o2);
    }

    private static class TreeNode {
        ExpressionToken token;
        TreeNode next;
        TreeNode prev;

        TreeNode(ExpressionToken token, TreeNode prev, TreeNode next) {
            this.token = token;
            this.prev = prev;
            this.next = next;
        }

        boolean isOperator() {
            return this.token instanceof Operator;
        }
    }
}

