/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.expression.BinaryAmountOperator;
import com.ericsson.ere.expression.GenericBinaryOperator;
import com.ericsson.ere.math.RatingDecimal;

public final class Multiply
extends GenericBinaryOperator {
    public static final Multiply INSTANCE = new Multiply();

    private Multiply() {
    }

    @Override
    protected Object performImpl(Object left, Object right) {
        Object result;
        if (BinaryAmountOperator.canHandle(left, right)) {
            result = BinaryAmountOperator.MULTIPLY.perform(left, right);
        } else {
            RatingDecimal rd1 = Multiply.convertToRatingDecimal(left, "left");
            RatingDecimal rd2 = Multiply.convertToRatingDecimal(right, "right");
            result = rd1.multiply(rd2);
        }
        return result;
    }

    public String toString() {
        return "*";
    }
}

