/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.expression.ExpressionException;
import com.ericsson.ere.expression.GenericBinaryOperator;
import com.ericsson.ere.math.RatingDecimal;
import ericsson.ere.datatype.Amount;

public enum BinaryAmountOperator {
    ADD{

        @Override
        Object perform(Object left, Object right) {
            Amount ret;
            String otherLocation;
            boolean leftIsAmount = 1.isAmount(left);
            Amount amount = (Amount)(leftIsAmount ? left : right);
            Object other = leftIsAmount ? right : left;
            String string = otherLocation = leftIsAmount ? "right" : "left";
            if (other instanceof Amount) {
                ret = amount.add((Amount)other);
            } else {
                RatingDecimal num = GenericBinaryOperator.convertToRatingDecimal(other, otherLocation);
                ret = this.addValueToAmount(amount, num);
            }
            return ret;
        }
    }
    ,
    SUBTRACT{

        @Override
        Object perform(Object left, Object right) {
            Amount ret;
            boolean bothAreAmounts;
            boolean leftIsAmount = 2.isAmount(left);
            boolean bl = bothAreAmounts = leftIsAmount && 2.isAmount(right);
            if (bothAreAmounts) {
                ret = ((Amount)left).deduct((Amount)right);
            } else if (leftIsAmount) {
                RatingDecimal num = GenericBinaryOperator.convertToRatingDecimal(right, "right").negate();
                ret = this.addValueToAmount((Amount)left, num);
            } else {
                throw new ExpressionException("Amount subtraction requires the left or both operands to be amounts.");
            }
            return ret;
        }
    }
    ,
    MULTIPLY{

        @Override
        Object perform(Object left, Object right) {
            boolean leftIsAmount = 3.isAmount(left);
            Amount amount = (Amount)(leftIsAmount ? left : right);
            Object other = leftIsAmount ? right : left;
            String otherLocation = leftIsAmount ? "right" : "left";
            RatingDecimal num = GenericBinaryOperator.convertToRatingDecimal(other, otherLocation);
            return this.multiplyAmountWithValue(amount, num);
        }
    }
    ,
    DIVIDE{

        @Override
        Object perform(Object left, Object right) {
            boolean leftIsAmount = 4.isAmount(left);
            boolean rightIsAmount = 4.isAmount(right);
            if (leftIsAmount) {
                Amount amount = (Amount)left;
                if (rightIsAmount) {
                    return amount.quotient((Amount)right);
                }
                RatingDecimal num = GenericBinaryOperator.convertToRatingDecimal(right, "right");
                return this.multiplyAmountWithValue(amount, RD_ONE.divide(num));
            }
            throw new ExpressionException("Amount division requires the left operand to be an amount.");
        }
    };

    private static final RatingDecimal RD_ONE;

    static boolean isAmount(Object value) {
        return value instanceof Amount;
    }

    static boolean canHandle(Object left, Object right) {
        return BinaryAmountOperator.isAmount(left) || BinaryAmountOperator.isAmount(right);
    }

    protected Amount addValueToAmount(Amount amount, RatingDecimal value) {
        if (value.isZero()) {
            return amount;
        }
        Amount add = amount.getAmountFactory().create(value, amount.getCurrency());
        return amount.add(add);
    }

    protected Amount multiplyAmountWithValue(Amount amount, RatingDecimal value) {
        RatingDecimal newBalance = amount.getBalance().multiply(value);
        Amount newAmount = amount.getAmountFactory().create(newBalance, amount.getCurrency());
        return newAmount;
    }

    abstract Object perform(Object var1, Object var2);

    static {
        RD_ONE = new RatingDecimal(1L, 1L);
    }
}

