/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DefaultDataSet;
import com.ericsson.ere.expression.EvaluationContext;
import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionEvaluator;
import com.ericsson.ere.expression.ExpressionException;
import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.FunctionArgBOF;
import com.ericsson.ere.expression.FunctionArgumentCountException;
import com.ericsson.ere.expression.FunctionArgumentTypeException;
import com.ericsson.ere.expression.FunctionArgumentValueException;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.OperationRestriction;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.expression.PostfixEvaluator;
import com.ericsson.ere.expression.ShuntingYardConverter;
import com.ericsson.ere.expression.StandardInfixOperatorRules;
import com.ericsson.ere.expression.ValueOperand;
import com.ericsson.ere.selectiontree.modifiers.mfo.DataSetEvaluationContext;
import ericsson.ere.datatype.DataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public abstract class AbstractExpressionChecker
extends PostfixEvaluator {
    private DataType myResultDataType;
    private List<OperationRestriction> myRestrictions;

    protected AbstractExpressionChecker() {
        this(null);
    }

    protected AbstractExpressionChecker(List<? extends OperationRestriction> restrictions) {
        this.myRestrictions = restrictions == null ? Collections.emptyList() : new ArrayList<OperationRestriction>(restrictions);
    }

    protected abstract void markOperationInvalid(Operator var1, List<Operand> var2, String var3);

    protected abstract DataType getOperandDataType(Operand var1);

    @Override
    public Operand evaluate(Expression expression, EvaluationContext context) {
        Expression e = this.stubExpression(expression);
        return super.evaluate(e, context);
    }

    public boolean checkExpression(Expression expression) {
        this.myResultDataType = null;
        Expression expr = expression;
        if (expr.getNotation() == Expression.ExpressionNotation.INFIX) {
            expr = new ShuntingYardConverter(new StandardInfixOperatorRules()).convert(expr);
        }
        DataSetEvaluationContext context = new DataSetEvaluationContext(){

            @Override
            public ExpressionEvaluator getEvaluator() {
                return AbstractExpressionChecker.this;
            }

            @Override
            public DataSet getDataSet() {
                return new DefaultDataSet();
            }
        };
        Operand result = this.evaluate(expr, context);
        Stack<Operand> temp = new Stack<Operand>();
        temp.push(result);
        this.performOperator(new EvaluatingUnaryOperator(), temp, context);
        result = temp.pop();
        boolean ok = !(result instanceof ErrorOperand);
        this.myResultDataType = this.getDataTypeFor(result);
        return ok;
    }

    public DataType getResultingDataType() {
        return this.myResultDataType;
    }

    @Override
    protected void performOperator(Operator o, Stack<Operand> operands, EvaluationContext context) {
        Stack clone = (Stack)operands.clone();
        try {
            DataTypeOperand push;
            this.enforceConfigurationRestrictions(o, operands);
            super.performOperator(o, operands, context);
            int consumed = clone.size() - operands.size() + 1;
            List<Operand> inputs = AbstractExpressionChecker.popOperandsToList(clone, consumed);
            Operand result = operands.pop();
            if (inputs.contains(result)) {
                DataType dt = this.findResultingDataType(result, inputs);
                Object value = this.createStubValue(dt);
                push = StubOperand.createValid(value, dt);
            } else {
                push = new DataTypeWrapperOperand(result, this.findResultingDataType(result, inputs));
            }
            operands.push(push);
        }
        catch (ArithmeticException ignore) {
            Operand result = (Operand)clone.pop();
            DataType dt = this.getDataTypeFor(result);
            Object value = this.createStubValue(dt);
            operands.push(StubOperand.createValid(value, dt));
        }
        catch (FunctionArgumentValueException e) {
            operands.push(this.createFunctionResultStubOperand((Function)o));
        }
        catch (FunctionArgumentTypeException e) {
            this.handleFunctionEvaluationError(o, operands, clone, e);
        }
        catch (FunctionArgumentCountException e) {
            this.handleFunctionEvaluationError(o, operands, clone, e);
        }
        catch (InvalidOperandException e) {
            operands.push(new ErrorOperand(e));
        }
        catch (RuntimeException e) {
            if (!(o instanceof EvaluatingUnaryOperator)) {
                this.markOperationInvalid(e, o, operands, clone);
            }
            operands.push(new ErrorOperand(new InvalidOperandException(this.getExceptionMessage(e))));
        }
    }

    private void handleFunctionEvaluationError(Operator o, Stack<Operand> operands, Stack<Operand> clone, ExpressionException e) {
        this.markOperationInvalid(e, o, operands, clone);
        operands.push(new ErrorOperand(new InvalidOperandException(e.getMessage())));
    }

    private void markOperationInvalid(RuntimeException ex, Operator o, Stack<Operand> operands, Stack<Operand> clone) {
        int count = clone.size() - operands.size();
        List<Operand> inputs = AbstractExpressionChecker.popOperandsToList(clone, count);
        this.markOperationInvalid(o, inputs, this.getExceptionMessage(ex));
    }

    private Operand createFunctionResultStubOperand(Function func) {
        DataType dt = func.getReturnType();
        Object value = this.createStubValue(dt);
        return StubOperand.createValid(value, dt);
    }

    private void enforceConfigurationRestrictions(Operator operator, Stack<Operand> operands) {
        for (OperationRestriction r : this.myRestrictions) {
            r.enforce(operator, operands);
        }
    }

    static List<Operand> popOperandsToList(Stack<Operand> operands, int count) {
        ArrayList<Operand> ret = new ArrayList<Operand>();
        int n = count;
        while (n-- > 0) {
            ret.add(operands.pop());
        }
        return ret;
    }

    protected String getExceptionMessage(RuntimeException e) {
        String msg = e.getMessage();
        if (msg == null && e instanceof NumberFormatException) {
            msg = "Not a numeric value.";
        }
        return msg;
    }

    private DataType findResultingDataType(Operand result, List<Operand> input) {
        ArrayList<DataType> inputDataTypes = new ArrayList<DataType>();
        boolean allAreNumeric = true;
        for (Operand op : input) {
            DataType dt = this.getDataTypeFor(op);
            allAreNumeric &= dt != null && dt.isNumeric();
            if (dt == null) continue;
            inputDataTypes.add(dt);
        }
        DataType dt = null;
        if (allAreNumeric && inputDataTypes.size() == 2) {
            dt = DataType.getLargerEnclosingDataType((DataType)inputDataTypes.get(0), (DataType)inputDataTypes.get(1));
        } else if (result != null) {
            dt = this.getDataTypeFor(result);
        }
        if (dt == null && inputDataTypes.size() > 0) {
            dt = (DataType)inputDataTypes.get(0);
        }
        return dt;
    }

    private DataType getDataTypeFor(Operand o) {
        DataType dt = null;
        if (o instanceof DataTypeOperand) {
            dt = ((DataTypeOperand)o).getDataType();
        } else if (o instanceof ValueOperand) {
            dt = DataType.fromObjectClass(o.getValue(null));
        } else if (o != null && !(o instanceof ErrorOperand) && !(o instanceof FunctionArgBOF)) {
            dt = this.getOperandDataType(o);
        }
        return dt;
    }

    private Expression stubExpression(Expression expression) {
        List<ExpressionToken> tokens = expression.getExpressionTokens();
        List<ExpressionToken> stubs = this.stubOperands(tokens);
        return new Expression(stubs, expression.getNotation());
    }

    private List<ExpressionToken> stubOperands(List<ExpressionToken> tokens) {
        ArrayList<ExpressionToken> stubs = new ArrayList<ExpressionToken>(tokens.size());
        for (ExpressionToken token : tokens) {
            if (token instanceof Operand) {
                Operand o = (Operand)token;
                stubs.add(this.stubOperand(o));
                continue;
            }
            stubs.add(token);
        }
        return stubs;
    }

    protected Operand stubOperand(Operand o) {
        if (o == FunctionArgBOF.INSTANCE) {
            return o;
        }
        DataType dataType = this.getDataTypeFor(o);
        Object stub = this.createStubValue(dataType);
        return StubOperand.createValid(stub, dataType);
    }

    protected Object createStubValue(DataType dt) {
        Object ret = dt == null ? null : (dt.isNumeric() ? dt.parseValue("1") : (this.isStringType(dt) ? dt.parseValue("abab") : dt.createDefaultInstance()));
        return ret;
    }

    protected final boolean isStringType(DataType dt) {
        return dt == DataType.STRING || dt == DataType.BCDSTRING || dt == DataType.OCTETSTRING;
    }

    private static class EvaluatingUnaryOperator
    implements Operator {
        private EvaluatingUnaryOperator() {
        }

        @Override
        public void perform(Stack<Operand> operandStack, EvaluationContext context) {
            Operand op = operandStack.pop();
            op.getValue(context);
            operandStack.push(op);
        }
    }

    protected static class InvalidOperandException
    extends ExpressionException {
        public InvalidOperandException(String message) {
            super(message);
        }
    }

    protected static class ErrorOperand
    implements Operand {
        private RuntimeException myException;

        public ErrorOperand(RuntimeException e) {
            this.myException = e;
        }

        @Override
        public Object getValue(EvaluationContext context) {
            this.myException.fillInStackTrace();
            throw this.myException;
        }
    }

    protected static class StubOperand
    implements DataTypeOperand {
        private Object myValue;
        private DataType myDataType;
        private String myInvalidMessage;

        private StubOperand(Object value, DataType dataType, String message) {
            this.myValue = value;
            this.myDataType = dataType;
            this.myInvalidMessage = message;
        }

        boolean isInvalid() {
            return this.myInvalidMessage != null;
        }

        String getInvalidMessage() {
            return this.myInvalidMessage;
        }

        public static StubOperand createValid(Object value, DataType dataType) {
            return new StubOperand(value, dataType, null);
        }

        public static StubOperand createInvalid(String message) {
            return new StubOperand(null, null, message);
        }

        @Override
        public Object getValue(EvaluationContext context) {
            if (this.isInvalid()) {
                throw new InvalidOperandException(this.myInvalidMessage);
            }
            return this.myValue;
        }

        @Override
        public DataType getDataType() {
            return this.myDataType;
        }

        public String toString() {
            return "|" + this.myValue + "|";
        }
    }

    private static class DataTypeWrapperOperand
    implements DataTypeOperand {
        private DataType myDataType;
        private Operand myOperand;

        DataTypeWrapperOperand(Operand inner, DataType dataType) {
            this.myOperand = inner;
            this.myDataType = dataType;
        }

        @Override
        public Object getValue(EvaluationContext context) {
            return this.myOperand.getValue(context);
        }

        @Override
        public DataType getDataType() {
            return this.myDataType;
        }
    }

    protected static interface DataTypeOperand
    extends Operand {
        public DataType getDataType();
    }
}

