/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.defs;

import com.ericsson.ere.defs.ValueType;
import com.ericsson.ere.exception.ServiceDataException;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.interfaces.ValueClassFactory;

public abstract class AbstractValueType
implements ValueType {
    protected final ValueClassFactory myValueClassFactory;

    protected AbstractValueType(ValueClassFactory valueClassFactory) {
        if (valueClassFactory == null) {
            throw new IllegalArgumentException("Parameter valueClassFactory cannot be null.");
        }
        this.myValueClassFactory = valueClassFactory;
    }

    @Override
    public ValueClassFactory getValueClassFactory() {
        return this.myValueClassFactory;
    }

    @Override
    public Class<?> getValueClass() {
        throw new IllegalStateException("The value type has not been initialized with a value class.");
    }

    @Override
    public DataType getDataType() {
        throw new IllegalStateException("The value type has not been initialized with a data type.");
    }

    @Override
    public boolean isInstance(Object value) {
        boolean retValue = false;
        try {
            String valueString = this.myValueClassFactory.makeValueString(value);
            if (valueString != null) {
                retValue = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retValue;
    }

    @Override
    public Object createObjectFromString(String valueString) throws ServiceDataException, IllegalArgumentException {
        if (valueString == null) {
            throw new IllegalArgumentException("Parameter valueString cannot be null.");
        }
        String errorString = "Could not create object with factory: " + this.myValueClassFactory.getClass().getName() + " from value string: " + valueString + ". The given value string format must be manageable by the factory.";
        Object value = null;
        try {
            value = this.myValueClassFactory.parseValueString(valueString);
        }
        catch (RuntimeException ex) {
            throw new ServiceDataException(errorString, ex);
        }
        if (value == null) {
            throw new ServiceDataException(errorString);
        }
        return value;
    }
}

