/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.dataset.jump;

import com.ericsson.ere.annotations.jcip.Immutable;
import ericsson.ere.management.RatingPlan;
import ericsson.ere.xml.DomWriter;
import org.w3c.dom.Element;

@Immutable
public class SelectionTreeDestination {
    public static final String TAG_GOTO = "GoTo";
    private final String myServiceProvider;
    private final String myService;
    private final String myPlan;

    public SelectionTreeDestination(String plan, String service, String provider) {
        this.myPlan = plan;
        this.myService = service;
        this.myServiceProvider = provider;
    }

    public SelectionTreeDestination(Element goToElement) {
        if (!(goToElement.hasAttribute("Plan") && goToElement.hasAttribute("Provider") && goToElement.hasAttribute("Service"))) {
            String xml = DomWriter.elementToString(goToElement);
            throw new IllegalArgumentException("Not valid XML:\n" + xml);
        }
        this.myPlan = goToElement.getAttribute("Plan");
        this.myService = goToElement.getAttribute("Service");
        this.myServiceProvider = goToElement.getAttribute("Provider");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myPlan == null ? 0 : this.myPlan.hashCode());
        result = 31 * result + (this.myService == null ? 0 : this.myService.hashCode());
        result = 31 * result + (this.myServiceProvider == null ? 0 : this.myServiceProvider.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectionTreeDestination other = (SelectionTreeDestination)obj;
        if (this.myPlan == null ? other.myPlan != null : !this.myPlan.equals(other.myPlan)) {
            return false;
        }
        if (this.myService == null ? other.myService != null : !this.myService.equals(other.myService)) {
            return false;
        }
        return !(this.myServiceProvider == null ? other.myServiceProvider != null : !this.myServiceProvider.equals(other.myServiceProvider));
    }

    public String toString() {
        if (this.myPlan.length() == 0 && this.myService.length() == 0 && this.myServiceProvider.length() == 0) {
            return "[NONE]";
        }
        if (this.myService.equals(this.myServiceProvider)) {
            return this.getPlanName() + "@" + this.myServiceProvider;
        }
        return this.getPlanName() + "(" + this.myService + ")@" + this.myServiceProvider;
    }

    public String getPlanName() {
        return this.myPlan;
    }

    public String getServiceName() {
        return this.myService;
    }

    public String getProviderName() {
        return this.myServiceProvider;
    }

    public String getXmlTag() {
        return "<GoTo Plan='" + this.myPlan + "' " + "Provider" + "='" + this.myServiceProvider + "' " + "Service" + "='" + this.myService + "'/>";
    }

    public boolean isEqual(SelectionTreeDestination selDest) {
        return this.equals(selDest);
    }

    public boolean isEqualToRatingPlan(RatingPlan plan) {
        if (plan != null) {
            return this.myPlan.equals(plan.getName()) && this.myService.equals(plan.getServiceName()) && this.myServiceProvider.equals(plan.getNameOfServiceProvider());
        }
        return false;
    }
}

