/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.constraint.entity;

import com.ericsson.ere.constraint.entity.ConstraintContextItemType;

public class ConstraintContextItem {
    private ConstraintContextItemType myItemType;
    private String myItemValue;

    ConstraintContextItem(ConstraintContextItemType itemType, String itemValue) {
        this.myItemType = itemType;
        this.myItemValue = itemValue;
    }

    public static ConstraintContextItem createContextItem(ConstraintContextItemType itemType, String itemValue) {
        if (itemType == null || itemValue == null) {
            throw new IllegalArgumentException("Arguments must not be null");
        }
        return new ConstraintContextItem(itemType, itemValue);
    }

    public static ConstraintContextItem createContextItemForAny(ConstraintContextItemType itemType) {
        return ConstraintContextItem.createContextItem(itemType, "*");
    }

    public boolean isAny() {
        return "*".equals(this.myItemValue);
    }

    public ConstraintContextItemType getType() {
        return this.myItemType;
    }

    public String getValue() {
        return this.myItemValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myItemValue == null ? 0 : this.myItemValue.hashCode());
        result = 31 * result + (this.myItemType == null ? 0 : this.myItemType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstraintContextItem other = (ConstraintContextItem)obj;
        if (this.myItemValue == null ? other.myItemValue != null : !this.myItemValue.equals(other.myItemValue)) {
            return false;
        }
        return !(this.myItemType == null ? other.myItemType != null : !this.myItemType.equals((Object)other.myItemType));
    }

    public String toString() {
        if (this.isAny()) {
            return "any " + this.myItemType.getName().toLowerCase();
        }
        return this.myItemValue;
    }
}

