/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validators.impl;

import com.ericsson.em.validators.IsVersionString;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

public class IsVersionStringValidator
implements ConstraintValidator<IsVersionString, String> {
    @Override
    public void initialize(IsVersionString parameters) {
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        boolean isValid = true;
        try {
            if (value != null) {
                String[] parts = value.split("\\.");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Version not in MM.mm format");
                }
                short major = Short.parseShort(parts[0]);
                short minor = Short.parseShort(parts[1]);
                this.verify(major);
                this.verify(minor);
            }
        }
        catch (IllegalArgumentException e) {
            isValid = false;
        }
        return isValid;
    }

    private void verify(short major) {
        if (major < 0 || major > 99) {
            throw new IllegalArgumentException("Illegal version");
        }
    }
}

