/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_6.common;

import com.ericsson.em.m3if.operations.adapter.DateAdapter;
import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.TransactionType;
import com.ericsson.em.m3if.v2_1.common.FinancialInstructionType;
import com.ericsson.em.m3if.v2_1.common.TransferType;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsPositiveLong;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_6/common", name="gettransactionhistoryentrydetailstype", propOrder={"financialTransactionId", "fromFRI", "toFRI", "amount", "type", "date", "instructionId", "transactionType", "fiType"})
public class GetTransactionHistoryEntryDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    @IsPositiveLong(allowZero=false)
    @XmlElement(name="financialtransactionid")
    private Long financialTransactionId;
    @IsFinancialResourceIdentifier
    @XmlElement(name="fromfri")
    private String fromFRI;
    @IsFinancialResourceIdentifier
    @XmlElement(name="tofri")
    private String toFRI;
    @Valid
    @XmlElement(name="amount", type=MoneyDetails.class)
    @IsPositiveAmount
    private MoneyDetails amount;
    @Valid
    @XmlElement(name="transfertype")
    private TransferType type;
    @XmlElement(name="date")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date date;
    @XmlElement(name="instructionid")
    private Long instructionId;
    @XmlElement(name="transactiontype")
    private TransactionType transactionType;
    @Valid
    @XmlElement(name="fitype")
    private FinancialInstructionType fiType;

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public Long getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public void setFinancialTransactionId(Long financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public String getFromFRI() {
        return this.fromFRI;
    }

    public void setFromFRI(String fromFRI) {
        this.fromFRI = fromFRI;
    }

    public String getToFRI() {
        return this.toFRI;
    }

    public void setToFRI(String toFRI) {
        this.toFRI = toFRI;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public TransferType getType() {
        return this.type;
    }

    public void setType(TransferType type) {
        this.type = type;
    }

    public DateTime getDate() {
        return DateHelper.fromDate(this.date);
    }

    public void setDate(DateTime date) {
        this.date = DateHelper.toDate(date);
    }

    public Long getInstructionId() {
        return this.instructionId;
    }

    public void setInstructionId(Long instructionId) {
        this.instructionId = instructionId;
    }

    public FinancialInstructionType getFiType() {
        return this.fiType;
    }

    public void setFiType(FinancialInstructionType fiType) {
        this.fiType = fiType;
    }
}

