/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.emm.util.SensitiveValueObject;
import com.ericsson.em.validators.IsASCIIToken;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="otptypevalue")
public class OtpTypeValue
extends SensitiveValueObject {
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static final Pattern MASK_PATTERN = Pattern.compile("\\d{4}(?= )(.*)");
    @IsASCIIToken
    @NotNull
    @NotBlank
    @XmlValue
    private final String value;

    protected OtpTypeValue() {
        this.value = null;
    }

    private OtpTypeValue(String value) {
        this.value = value;
    }

    @Override
    public Pattern getRegexToMaskWith() {
        return MASK_PATTERN;
    }

    public static OtpTypeValue fromString(String value) {
        if (value == null) {
            return null;
        }
        return new OtpTypeValue(value);
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    public static Optional<String> asString(OtpTypeValue token) {
        if (token == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(token.getValueAsString());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OtpTypeValue other = (OtpTypeValue)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

