/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.emm.util.ValueObject;
import com.ericsson.em.validators.IsExternalTransactionIdString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="externalid")
public class ExternalIdValue
implements Comparable<ExternalIdValue>,
Serializable,
ValueObject {
    private static final long serialVersionUID = 1L;
    @Length(max=30)
    @IsExternalTransactionIdString
    @NotNull
    @NotBlank
    @XmlValue
    private final String value;

    protected ExternalIdValue() {
        this.value = null;
    }

    private ExternalIdValue(String value) {
        this.value = value;
    }

    public static ExternalIdValue fromString(String value) {
        if (value == null) {
            return null;
        }
        return new ExternalIdValue(value);
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    public static Optional<String> asString(ExternalIdValue externalId) {
        if (externalId == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(externalId.getValueAsString());
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalIdValue other = (ExternalIdValue)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public int compareTo(ExternalIdValue o) {
        return this.value.compareTo(o.value);
    }
}

