/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.IsASCIISimpleString;
import com.ericsson.em.validators.IsPropertyValue;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="argumenttype", propOrder={"name", "textValue", "moneyValue"})
public class Argument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotBlank
    @IsASCIISimpleString
    @XmlElement(name="name", required=true)
    private String name;
    @NotBlank
    @IsPropertyValue
    @XmlElement(name="textvalue")
    private String textValue;
    @Valid
    @XmlElement(name="moneyvalue")
    @IsPositiveAmount
    private MoneyDetails moneyValue;

    public Argument() {
    }

    public Argument(String name, MoneyDetails value) {
        this.name = name;
        this.moneyValue = value;
    }

    public Argument(String name, String value) {
        this.name = name;
        this.textValue = value;
    }

    public MoneyDetails getMoneyValue() {
        return this.moneyValue;
    }

    public String getName() {
        return this.name;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public boolean isMoney() {
        return this.moneyValue != null;
    }

    public boolean isText() {
        return this.textValue != null;
    }

    public void setMoneyValue(MoneyDetails moneyValue) {
        this.moneyValue = moneyValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }
}

