/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.settlement.v2_0.paymentinstruction;

import com.ericsson.em.m3if.operations.annotations.IdentityTraceAction;
import com.ericsson.em.m3if.operations.annotations.IdentityTraceAsynchronousHint;
import com.ericsson.em.m3if.operations.annotations.SignedElements;
import com.ericsson.em.m3if.operations.validation.IsDateTimeValue;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.settlement.any.paymentinstruction.IPaymentInstructionRequest;
import com.ericsson.em.m3if.settlement.any.paymentinstruction.IPaymentInstructionResponse;
import com.ericsson.em.m3if.settlement.v2_0.paymentinstruction.PaymentInstructionResponse;
import com.ericsson.em.m3if.v1_0.common.DateTimeValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.IsBankAccount;
import com.ericsson.em.validators.IsBankCode;
import com.ericsson.em.validators.IsFirstname;
import com.ericsson.em.validators.IsIntegerStringWithinRange;
import com.ericsson.em.validators.IsLongString;
import com.ericsson.em.validators.IsMSISDN;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.IsSurname;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@IdentityTraceAsynchronousHint(action=IdentityTraceAction.REGISTER, field="paymentInstructionId", grouping="paymentinstruction")
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/settlement/v2_0", name="paymentinstructionrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/settlement/v2_0", name="", propOrder={"transactionTimeStamp", "amount", "paymentInstructionId", "receiverBankCode", "receiverAccountNumber", "receiverFirstname", "receiverSurname", "message", "receiverMsisdn", "transmissionCounter", "transactionId"})
@SignedElements(value={"amount/amount", "amount/currency", "paymentinstructionid", "receiverbankcode", "receiveraccountnumber"})
public class PaymentInstructionRequest
implements IPaymentInstructionRequest {
    @Valid
    @IsDateTimeValue
    @NotNull
    @XmlElement(name="transactiontimestamp", required=true)
    private DateTimeValue transactionTimeStamp;
    @NotNull
    @Valid
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    @IsPositiveAmount
    private MoneyDetails amount;
    @NotBlank
    @Length(max=32)
    @IsLongString(allowNegativeValue=false)
    @XmlElement(name="paymentinstructionid", required=true)
    private String paymentInstructionId;
    @IsBankCode
    @XmlElement(name="receiverbankcode", required=false)
    private String receiverBankCode;
    @NotNull
    @IsBankAccount
    @XmlElement(name="receiveraccountnumber", required=true)
    private String receiverAccountNumber;
    @IsFirstname
    @XmlElement(name="receiverfirstname", required=false)
    private String receiverFirstname;
    @IsSurname
    @XmlElement(name="receiversurname", required=false)
    private String receiverSurname;
    @Length(max=100)
    @IsRestrictedString
    @XmlElement(name="message", required=false)
    private String message;
    @IsMSISDN
    @XmlElement(name="receivermsisdn", required=false)
    private String receiverMsisdn;
    @NotBlank
    @IsIntegerStringWithinRange(min=0)
    @XmlElement(name="transmissioncounter", required=true)
    private String transmissionCounter;
    @NotBlank
    @Length(max=32)
    @IsLongString(allowNegativeValue=false)
    @XmlElement(name="transactionid", required=true)
    private String transactionId;

    public PaymentInstructionRequest() {
    }

    public PaymentInstructionRequest(DateTimeValue transactionTimeStamp, MoneyDetails amount, String paymentInstructionId, String receiverBankCode, String receiverAccountNumber) {
        this(transactionTimeStamp, amount, paymentInstructionId, receiverBankCode, receiverAccountNumber, null, null, null);
    }

    public PaymentInstructionRequest(DateTimeValue transactionTimeStamp, MoneyDetails amount, String paymentInstructionId, String receiverBankCode, String receiverAccountNumber, String receiverFirstname, String receiverSurname, String message) {
        this.transactionTimeStamp = transactionTimeStamp;
        this.amount = amount;
        this.paymentInstructionId = paymentInstructionId;
        this.receiverBankCode = receiverBankCode;
        this.receiverAccountNumber = receiverAccountNumber;
        this.receiverFirstname = receiverFirstname;
        this.receiverSurname = receiverSurname;
        this.message = message;
    }

    @Override
    public DateTimeValue getTransactionTimeStamp() {
        return this.transactionTimeStamp;
    }

    @Override
    public void setTransactionTimeStamp(DateTimeValue transactionTimeStamp) {
        this.transactionTimeStamp = transactionTimeStamp;
    }

    @Override
    public MoneyDetails getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    @Override
    public String getPaymentInstructionId() {
        return this.paymentInstructionId;
    }

    @Override
    public void setPaymentInstructionId(String paymentInstructionId) {
        this.paymentInstructionId = paymentInstructionId;
    }

    @Override
    public String getReceiverBankCode() {
        return this.receiverBankCode;
    }

    @Override
    public void setReceiverBankCode(String receiverBankCode) {
        this.receiverBankCode = receiverBankCode;
    }

    @Override
    public String getReceiverAccountNumber() {
        return this.receiverAccountNumber;
    }

    @Override
    public void setReceiverAccountNumber(String receiverAccountNumber) {
        this.receiverAccountNumber = receiverAccountNumber;
    }

    @Override
    public String getReceiverFirstname() {
        return this.receiverFirstname;
    }

    @Override
    public void setReceiverFirstname(String receiverFirstname) {
        this.receiverFirstname = receiverFirstname;
    }

    @Override
    public String getReceiverSurname() {
        return this.receiverSurname;
    }

    @Override
    public void setReceiverSurname(String receiverSurname) {
        this.receiverSurname = receiverSurname;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getReceiverMsisdn() {
        return this.receiverMsisdn;
    }

    @Override
    public void setReceiverMsisdn(String msisdn) {
        this.receiverMsisdn = msisdn;
    }

    @Override
    public String getTransmissionCounter() {
        return this.transmissionCounter;
    }

    @Override
    public void setTransmissionCounter(String transmissionCounter) {
        this.transmissionCounter = transmissionCounter;
    }

    @Override
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @Override
    public String getTransactionId() {
        return this.transactionId;
    }

    @Override
    public Class<? extends IPaymentInstructionRequest> requestClass() {
        return PaymentInstructionRequest.class;
    }

    @Override
    public Class<? extends IPaymentInstructionResponse> responseClass() {
        return PaymentInstructionResponse.class;
    }

    @Override
    public String getBankInstructionId() {
        return this.getPaymentInstructionId();
    }

    @Override
    public void setBankInstructionId(String instructionId) {
        this.setPaymentInstructionId(instructionId);
    }

    @Override
    public String getBankCode() {
        return this.getReceiverBankCode();
    }

    @Override
    public void setBankCode(String bankCode) {
        this.setReceiverBankCode(bankCode);
    }

    @Override
    public String getAccountNumber() {
        return this.getReceiverBankCode();
    }

    @Override
    public void setAccountNumber(String accountNumber) {
        this.setReceiverAccountNumber(accountNumber);
    }

    @Override
    public String getFirstname() {
        return this.getReceiverFirstname();
    }

    @Override
    public void setFirstname(String firstname) {
        this.setReceiverFirstname(firstname);
    }

    @Override
    public String getSurname() {
        return this.getReceiverSurname();
    }

    @Override
    public void setSurname(String surname) {
        this.setReceiverSurname(surname);
    }

    @Override
    public String getMsisdn() {
        return this.getReceiverMsisdn();
    }

    @Override
    public void setMsisdn(String msisdn) {
        this.setReceiverMsisdn(msisdn);
    }
}

