/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.settlement.v1_0.deposit;

import com.ericsson.em.m3if.operations.annotations.SignedElements;
import com.ericsson.em.m3if.operations.approvals.ExpiredApprovalAware;
import com.ericsson.em.m3if.operations.validation.IsDateTimeValue;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.AccountNumber;
import com.ericsson.em.m3if.v1_0.common.BankCode;
import com.ericsson.em.m3if.v1_0.common.DateTimeValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.IsExternalTransactionIdString;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsFirstname;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.IsSurname;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/settlement/v1_0", name="depositrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/settlement/v1_0", name="", propOrder={"bankCode", "accountNumber", "senderBankCode", "senderAccountNumber", "transactionTimeStamp", "amount", "receiver", "bankTransactionId", "receiverFirstname", "receiverSurname", "message"})
@SignedElements(value={"bankcode", "accountnumber", "amount/amount", "amount/currency", "receiver", "banktransactionid"})
public class DepositRequest
implements ExpiredApprovalAware {
    @XmlAttribute
    public static final String version = "1.0";
    @Valid
    @XmlElement(name="bankcode", type=BankCode.class, required=false)
    private BankCode bankCode;
    @Valid
    @NotNull
    @XmlElement(name="accountnumber", type=AccountNumber.class, required=true)
    private AccountNumber accountNumber;
    @Valid
    @XmlElement(name="senderbankcode", type=BankCode.class)
    private BankCode senderBankCode;
    @Valid
    @XmlElement(name="senderaccountnumber", type=AccountNumber.class)
    private AccountNumber senderAccountNumber;
    @Valid
    @NotNull
    @IsDateTimeValue
    @XmlElement(name="transactiontimestamp", required=true)
    private DateTimeValue transactionTimeStamp;
    @NotNull
    @Valid
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    @IsPositiveAmount
    private MoneyDetails amount;
    @NotNull
    @Length(max=100)
    @IsFinancialResourceIdentifier
    @XmlElement(name="receiver", required=true)
    private String receiver;
    @NotBlank
    @Length(max=100)
    @IsExternalTransactionIdString
    @XmlElement(name="banktransactionid", required=true)
    private String bankTransactionId;
    @IsFirstname
    @XmlElement(name="receiverfirstname", required=false)
    private String receiverFirstname;
    @IsSurname
    @XmlElement(name="receiversurname", required=false)
    private String receiverSurname;
    @Length(max=100)
    @IsRestrictedString
    @XmlElement(name="message", required=false)
    private String message;

    public DepositRequest() {
    }

    public DepositRequest(AccountNumber accountNumber, DateTimeValue transactionTimeStamp, MoneyDetails amount, String receiver, String bankTransactionId, String message) {
        this(null, accountNumber, transactionTimeStamp, amount, receiver, bankTransactionId, message);
    }

    public DepositRequest(BankCode bankCode, AccountNumber accountNumber, DateTimeValue transactionTimeStamp, MoneyDetails amount, String receiver, String bankTransactionId) {
        this(bankCode, accountNumber, transactionTimeStamp, amount, receiver, bankTransactionId, null);
    }

    public DepositRequest(AccountNumber accountNumber, DateTimeValue transactionTimeStamp, MoneyDetails amount, String receiver, String bankTransactionId) {
        this(null, accountNumber, transactionTimeStamp, amount, receiver, bankTransactionId, null);
    }

    public DepositRequest(BankCode bankCode, AccountNumber accountNumber, DateTimeValue transactionTimeStamp, MoneyDetails amount, String receiver, String bankTransactionId, String message) {
        this(bankCode, accountNumber, null, null, transactionTimeStamp, amount, receiver, bankTransactionId, message);
    }

    public DepositRequest(BankCode bankCode, AccountNumber accountNumber, BankCode senderBankCode, AccountNumber senderAccountNumber, DateTimeValue transactionTimeStamp, MoneyDetails amount, String receiver, String bankTransactionId, String message) {
        this.bankCode = bankCode;
        this.accountNumber = accountNumber;
        this.senderBankCode = senderBankCode;
        this.senderAccountNumber = senderAccountNumber;
        this.transactionTimeStamp = transactionTimeStamp;
        this.amount = amount;
        this.receiver = receiver;
        this.bankTransactionId = bankTransactionId;
        this.message = message;
    }

    public BankCode getBankCode() {
        return this.bankCode;
    }

    public void setBankCode(BankCode bankCode) {
        this.bankCode = bankCode;
    }

    public AccountNumber getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(AccountNumber accountNumber) {
        this.accountNumber = accountNumber;
    }

    public DateTimeValue getTransactionTimeStamp() {
        return this.transactionTimeStamp;
    }

    public void setTransactionTimeStamp(DateTimeValue transactionTimeStamp) {
        this.transactionTimeStamp = transactionTimeStamp;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public String getBankTransactionId() {
        return this.bankTransactionId;
    }

    public void setBankTransactionId(String bankTransactionId) {
        this.bankTransactionId = bankTransactionId;
    }

    public String getReceiverFirstname() {
        return this.receiverFirstname;
    }

    public void setReceiverFirstname(String receiverFirstname) {
        this.receiverFirstname = receiverFirstname;
    }

    public String getReceiverSurname() {
        return this.receiverSurname;
    }

    public void setReceiverSurname(String receiverSurname) {
        this.receiverSurname = receiverSurname;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public BankCode getSenderBankCode() {
        return this.senderBankCode;
    }

    public void setSenderBankCode(BankCode senderBankCode) {
        this.senderBankCode = senderBankCode;
    }

    public AccountNumber getSenderAccountNumber() {
        return this.senderAccountNumber;
    }

    public void setSenderAccountNumber(AccountNumber senderAccountNumber) {
        this.senderAccountNumber = senderAccountNumber;
    }

    @Override
    public Optional<String> getSendingFri() {
        return Optional.empty();
    }

    @Override
    public Optional<String> getReceivingFri() {
        return Optional.of(this.receiver);
    }

    @Override
    public Optional<String> getSupplementaryData() {
        return Optional.of("Bank transaction id: " + this.bankTransactionId);
    }
}

